/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.simplechunkloaders.base;

import com.google.common.collect.Lists;
import com.valkyrieofnight.simplechunkloaders.SimpleChunkLoaders;
import com.valkyrieofnight.simplechunkloaders.base.ILoaderList;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;

public class LoaderList
extends WorldSavedData
implements ILoaderList {
    protected List<BlockPos> loaded = Lists.newCopyOnWriteArrayList();
    protected final ServerWorld world;
    protected boolean loadingData = false;

    public LoaderList(ServerWorld world) {
        super("simplechunkloaders_loaded");
        this.world = world;
    }

    @Override
    public void load(BlockPos pos) {
        if (pos != null && !this.loaded.contains(pos)) {
            if (!this.loadingData) {
                this.chunkLoad(pos);
            }
            this.loaded.add(pos);
        }
    }

    @Override
    public void unLoad(BlockPos pos) {
        if (pos != null && this.loaded.contains(pos)) {
            if (!this.loadingData) {
                this.chunkUnLoad(pos);
            }
            this.loaded.remove(pos);
        }
    }

    @Override
    public boolean contains(BlockPos pos) {
        return pos == null ? false : this.loaded.contains(pos);
    }

    protected void chunkLoad(BlockPos pos) {
        if (this.world == null || this.world.func_73046_m() == null) {
            return;
        }
        CommandSource cs = this.world.func_73046_m().func_195573_aM().func_201003_a(this.world).func_197031_a();
        if (!SimpleChunkLoaders.display_loaded_info) {
            cs.func_197031_a();
        }
        this.world.func_73046_m().func_195571_aL().func_197059_a(cs, "forceload add " + pos.func_177958_n() + " " + pos.func_177952_p());
    }

    protected void chunkUnLoad(BlockPos pos) {
        if (this.world == null || this.world.func_73046_m() == null) {
            return;
        }
        CommandSource cs = this.world.func_73046_m().func_195573_aM().func_201003_a(this.world).func_197031_a();
        if (!SimpleChunkLoaders.display_loaded_info) {
            cs.func_197031_a();
        }
        this.loaded.remove(pos);
        if (!this.containsOtherLoaders(pos)) {
            this.world.func_73046_m().func_195571_aL().func_197059_a(cs, "forceload remove " + pos.func_177958_n() + " " + pos.func_177952_p());
        }
    }

    private boolean containsOtherLoaders(BlockPos pos) {
        ChunkPos cp = new ChunkPos(pos);
        for (BlockPos p : this.loaded) {
            ChunkPos pcp = new ChunkPos(p);
            if (!cp.equals((Object)pcp)) continue;
            return true;
        }
        return false;
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.loaded = Lists.newLinkedList();
        ListNBT list = nbt.func_150295_c("positions", 11);
        for (int i = 0; i < list.size(); ++i) {
            int[] pos = list.func_150306_c(i);
            BlockPos bp = new BlockPos(pos[0], pos[1], pos[2]);
            this.loaded.add(bp);
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        ListNBT list = new ListNBT();
        for (int i = 0; i < this.loaded.size(); ++i) {
            BlockPos p = this.loaded.get(i);
            list.add(i, (INBT)new IntArrayNBT(new int[]{p.func_177958_n(), p.func_177956_o(), p.func_177952_p()}));
        }
        compound.func_218657_a("positions", (INBT)list);
        return compound;
    }

    public static LoaderList getOrLoadData(ServerWorld world) {
        return (LoaderList)world.func_217481_x().func_215752_a(() -> new LoaderList(world), "simplechunkloaders_loaded_list");
    }
}

