/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbchunks.impl.map;

import com.feed_the_beast.mods.ftbchunks.api.ChunkDimPos;
import com.feed_the_beast.mods.ftbchunks.impl.ClaimedChunkImpl;
import com.feed_the_beast.mods.ftbchunks.impl.FTBChunksAPIImpl;
import com.feed_the_beast.mods.ftbchunks.impl.map.ColorBlend;
import com.feed_the_beast.mods.ftbchunks.impl.map.MapChunk;
import com.feed_the_beast.mods.ftbchunks.impl.map.MapRegion;
import com.feed_the_beast.mods.ftbchunks.impl.map.MapTask;
import com.feed_the_beast.mods.ftbchunks.impl.map.XZ;
import com.feed_the_beast.mods.ftbchunks.net.FTBChunksNet;
import com.feed_the_beast.mods.ftbchunks.net.SendChunkPacket;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraftforge.fml.network.PacketDistributor;

public class SendChunkTask
implements MapTask {
    private final World world;
    private final XZ chunkPosition;
    private final Predicate<ServerPlayerEntity> sendTo;

    public SendChunkTask(World w, XZ pos, Predicate<ServerPlayerEntity> p) {
        this.world = w;
        this.chunkPosition = pos;
        this.sendTo = p;
    }

    private static EitherChunk getChunkForHeight(World world, int x, int z) {
        EitherChunk e = new EitherChunk();
        MapRegion region = FTBChunksAPIImpl.manager.map.getDimension(world.func_201675_m().func_186058_p()).getRegion(XZ.regionFromChunk(x, z));
        MapChunk mapChunk = region.chunks.get(XZ.of(x & 0x1F, z & 0x1F));
        if (mapChunk != null) {
            e.mapChunk = mapChunk;
        } else {
            e.chunk = world.func_217353_a(x, z, ChunkStatus.field_222617_m, false);
        }
        return e;
    }

    private static int getHeight(EitherChunk e, BlockPos.Mutable currentBlockPos, int x, int z, int topY) {
        if (e.mapChunk != null) {
            return e.mapChunk.getHeight(x & 0xF, z & 0xF);
        }
        if (e.chunk != null) {
            return MapChunk.getHeight(e.chunk, currentBlockPos, x, z, topY);
        }
        return -1;
    }

    @Override
    public void run() {
        List players = FTBChunksAPIImpl.manager.server.func_184103_al().func_181057_v().stream().filter(this.sendTo).collect(Collectors.toList());
        if (players.isEmpty()) {
            return;
        }
        ChunkDimPos chunkDimPos = this.chunkPosition.dim(this.world.field_73011_w.func_186058_p());
        MapChunk c = FTBChunksAPIImpl.manager.map.getChunk(chunkDimPos);
        EitherChunk cn = SendChunkTask.getChunkForHeight(this.world, chunkDimPos.x, chunkDimPos.z - 1);
        EitherChunk ce = SendChunkTask.getChunkForHeight(this.world, chunkDimPos.x - 1, chunkDimPos.z);
        EitherChunk cne = SendChunkTask.getChunkForHeight(this.world, chunkDimPos.x - 1, chunkDimPos.z - 1);
        int topY = this.world.func_72940_L() + 1;
        BlockPos.Mutable currentBlockPos = new BlockPos.Mutable();
        int blockX = this.chunkPosition.x << 4;
        int blockZ = this.chunkPosition.z << 4;
        int[][] heightMap = new int[17][17];
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                heightMap[x + 1][z + 1] = c.getHeight(x, z);
            }
        }
        for (int i = 0; i < 16; ++i) {
            heightMap[i + 1][0] = SendChunkTask.getHeight(cn, currentBlockPos, blockX + i, blockZ - 1, topY);
            heightMap[0][i + 1] = SendChunkTask.getHeight(ce, currentBlockPos, blockX - 1, blockZ + i, topY);
        }
        heightMap[0][0] = SendChunkTask.getHeight(cne, currentBlockPos, blockX - 1, blockZ - 1, topY);
        BufferedImage image = new BufferedImage(16, 16, 2);
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                int col;
                int by = heightMap[x + 1][z + 1];
                int bn = heightMap[x + 1][z + 1 - 1];
                int bw = heightMap[x + 1 - 1][z + 1];
                float addedBrightness = 0.0f;
                if (bn != -1 || bw != -1) {
                    if (by > bn || by > bw) {
                        addedBrightness += 0.08f;
                    }
                    if (by < bn || by < bw) {
                        addedBrightness -= 0.08f;
                    }
                }
                if ((col = ColorBlend.addBrightness(c.getRGB(x, z), addedBrightness)) == -16777216) {
                    col = -16711423;
                }
                image.setRGB(x, z, col);
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "PNG", baos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        SendChunkPacket packet = new SendChunkPacket();
        packet.dimension = this.world.field_73011_w.func_186058_p();
        packet.x = this.chunkPosition.x;
        packet.z = this.chunkPosition.z;
        packet.imageData = baos.toByteArray();
        ClaimedChunkImpl claimedChunk = FTBChunksAPIImpl.manager.getChunk(this.chunkPosition.dim(c.region.dimension.dimension));
        if (claimedChunk != null) {
            long now = new Date().getTime();
            packet.owner = claimedChunk.getDisplayName();
            packet.color = 0xFF000000 | claimedChunk.getColor();
            packet.relativeTimeClaimed = now - Date.from(claimedChunk.getTimeClaimed()).getTime();
            packet.forceLoaded = claimedChunk.isForceLoaded();
            if (packet.forceLoaded) {
                packet.relativeTimeForceLoaded = now - Date.from(claimedChunk.getForceLoadedTime()).getTime();
            }
        }
        for (ServerPlayerEntity player : players) {
            FTBChunksNet.MAIN.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
        }
    }

    private static class EitherChunk {
        private IChunk chunk;
        public MapChunk mapChunk;

        private EitherChunk() {
        }
    }
}

