/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbchunks.impl.map;

import com.feed_the_beast.mods.ftbchunks.FTBChunks;
import com.feed_the_beast.mods.ftbchunks.impl.FTBChunksAPIImpl;
import com.feed_the_beast.mods.ftbchunks.impl.map.ColorBlend;
import com.feed_the_beast.mods.ftbchunks.impl.map.MapChunk;
import com.feed_the_beast.mods.ftbchunks.impl.map.MapTask;
import com.feed_the_beast.mods.ftbchunks.impl.map.XZ;
import com.feed_the_beast.mods.ftbguilibrary.icon.Color4I;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.IProperty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;

public class ReloadChunkTask
implements MapTask {
    public final World world;
    public final XZ chunkPosition;
    private final Callback callback;

    public static int reduce(int c) {
        float f = (float)(c & 0xFF) / 255.0f;
        int c1 = (int)(f * 64.0f);
        float f1 = (float)c1 / 64.0f;
        return (int)(f1 * 255.0f);
    }

    public ReloadChunkTask(World w, XZ pos, Callback c) {
        this.world = w;
        this.chunkPosition = pos;
        this.callback = c;
    }

    @Override
    public void run() {
        MapChunk data = FTBChunksAPIImpl.manager.map.getChunk(this.chunkPosition.dim(this.world.field_73011_w.func_186058_p()));
        XZ c = data.getActualPos();
        IChunk ichunk = this.world.func_217353_a(c.x, c.z, ChunkStatus.field_222617_m, true);
        if (!(ichunk instanceof Chunk)) {
            return;
        }
        Chunk chunk = (Chunk)ichunk;
        BlockPos.Mutable currentBlockPos = new BlockPos.Mutable(0, 0, 0);
        int x = c.x << 4;
        int z = c.z << 4;
        boolean changed = false;
        try {
            int topY = this.world.func_72940_L() + 1;
            for (int wi = 0; wi < 256; ++wi) {
                int wx = wi % 16;
                int wz = wi / 16;
                int by = MapChunk.getHeight((IChunk)chunk, currentBlockPos, x + wx, z + wz, topY);
                if (by == -1) {
                    data.setHRGB(wx, wz, 0);
                    continue;
                }
                BlockState state = chunk.func_180495_p((BlockPos)currentBlockPos);
                Color4I color = null;
                if (state.func_177230_c() instanceof FlowingFluidBlock && ((FlowingFluidBlock)state.func_177230_c()).getFluid().func_207187_a((Fluid)Fluids.field_204546_a) || FTBChunksAPIImpl.MAP_IGNORE_IN_WATER_TAG.func_199685_a_((Object)state.func_177230_c())) {
                    for (int depth = 1; depth < 50; ++depth) {
                        currentBlockPos.func_181079_c(x + wx, by - depth, z + wz);
                        BlockState state1 = chunk.func_180495_p((BlockPos)currentBlockPos);
                        if (state1.func_177230_c() instanceof FlowingFluidBlock || FTBChunksAPIImpl.MAP_IGNORE_IN_WATER_TAG.func_199685_a_((Object)state1.func_177230_c())) continue;
                        Color4I fluidColor = Color4I.rgb((int)ColorBlend.WATER.blend(this.world, (BlockPos)currentBlockPos, 2)).withAlpha(220);
                        color = FTBChunksAPIImpl.COLOR_MAP.get(state1.func_177230_c());
                        if (color == null) {
                            color = Color4I.rgb((int)state1.func_185909_g((IBlockReader)this.world, (BlockPos)currentBlockPos).field_76291_p);
                        }
                        color = color.withTint(fluidColor);
                        break;
                    }
                } else if (state.func_177230_c() instanceof GrassBlock) {
                    color = Color4I.rgb((int)ColorBlend.GRASS.blend(this.world, (BlockPos)currentBlockPos, 2)).withTint(Color4I.BLACK.withAlpha(50));
                } else if (state.func_177230_c() instanceof LeavesBlock || state.func_177230_c() instanceof VineBlock) {
                    color = Color4I.rgb((int)ColorBlend.FOLIAGE.blend(this.world, (BlockPos)currentBlockPos, 2)).withTint(Color4I.BLACK.withAlpha(50));
                } else if (state.func_177230_c() instanceof RedstoneWireBlock) {
                    color = Color4I.rgb((int)ReloadChunkTask.redstoneColor((Integer)state.func_177229_b((IProperty)RedstoneWireBlock.field_176351_O)));
                }
                if (color == null) {
                    color = FTBChunksAPIImpl.COLOR_MAP.get(state.func_177230_c());
                }
                if (color == null) {
                    MaterialColor materialColor = state.func_185909_g((IBlockReader)this.world, (BlockPos)currentBlockPos);
                    Color4I color4I = color = materialColor == null ? Color4I.RED : Color4I.rgb((int)materialColor.field_76291_p);
                }
                if (!data.setHRGB(wx, wz, by << 24 | color.rgb())) continue;
                changed = true;
            }
            FTBChunks.LOGGER.debug("Reloaded chunk " + data.pos + " in " + data.region.pos + " (" + FTBChunksAPIImpl.manager.map.taskQueue.size() + " tasks left)");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.callback.accept(this, changed);
    }

    private static int redstoneColor(int power) {
        float f = (float)power / 15.0f;
        float f1 = f * 0.6f + 0.4f;
        if (power == 0) {
            f1 = 0.3f;
        }
        float f2 = f * f * 0.7f - 0.5f;
        float f3 = f * f * 0.6f - 0.7f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        int i = MathHelper.func_76125_a((int)((int)(f1 * 255.0f)), (int)0, (int)255);
        int j = MathHelper.func_76125_a((int)((int)(f2 * 255.0f)), (int)0, (int)255);
        int k = MathHelper.func_76125_a((int)((int)(f3 * 255.0f)), (int)0, (int)255);
        return 0xFF000000 | i << 16 | j << 8 | k;
    }

    public void send(Predicate<ServerPlayerEntity> predicate) {
        FTBChunksAPIImpl.manager.map.queueSend(this.world, this.chunkPosition, predicate);
    }

    public static interface Callback {
        public void accept(ReloadChunkTask var1, boolean var2);
    }
}

