/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbchunks.client;

import com.feed_the_beast.mods.ftbchunks.FTBChunksCommon;
import com.feed_the_beast.mods.ftbchunks.api.Waypoint;
import com.feed_the_beast.mods.ftbchunks.client.EntityIcons;
import com.feed_the_beast.mods.ftbchunks.client.FTBChunksClientConfig;
import com.feed_the_beast.mods.ftbchunks.client.LargeMapScreen;
import com.feed_the_beast.mods.ftbchunks.client.MinimapPosition;
import com.feed_the_beast.mods.ftbchunks.client.PlayerListScreen;
import com.feed_the_beast.mods.ftbchunks.client.map.ClientMapChunk;
import com.feed_the_beast.mods.ftbchunks.client.map.ClientMapDimension;
import com.feed_the_beast.mods.ftbchunks.client.map.ClientMapManager;
import com.feed_the_beast.mods.ftbchunks.client.map.ClientMapRegion;
import com.feed_the_beast.mods.ftbchunks.client.map.PlayerHeadTexture;
import com.feed_the_beast.mods.ftbchunks.impl.map.ColorBlend;
import com.feed_the_beast.mods.ftbchunks.impl.map.MapTask;
import com.feed_the_beast.mods.ftbchunks.impl.map.XZ;
import com.feed_the_beast.mods.ftbchunks.net.LoginDataPacket;
import com.feed_the_beast.mods.ftbchunks.net.SendChunkPacket;
import com.feed_the_beast.mods.ftbchunks.net.SendGeneralDataPacket;
import com.feed_the_beast.mods.ftbchunks.net.SendPlayerListPacket;
import com.feed_the_beast.mods.ftbchunks.net.SendWaypointsPacket;
import com.feed_the_beast.mods.ftbguilibrary.icon.ImageIcon;
import com.feed_the_beast.mods.ftbguilibrary.utils.ClientUtils;
import com.feed_the_beast.mods.ftbguilibrary.utils.MathUtils;
import com.feed_the_beast.mods.ftbguilibrary.widget.CustomClickEvent;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.util.UUIDTypeAdapter;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.util.ArrayDeque;
import java.util.Date;
import java.util.Random;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.monster.IMob;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.loading.FMLPaths;

public class FTBChunksClient
extends FTBChunksCommon {
    private static final ResourceLocation BUTTON_ID = new ResourceLocation("ftbchunks:open_gui");
    public static final ResourceLocation MAP_ICONS = new ResourceLocation("textures/map/map_icons.png");
    public static final ResourceLocation CIRCLE_MASK = new ResourceLocation("ftbchunks:textures/circle_mask.png");
    public static final ResourceLocation CIRCLE_BORDER = new ResourceLocation("ftbchunks:textures/circle_border.png");
    public static final ResourceLocation[] COMPASS = new ResourceLocation[]{new ResourceLocation("ftbchunks:textures/compass_e.png"), new ResourceLocation("ftbchunks:textures/compass_n.png"), new ResourceLocation("ftbchunks:textures/compass_w.png"), new ResourceLocation("ftbchunks:textures/compass_s.png")};
    public static final ArrayDeque<MapTask> taskQueue = new ArrayDeque();
    private static long taskQueueTicks = 0L;
    public static KeyBinding openMapKey;
    public static int minimapTextureId;
    private static int currentPlayerChunkX;
    private static int currentPlayerChunkZ;
    private boolean updateMinimap = false;
    public static SendGeneralDataPacket generalData;
    private long nextRegionSave = 0L;

    @Override
    public void init() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FTBChunksClientConfig.init();
        openMapKey = new KeyBinding("key.ftbchunks.map", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputMappings.Type.KEYSYM, 77, "key.categories.ui");
        ClientRegistry.registerKeyBinding((KeyBinding)openMapKey);
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_219534_a((IFutureReloadListener)new EntityIcons());
    }

    public static void openGui() {
        new LargeMapScreen().openGui();
    }

    public static void saveAllRegions() {
        for (ClientMapDimension dimension : ClientMapManager.inst.dimensions.values()) {
            for (ClientMapRegion region : dimension.regions.values()) {
                if (!region.saveImage) continue;
                taskQueue.addLast(region);
                region.saveImage = false;
            }
        }
    }

    @Override
    public void login(LoginDataPacket loginData) {
        ClientMapManager.inst = new ClientMapManager(loginData.serverId, FMLPaths.GAMEDIR.get().resolve("local/ftbchunks/map/" + loginData.serverId));
        ClientMapDimension.current = ClientMapManager.inst.getDimension(Minecraft.func_71410_x().field_71441_e.field_73011_w.func_186058_p());
        this.updateMinimap = true;
    }

    @Override
    public void updateGeneralData(SendGeneralDataPacket packet) {
        generalData = packet;
    }

    @Override
    public void updateChunk(SendChunkPacket packet) {
        try {
            BufferedImage image = ImageIO.read(new ByteArrayInputStream(packet.imageData));
            ClientMapChunk chunk = ClientMapManager.inst.getDimension(packet.dimension).getRegion(XZ.regionFromChunk(packet.x, packet.z)).getChunk(XZ.of(packet.x, packet.z));
            Date now = new Date();
            chunk.claimedDate = packet.owner == null ? null : new Date(now.getTime() - packet.relativeTimeClaimed);
            chunk.forceLoadedDate = packet.forceLoaded && chunk.claimedDate != null ? new Date(now.getTime() - packet.relativeTimeForceLoaded) : null;
            chunk.color = packet.color;
            chunk.formattedOwner = packet.owner == null ? "" : packet.owner.func_150254_d();
            boolean updateRegion = false;
            Random random = new Random((long)packet.x * 31L + (long)packet.z);
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    int c = chunk.region.getImage().func_195709_a(chunk.pos.x * 16 + x, chunk.pos.z * 16 + z);
                    int h0 = NativeImage.func_227786_a_((int)c);
                    int r0 = NativeImage.func_227791_b_((int)c);
                    int g0 = NativeImage.func_227793_c_((int)c);
                    int b0 = NativeImage.func_227795_d_((int)c);
                    int nc = image.getRGB(x, z);
                    if (FTBChunksClientConfig.noise != 0.0) {
                        nc = ColorBlend.addBrightness(nc, (float)((double)random.nextFloat() * FTBChunksClientConfig.noise - FTBChunksClientConfig.noise / 2.0));
                    }
                    int h = nc >> 24 & 0xFF;
                    int r = nc >> 16 & 0xFF;
                    int g = nc >> 8 & 0xFF;
                    int b = nc >> 0 & 0xFF;
                    if (h0 == h && r0 == r && g0 == g && b0 == b) continue;
                    chunk.region.getImage().func_195700_a(chunk.pos.x * 16 + x, chunk.pos.z * 16 + z, NativeImage.func_227787_a_((int)h, (int)b, (int)g, (int)r));
                    updateRegion = true;
                }
            }
            if (updateRegion) {
                chunk.region.saveImage = true;
                this.updateMinimap = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void updateWaypoints(SendWaypointsPacket packet) {
        for (ClientMapDimension dimension : ClientMapManager.inst.dimensions.values()) {
            dimension.waypoints.clear();
        }
        for (Waypoint waypoint : packet.waypoints) {
            ClientMapManager.inst.getDimension((DimensionType)waypoint.dimension).waypoints.add(waypoint);
        }
    }

    @Override
    public void openPlayerList(SendPlayerListPacket packet) {
        new PlayerListScreen(packet.players, packet.allyMode).openGui();
    }

    @SubscribeEvent
    public void customClick(CustomClickEvent event) {
        if (event.getId().equals((Object)BUTTON_ID)) {
            FTBChunksClient.openGui();
        }
    }

    @SubscribeEvent
    public void keyEvent(InputEvent.KeyInputEvent event) {
        if (openMapKey.func_151468_f()) {
            FTBChunksClient.openGui();
        }
    }

    @SubscribeEvent
    public void guiKeyEvent(GuiScreenEvent.KeyboardKeyPressedEvent.Pre event) {
        LargeMapScreen gui;
        if (openMapKey.func_151468_f() && (gui = (LargeMapScreen)((Object)ClientUtils.getCurrentGuiAs(LargeMapScreen.class))) != null) {
            gui.closeGui(false);
        }
    }

    @SubscribeEvent
    public void renderGameOverlay(RenderGameOverlayEvent.Post event) {
        double ws;
        double wy;
        double wx;
        double d;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null || event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if (ClientMapManager.inst == null) {
            return;
        }
        if (ClientMapDimension.current == null || ClientMapDimension.current.dimension != mc.field_71441_e.func_201675_m().func_186058_p()) {
            ClientMapDimension.current = ClientMapManager.inst.getDimension(mc.field_71441_e.func_201675_m().func_186058_p());
        }
        long now = System.currentTimeMillis();
        if (this.nextRegionSave == 0L || now >= this.nextRegionSave) {
            this.nextRegionSave = now + 60000L;
            FTBChunksClient.saveAllRegions();
        }
        if (minimapTextureId == -1) {
            minimapTextureId = TextureUtil.func_225678_a_();
            TextureUtil.func_225680_a_((int)minimapTextureId, (int)240, (int)240);
            this.updateMinimap = true;
        }
        RenderSystem.enableTexture();
        RenderSystem.bindTexture((int)minimapTextureId);
        if (FTBChunksClientConfig.minimapBlur) {
            RenderSystem.texParameter((int)3553, (int)10241, (int)9729);
            RenderSystem.texParameter((int)3553, (int)10240, (int)9729);
        } else {
            RenderSystem.texParameter((int)3553, (int)10241, (int)9728);
            RenderSystem.texParameter((int)3553, (int)10240, (int)9728);
        }
        int cx = mc.field_71439_g.field_70176_ah;
        int cz = mc.field_71439_g.field_70164_aj;
        if (cx != currentPlayerChunkX || cz != currentPlayerChunkZ) {
            this.updateMinimap = true;
        }
        if (this.updateMinimap) {
            this.updateMinimap = false;
            for (int mz = 0; mz < 15; ++mz) {
                for (int mx = 0; mx < 15; ++mx) {
                    int ox = cx + mx - 7;
                    int oz = cz + mz - 7;
                    ClientMapRegion region = ClientMapDimension.current.getRegion(XZ.regionFromChunk(ox, oz));
                    region.getImage().func_227788_a_(0, mx * 16, mz * 16, (ox & 0x1F) * 16, (oz & 0x1F) * 16, 16, 16, false, false);
                }
            }
            currentPlayerChunkX = cx;
            currentPlayerChunkZ = cz;
        }
        if (mc.field_71474_y.field_74330_P || FTBChunksClientConfig.minimap == MinimapPosition.DISABLED) {
            return;
        }
        double scale = FTBChunksClientConfig.minimapScale * 4.0 / mc.func_228018_at_().func_198100_s();
        int s = (int)(64.0 * scale);
        int x = FTBChunksClientConfig.minimap.getX(mc.func_228018_at_().func_198107_o(), s);
        int y = FTBChunksClientConfig.minimap.getY(mc.func_228018_at_().func_198087_p(), s);
        boolean z = false;
        double border = 0.0;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        float f0 = 0.06666667f;
        float f1 = 1.0f - f0;
        float offX = (float)((mc.field_71439_g.func_226277_ct_() / 16.0 - (double)currentPlayerChunkX - 0.5) / 15.0);
        float offY = (float)((mc.field_71439_g.func_226281_cx_() / 16.0 - (double)currentPlayerChunkZ - 0.5) / 15.0);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableCull();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableTexture();
        RenderSystem.enableDepthTest();
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)((double)x + (double)s / 2.0), (double)((double)y + (double)s / 2.0), (double)0.0);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        mc.func_110434_K().func_110577_a(CIRCLE_MASK);
        buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        buffer.func_225582_a_((double)(-s) / 2.0 + border, (double)(-s) / 2.0 + border, (double)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 0.0f).func_181675_d();
        buffer.func_225582_a_((double)(-s) / 2.0 + border, (double)s / 2.0 - border, (double)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 1.0f).func_181675_d();
        buffer.func_225582_a_((double)s / 2.0 - border, (double)s / 2.0 - border, (double)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 1.0f).func_181675_d();
        buffer.func_225582_a_((double)s / 2.0 - border, (double)(-s) / 2.0 + border, (double)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.rotatef((float)(-mc.field_71439_g.field_70177_z + 180.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        RenderSystem.depthFunc((int)518);
        RenderSystem.bindTexture((int)minimapTextureId);
        buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        buffer.func_225582_a_((double)(-s) / 2.0 + border, (double)(-s) / 2.0 + border, (double)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(f0 + offX, f0 + offY).func_181675_d();
        buffer.func_225582_a_((double)(-s) / 2.0 + border, (double)s / 2.0 - border, (double)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(f0 + offX, f1 + offY).func_181675_d();
        buffer.func_225582_a_((double)s / 2.0 - border, (double)s / 2.0 - border, (double)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(f1 + offX, f1 + offY).func_181675_d();
        buffer.func_225582_a_((double)s / 2.0 - border, (double)(-s) / 2.0 + border, (double)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(f1 + offX, f0 + offY).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.popMatrix();
        RenderSystem.depthFunc((int)515);
        RenderSystem.defaultBlendFunc();
        mc.func_110434_K().func_110577_a(CIRCLE_BORDER);
        buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        buffer.func_225582_a_((double)x, (double)y, (double)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 0.0f).func_181675_d();
        buffer.func_225582_a_((double)x, (double)(y + s), (double)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 1.0f).func_181675_d();
        buffer.func_225582_a_((double)(x + s), (double)(y + s), (double)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 1.0f).func_181675_d();
        buffer.func_225582_a_((double)(x + s), (double)y, (double)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.disableTexture();
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        buffer.func_225582_a_((double)x + (double)s / 2.0, (double)(y + 0), (double)z).func_225586_a_(0, 0, 0, 30).func_181675_d();
        buffer.func_225582_a_((double)x + (double)s / 2.0, (double)(y + s), (double)z).func_225586_a_(0, 0, 0, 30).func_181675_d();
        buffer.func_225582_a_((double)(x + 0), (double)y + (double)s / 2.0, (double)z).func_225586_a_(0, 0, 0, 30).func_181675_d();
        buffer.func_225582_a_((double)(x + s), (double)y + (double)s / 2.0, (double)z).func_225586_a_(0, 0, 0, 30).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.enableTexture();
        if (FTBChunksClientConfig.minimapCompass) {
            for (int face = 0; face < 4; ++face) {
                double d2 = (double)s / 2.2;
                double angle = ((double)(-mc.field_71439_g.field_70759_as) - 180.0 - (double)face * 90.0) * Math.PI / 180.0;
                double wx2 = (double)x + (double)s / 2.0 + Math.cos(angle) * d2;
                double wy2 = (double)y + (double)s / 2.0 + Math.sin(angle) * d2;
                double ws2 = (double)s / 32.0;
                mc.field_71446_o.func_110577_a(COMPASS[face]);
                buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
                buffer.func_225582_a_(wx2 - ws2, wy2 - ws2, (double)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 0.0f).func_181675_d();
                buffer.func_225582_a_(wx2 - ws2, wy2 + ws2, (double)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 1.0f).func_181675_d();
                buffer.func_225582_a_(wx2 + ws2, wy2 + ws2, (double)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 1.0f).func_181675_d();
                buffer.func_225582_a_(wx2 + ws2, wy2 - ws2, (double)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 0.0f).func_181675_d();
                tessellator.func_78381_a();
            }
        }
        if (FTBChunksClientConfig.minimapWaypoints && !ClientMapDimension.current.waypoints.isEmpty()) {
            for (Waypoint waypoint : ClientMapDimension.current.waypoints) {
                d = MathUtils.dist((double)mc.field_71439_g.func_226277_ct_(), (double)mc.field_71439_g.func_226281_cx_(), (double)waypoint.x, (double)waypoint.z) / 3.2 * scale;
                if (d > (double)s / 2.0) {
                    d = (double)s / 2.0;
                }
                double angle = Math.atan2(mc.field_71439_g.func_226281_cx_() - (double)waypoint.z, mc.field_71439_g.func_226277_ct_() - (double)waypoint.x) + (double)(-mc.field_71439_g.field_70177_z) * Math.PI / 180.0;
                wx = (double)x + (double)s / 2.0 + Math.cos(angle) * d;
                wy = (double)y + (double)s / 2.0 + Math.sin(angle) * d;
                ws = (double)s / 32.0;
                int r = waypoint.color >> 16 & 0xFF;
                int g = waypoint.color >> 8 & 0xFF;
                int b = waypoint.color >> 0 & 0xFF;
                mc.func_110434_K().func_110577_a(waypoint.type.texture);
                buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
                buffer.func_225582_a_(wx - ws, wy - ws, (double)z).func_225586_a_(r, g, b, 255).func_225583_a_(0.0f, 0.0f).func_181675_d();
                buffer.func_225582_a_(wx - ws, wy + ws, (double)z).func_225586_a_(r, g, b, 255).func_225583_a_(0.0f, 1.0f).func_181675_d();
                buffer.func_225582_a_(wx + ws, wy + ws, (double)z).func_225586_a_(r, g, b, 255).func_225583_a_(1.0f, 1.0f).func_181675_d();
                buffer.func_225582_a_(wx + ws, wy - ws, (double)z).func_225586_a_(r, g, b, 255).func_225583_a_(1.0f, 0.0f).func_181675_d();
                tessellator.func_78381_a();
            }
        }
        if (FTBChunksClientConfig.minimapEntities) {
            for (Entity entity : mc.field_71441_e.func_217416_b()) {
                ResourceLocation texture;
                if (entity instanceof AbstractClientPlayerEntity || entity.func_200600_R().func_220339_d() == EntityClassification.MISC || (d = MathUtils.dist((double)mc.field_71439_g.func_226277_ct_(), (double)mc.field_71439_g.func_226281_cx_(), (double)entity.func_226277_ct_(), (double)entity.func_226281_cx_()) / 3.2 * scale) > (double)s / 2.0 || (texture = EntityIcons.ENTITY_ICONS.get(entity.func_200600_R())) == EntityIcons.INVISIBLE) continue;
                if (texture == null || !FTBChunksClientConfig.minimapEntityHeads) {
                    texture = entity instanceof IMob ? EntityIcons.HOSTILE : EntityIcons.NORMAL;
                }
                double angle = Math.atan2(mc.field_71439_g.func_226281_cx_() - entity.func_226281_cx_(), mc.field_71439_g.func_226277_ct_() - entity.func_226277_ct_()) + (double)(-mc.field_71439_g.field_70177_z) * Math.PI / 180.0;
                double wx3 = (double)x + (double)s / 2.0 + Math.cos(angle) * d;
                double wy3 = (double)y + (double)s / 2.0 + Math.sin(angle) * d;
                double ws3 = (double)s / (FTBChunksClientConfig.minimapLargeEntities ? 32.0 : 48.0);
                mc.func_110434_K().func_110577_a(texture);
                RenderSystem.texParameter((int)3553, (int)10241, (int)9729);
                RenderSystem.texParameter((int)3553, (int)10240, (int)9729);
                buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
                buffer.func_225582_a_(wx3 - ws3, wy3 - ws3, (double)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 0.0f).func_181675_d();
                buffer.func_225582_a_(wx3 - ws3, wy3 + ws3, (double)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 1.0f).func_181675_d();
                buffer.func_225582_a_(wx3 + ws3, wy3 + ws3, (double)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 1.0f).func_181675_d();
                buffer.func_225582_a_(wx3 + ws3, wy3 - ws3, (double)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 0.0f).func_181675_d();
                tessellator.func_78381_a();
            }
        }
        if (FTBChunksClientConfig.minimapPlayerHeads && mc.field_71441_e.func_217369_A().size() > 1) {
            for (AbstractClientPlayerEntity player : mc.field_71441_e.func_217369_A()) {
                if (player == mc.field_71439_g) continue;
                d = MathUtils.dist((double)mc.field_71439_g.func_226277_ct_(), (double)mc.field_71439_g.func_226281_cx_(), (double)player.func_226277_ct_(), (double)player.func_226281_cx_()) / 3.2 * scale;
                if (d > (double)s / 2.0) {
                    d = (double)s / 2.0;
                }
                double angle = Math.atan2(mc.field_71439_g.func_226281_cx_() - player.func_226281_cx_(), mc.field_71439_g.func_226277_ct_() - player.func_226277_ct_()) + (double)(-mc.field_71439_g.field_70177_z) * Math.PI / 180.0;
                wx = (double)x + (double)s / 2.0 + Math.cos(angle) * d;
                wy = (double)y + (double)s / 2.0 + Math.sin(angle) * d;
                ws = (double)s / 32.0;
                String uuid = UUIDTypeAdapter.fromUUID((UUID)player.func_110124_au());
                ResourceLocation texture = new ResourceLocation("head", uuid);
                TextureManager texturemanager = mc.func_110434_K();
                Object t = texturemanager.func_229267_b_(texture);
                if (t == null) {
                    t = new PlayerHeadTexture("https://minotar.net/avatar/" + uuid + "/16", ImageIcon.MISSING_IMAGE);
                    texturemanager.func_229263_a_(texture, t);
                }
                RenderSystem.bindTexture((int)t.func_110552_b());
                buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
                buffer.func_225582_a_(wx - ws, wy - ws, (double)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 0.0f).func_181675_d();
                buffer.func_225582_a_(wx - ws, wy + ws, (double)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 1.0f).func_181675_d();
                buffer.func_225582_a_(wx + ws, wy + ws, (double)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 1.0f).func_181675_d();
                buffer.func_225582_a_(wx + ws, wy - ws, (double)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 0.0f).func_181675_d();
                tessellator.func_78381_a();
            }
        }
        if (FTBChunksClientConfig.minimapXYZ || FTBChunksClientConfig.minimapBiome) {
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)((double)x + (double)s / 2.0), (double)((double)(y + s) + 5.0), (double)0.0);
            RenderSystem.scaled((double)(0.5 * scale), (double)(0.5 * scale), (double)1.0);
            if (FTBChunksClientConfig.minimapXYZ) {
                String cs = MathHelper.func_76128_c((double)mc.field_71439_g.func_226277_ct_()) + " " + MathHelper.func_76128_c((double)mc.field_71439_g.func_226278_cu_()) + " " + MathHelper.func_76128_c((double)mc.field_71439_g.func_226281_cx_());
                int csw = mc.field_71466_p.func_78256_a(cs);
                mc.field_71466_p.func_175063_a(cs, (float)(-csw) / 2.0f, 0.0f, -1);
            }
            if (FTBChunksClientConfig.minimapBiome) {
                String bs = I18n.func_135052_a((String)mc.field_71441_e.func_226691_t_(new BlockPos((Entity)mc.field_71439_g)).func_210773_k(), (Object[])new Object[0]);
                int bsw = mc.field_71466_p.func_78256_a(bs);
                mc.field_71466_p.func_175063_a(bs, (float)(-bsw) / 2.0f, FTBChunksClientConfig.minimapXYZ ? 10.0f : 0.0f, -1);
            }
            RenderSystem.popMatrix();
        }
    }

    @SubscribeEvent
    public void loggedOut(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        if (ClientMapManager.inst != null) {
            MapTask t;
            FTBChunksClient.saveAllRegions();
            while ((t = taskQueue.pollFirst()) != null) {
                t.run();
            }
            ClientMapManager.inst.release();
            ClientMapManager.inst = null;
        }
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START && ClientMapManager.inst != null && Minecraft.func_71410_x().field_71441_e != null) {
            if (taskQueueTicks % 4L == 1L) {
                MapTask r;
                int s = Math.min(taskQueue.size(), MathHelper.func_76125_a((int)(taskQueue.size() / 10), (int)50, (int)200));
                for (int i = 0; i < s && (r = taskQueue.pollFirst()) != null; ++i) {
                    r.run();
                    if (r.cancelOtherTasks()) break;
                }
            }
            ++taskQueueTicks;
        }
    }

    static {
        minimapTextureId = -1;
    }
}

