/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbchunks;

import com.feed_the_beast.mods.ftbchunks.ColorMapLoader;
import com.feed_the_beast.mods.ftbchunks.FTBChunksCommands;
import com.feed_the_beast.mods.ftbchunks.FTBChunksCommon;
import com.feed_the_beast.mods.ftbchunks.FTBChunksConfig;
import com.feed_the_beast.mods.ftbchunks.FoliageColorLoader;
import com.feed_the_beast.mods.ftbchunks.GrassColorLoader;
import com.feed_the_beast.mods.ftbchunks.api.ChunkDimPos;
import com.feed_the_beast.mods.ftbchunks.api.ClaimedChunk;
import com.feed_the_beast.mods.ftbchunks.api.FTBChunksAPI;
import com.feed_the_beast.mods.ftbchunks.api.PrivacyMode;
import com.feed_the_beast.mods.ftbchunks.api.Waypoint;
import com.feed_the_beast.mods.ftbchunks.api.WaypointType;
import com.feed_the_beast.mods.ftbchunks.client.FTBChunksClient;
import com.feed_the_beast.mods.ftbchunks.impl.ClaimedChunkManagerImpl;
import com.feed_the_beast.mods.ftbchunks.impl.ClaimedChunkPlayerDataImpl;
import com.feed_the_beast.mods.ftbchunks.impl.FTBChunksAPIImpl;
import com.feed_the_beast.mods.ftbchunks.impl.KnownFakePlayer;
import com.feed_the_beast.mods.ftbchunks.impl.map.MapRegion;
import com.feed_the_beast.mods.ftbchunks.impl.map.MapTask;
import com.feed_the_beast.mods.ftbchunks.impl.map.XZ;
import com.feed_the_beast.mods.ftbchunks.net.FTBChunksNet;
import com.feed_the_beast.mods.ftbchunks.net.LoginDataPacket;
import com.feed_the_beast.mods.ftbchunks.net.SendGeneralDataPacket;
import com.feed_the_beast.mods.ftbchunks.net.SendWaypointsPacket;
import com.feed_the_beast.mods.ftbguilibrary.utils.MathUtils;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BucketItem;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.stats.Stats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="ftbchunks")
public class FTBChunks {
    public static final Logger LOGGER = LogManager.getLogger((String)"FTB Chunks");
    public static FTBChunks instance;
    public FTBChunksCommon proxy;
    public static final int TILES = 15;
    public static final int TILE_SIZE = 16;
    public static final int TILE_OFFSET = 7;
    public static final int MINIMAP_SIZE = 240;
    public static final XZ[] RELATIVE_SPIRAL_POSITIONS;
    public static boolean teamsMod;
    public static boolean ranksMod;

    public FTBChunks() {
        instance = this;
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::init);
        MinecraftForge.EVENT_BUS.addListener(FTBChunksCommands::new);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.proxy = (FTBChunksCommon)DistExecutor.runForDist(() -> () -> new FTBChunksClient(), () -> () -> new FTBChunksCommon());
        this.proxy.init();
        FTBChunksAPI.INSTANCE = new FTBChunksAPIImpl();
        FTBChunksConfig.init();
    }

    private void init(FMLCommonSetupEvent event) {
        teamsMod = ModList.get().isLoaded("ftbteams");
        ranksMod = ModList.get().isLoaded("ftbranks");
        FTBChunksNet.init();
        for (int i = 0; i < RELATIVE_SPIRAL_POSITIONS.length; ++i) {
            FTBChunks.RELATIVE_SPIRAL_POSITIONS[i] = XZ.of(MathUtils.getSpiralPoint((int)(i + 1)));
        }
    }

    @SubscribeEvent
    public void serverAboutToStart(FMLServerAboutToStartEvent event) {
        FTBChunksAPIImpl.manager = new ClaimedChunkManagerImpl(event.getServer());
        event.getServer().func_195570_aG().func_219534_a((IFutureReloadListener)new ColorMapLoader());
        event.getServer().func_195570_aG().func_219534_a((IFutureReloadListener)new GrassColorLoader());
        event.getServer().func_195570_aG().func_219534_a((IFutureReloadListener)new FoliageColorLoader());
    }

    @SubscribeEvent
    public void serverStarting(FMLServerStartingEvent event) {
        FTBChunksAPIImpl.manager.init(event.getServer().func_71218_a(DimensionType.field_223227_a_));
    }

    @SubscribeEvent
    public void serverStopping(FMLServerStoppingEvent event) {
        while (!FTBChunksAPIImpl.manager.map.taskQueue.isEmpty()) {
            FTBChunksAPIImpl.manager.map.taskQueue.pollFirst().run();
        }
    }

    @SubscribeEvent
    public void serverStopped(FMLServerStoppedEvent event) {
        FTBChunksAPIImpl.manager = null;
    }

    @SubscribeEvent
    public void worldSaved(WorldEvent.Save event) {
        if (FTBChunksAPIImpl.manager != null && !event.getWorld().func_201670_d()) {
            FTBChunksAPIImpl.manager.serverSaved();
            if (FTBChunksAPIImpl.manager.map != null) {
                FTBChunksAPIImpl.manager.map.getDimension((DimensionType)event.getWorld().func_201675_m().func_186058_p()).regions.values().removeIf(MapRegion::saveNow);
            }
        }
    }

    @SubscribeEvent
    public void loggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
        ClaimedChunkPlayerDataImpl data = FTBChunksAPIImpl.manager.getData(player);
        if (!data.getName().equals(event.getPlayer().func_146103_bH().getName())) {
            data.profile = new GameProfile(data.getUuid(), event.getPlayer().func_146103_bH().getName());
            data.save();
        }
        FTBChunksNet.MAIN.send(PacketDistributor.PLAYER.with(() -> player), (Object)new LoginDataPacket(FTBChunksAPIImpl.manager.serverId));
        SendGeneralDataPacket.send(player);
        SendWaypointsPacket.send(player);
        for (XZ sp : RELATIVE_SPIRAL_POSITIONS) {
            int x = player.field_70176_ah + sp.x;
            int z = player.field_70164_aj + sp.z;
            FTBChunksAPIImpl.manager.map.queueUpdate(player.field_70170_p, XZ.of(x, z), player);
        }
    }

    private boolean isValidPlayer(@Nullable Entity entity) {
        if (entity instanceof ServerPlayerEntity) {
            if (entity instanceof FakePlayer) {
                if (FTBChunksConfig.disableAllFakePlayers) {
                    return false;
                }
                KnownFakePlayer player = FTBChunksAPIImpl.manager.knownFakePlayers.get(entity.func_110124_au());
                if (player == null) {
                    player = new KnownFakePlayer(entity.func_110124_au(), ((FakePlayer)entity).func_146103_bH().getName(), false);
                    FTBChunksAPIImpl.manager.knownFakePlayers.put(player.uuid, player);
                    FTBChunksAPIImpl.manager.saveFakePlayers = true;
                }
                return !player.banned;
            }
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void blockLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        ClaimedChunk chunk;
        if (this.isValidPlayer((Entity)event.getPlayer()) && (chunk = FTBChunksAPI.INSTANCE.getManager().getChunk(new ChunkDimPos((IWorld)event.getWorld(), event.getPos()))) != null && !chunk.canEdit((ServerPlayerEntity)event.getPlayer(), event.getWorld().func_180495_p(event.getPos()))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void blockRightClick(PlayerInteractEvent.RightClickBlock event) {
        ClaimedChunk chunk;
        if (this.isValidPlayer((Entity)event.getPlayer()) && (chunk = FTBChunksAPI.INSTANCE.getManager().getChunk(new ChunkDimPos((IWorld)event.getWorld(), event.getPos()))) != null && !chunk.canInteract((ServerPlayerEntity)event.getPlayer(), event.getWorld().func_180495_p(event.getPos()))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void itemRightClick(PlayerInteractEvent.RightClickItem event) {
        ClaimedChunk chunk;
        if (this.isValidPlayer((Entity)event.getPlayer()) && !event.getItemStack().func_222117_E() && (chunk = FTBChunksAPI.INSTANCE.getManager().getChunk(new ChunkDimPos((IWorld)event.getWorld(), event.getPos()))) != null && !chunk.canInteract((ServerPlayerEntity)event.getPlayer(), event.getWorld().func_180495_p(event.getPos()))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void blockBreak(BlockEvent.BreakEvent event) {
        ClaimedChunk chunk;
        if (this.isValidPlayer((Entity)event.getPlayer()) && (chunk = FTBChunksAPI.INSTANCE.getManager().getChunk(new ChunkDimPos(event.getWorld(), event.getPos()))) != null && !chunk.canEdit((ServerPlayerEntity)event.getPlayer(), event.getState())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void blockPlace(BlockEvent.EntityPlaceEvent event) {
        if (this.isValidPlayer(event.getEntity())) {
            if (event instanceof BlockEvent.EntityMultiPlaceEvent) {
                for (BlockSnapshot snapshot : ((BlockEvent.EntityMultiPlaceEvent)event).getReplacedBlockSnapshots()) {
                    ClaimedChunk chunk = FTBChunksAPI.INSTANCE.getManager().getChunk(new ChunkDimPos(snapshot.getWorld(), snapshot.getPos()));
                    if (chunk == null || chunk.canEdit((ServerPlayerEntity)event.getEntity(), snapshot.getCurrentBlock())) continue;
                    event.setCanceled(true);
                    return;
                }
            } else {
                ClaimedChunk chunk = FTBChunksAPI.INSTANCE.getManager().getChunk(new ChunkDimPos(event.getWorld(), event.getPos()));
                if (chunk != null && !chunk.canEdit((ServerPlayerEntity)event.getEntity(), event.getPlacedBlock())) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public void fillBucket(FillBucketEvent event) {
        if (this.isValidPlayer((Entity)event.getPlayer()) && event.getTarget() != null && event.getTarget() instanceof BlockRayTraceResult) {
            ClaimedChunk chunk = FTBChunksAPI.INSTANCE.getManager().getChunk(new ChunkDimPos((IWorld)event.getWorld(), ((BlockRayTraceResult)event.getTarget()).func_216350_a()));
            Fluid fluid = Fluids.field_204541_a;
            if (event.getEmptyBucket().func_77973_b() instanceof BucketItem) {
                fluid = ((BucketItem)event.getEmptyBucket().func_77973_b()).getFluid();
            }
            if (chunk != null && !chunk.canEdit((ServerPlayerEntity)event.getEntity(), fluid.func_207188_f().func_206883_i())) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void chunkChange(EntityEvent.EnteringChunk event) {
        if (event.getEntity() instanceof FakePlayer || !(event.getEntity() instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
        ClaimedChunkPlayerDataImpl data = FTBChunksAPIImpl.manager.getData(player);
        int newX = event.getNewChunkX();
        int newZ = event.getNewChunkZ();
        if (data.prevChunkX != newX || data.prevChunkZ != newZ) {
            String s;
            ClaimedChunk chunk = FTBChunksAPI.INSTANCE.getManager().getChunk(new ChunkDimPos((Entity)player));
            String string = s = chunk == null ? "-" : chunk.getGroupID() + ":" + chunk.getPlayerData().getName();
            if (!data.lastChunkID.equals(s)) {
                data.lastChunkID = s;
                if (chunk != null) {
                    player.func_146105_b(chunk.getDisplayName().func_212638_h().func_211708_a(TextFormatting.AQUA), true);
                } else {
                    player.func_146105_b(new TranslationTextComponent("wilderness", new Object[0]).func_211708_a(TextFormatting.DARK_GREEN), true);
                }
            }
            if (data.prevChunkX != Integer.MAX_VALUE && data.prevChunkZ != Integer.MAX_VALUE && FTBChunksAPIImpl.manager != null && FTBChunksAPIImpl.manager.map != null) {
                HashSet<XZ> positions = new HashSet<XZ>();
                for (XZ sp : RELATIVE_SPIRAL_POSITIONS) {
                    positions.add(XZ.of(newX + sp.x, newZ + sp.z));
                }
                for (XZ sp : RELATIVE_SPIRAL_POSITIONS) {
                    positions.remove(XZ.of(data.prevChunkX + sp.x, data.prevChunkZ + sp.z));
                }
                for (XZ sp : positions) {
                    FTBChunksAPIImpl.manager.map.queueUpdate(player.field_70170_p, XZ.of(sp.x, sp.z), player);
                }
            }
            data.prevChunkX = newX;
            data.prevChunkZ = newZ;
        }
    }

    @SubscribeEvent
    public void mobSpawned(LivingSpawnEvent.CheckSpawn event) {
        if (!event.getWorld().func_201670_d() && !(event.getEntity() instanceof PlayerEntity)) {
            switch (event.getSpawnReason()) {
                case NATURAL: 
                case CHUNK_GENERATION: 
                case SPAWNER: 
                case STRUCTURE: 
                case JOCKEY: 
                case PATROL: {
                    ClaimedChunk chunk = FTBChunksAPI.INSTANCE.getManager().getChunk(new ChunkDimPos(event.getWorld().func_201675_m().func_186058_p(), MathHelper.func_76128_c((double)event.getX()), MathHelper.func_76128_c((double)event.getZ())));
                    if (chunk == null || chunk.canEntitySpawn(event.getEntity())) break;
                    event.setResult(Event.Result.DENY);
                }
            }
        }
    }

    @SubscribeEvent
    public void explosionDetonate(ExplosionEvent.Detonate event) {
        if (event.getWorld().func_201670_d() || event.getExplosion().func_180343_e().isEmpty()) {
            return;
        }
        ArrayList list = new ArrayList(event.getExplosion().func_180343_e());
        event.getExplosion().func_180342_d();
        HashMap<ChunkDimPos, Boolean> map = new HashMap<ChunkDimPos, Boolean>();
        for (BlockPos pos : list) {
            if (!map.computeIfAbsent(new ChunkDimPos((IWorld)event.getWorld(), pos), cpos -> {
                ClaimedChunk chunk = FTBChunksAPI.INSTANCE.getManager().getChunk((ChunkDimPos)cpos);
                return chunk == null || chunk.allowExplosions();
            }).booleanValue()) continue;
            event.getExplosion().func_180343_e().add(pos);
        }
    }

    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            if (FTBChunksAPIImpl.manager.map.taskQueueTicks % 4L == 1L) {
                MapTask r;
                int s = Math.min(FTBChunksAPIImpl.manager.map.taskQueue.size(), MathHelper.func_76125_a((int)(FTBChunksAPIImpl.manager.map.taskQueue.size() / 10), (int)50, (int)200));
                for (int i = 0; i < s && (r = FTBChunksAPIImpl.manager.map.taskQueue.pollFirst()) != null; ++i) {
                    r.run();
                    if (r.cancelOtherTasks()) break;
                }
            }
            ++FTBChunksAPIImpl.manager.map.taskQueueTicks;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void blockPlaceLowest(BlockEvent.EntityPlaceEvent event) {
        if (event.getEntity() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
            if (event instanceof BlockEvent.EntityMultiPlaceEvent) {
                HashSet<XZ> posSet = new HashSet<XZ>();
                for (BlockSnapshot snapshot : ((BlockEvent.EntityMultiPlaceEvent)event).getReplacedBlockSnapshots()) {
                    XZ pos;
                    if (snapshot.getWorld() != player.field_70170_p || !posSet.add(pos = XZ.chunkFromBlock(snapshot.getPos().func_177958_n(), snapshot.getPos().func_177952_p()))) continue;
                    FTBChunksAPIImpl.manager.map.getChunk((DimensionType)player.field_70170_p.field_73011_w.func_186058_p(), (XZ)pos).weakUpdate = true;
                }
            } else {
                FTBChunksAPIImpl.manager.map.getChunk((DimensionType)player.field_70170_p.field_73011_w.func_186058_p(), (XZ)XZ.chunkFromBlock((Vec3i)event.getPos())).weakUpdate = true;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void blockBreakLowest(BlockEvent.BreakEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            FTBChunksAPIImpl.manager.map.getChunk((DimensionType)player.field_70170_p.field_73011_w.func_186058_p(), (XZ)XZ.chunkFromBlock((Vec3i)event.getPos())).weakUpdate = true;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void playerDeath(LivingDeathEvent event) {
        if (event.getEntity() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
            ClaimedChunkPlayerDataImpl data = FTBChunksAPIImpl.manager.getData(player);
            Waypoint w = new Waypoint(data, UUID.randomUUID());
            w.name = "Death #" + player.func_147099_x().func_77444_a(Stats.field_199092_j.func_199076_b((Object)Stats.field_188069_A));
            w.dimension = player.field_71093_bK;
            w.privacy = PrivacyMode.ALLIES;
            w.type = WaypointType.DEATH;
            w.x = MathHelper.func_76128_c((double)player.func_226277_ct_());
            w.y = MathHelper.func_76128_c((double)player.func_226278_cu_());
            w.z = MathHelper.func_76128_c((double)player.func_226281_cx_());
            data.waypoints.put(w.id, w);
            data.save();
            SendWaypointsPacket.send(player);
        }
    }

    @SubscribeEvent
    public void changedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!(event.getPlayer() instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
        for (XZ sp : RELATIVE_SPIRAL_POSITIONS) {
            int x = player.field_70176_ah + sp.x;
            int z = player.field_70164_aj + sp.z;
            FTBChunksAPIImpl.manager.map.queueUpdate(player.field_70170_p, XZ.of(x, z), player);
        }
    }

    static {
        RELATIVE_SPIRAL_POSITIONS = new XZ[225];
        teamsMod = false;
        ranksMod = false;
    }
}

