/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.ui.manager.editor;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import vswe.stevesfactory.api.logic.IErrorPopulator;
import vswe.stevesfactory.library.gui.TextureWrapper;
import vswe.stevesfactory.library.gui.debug.RenderEventDispatcher;
import vswe.stevesfactory.library.gui.screen.WidgetScreen;
import vswe.stevesfactory.library.gui.widget.AbstractWidget;
import vswe.stevesfactory.library.gui.widget.mixin.LeafWidgetMixin;

public class ErrorIndicator
extends AbstractWidget
implements LeafWidgetMixin {
    public static final TextureWrapper ERROR = TextureWrapper.ofFlowComponent(40, 52, 2, 10);
    public static final TextureWrapper ERROR_HOVERED = ERROR.toRight(2);
    public static final TextureWrapper WARNING = ERROR.toRight(1);
    public static final TextureWrapper WARNING_HOVERED = WARNING.toRight(2);
    private TextureWrapper background;
    private TextureWrapper backgroundHovered;
    private final List<String> errors = new ArrayList<String>();
    private final String heading;

    public static ErrorIndicator error() {
        return new ErrorIndicator(I18n.func_135052_a((String)"error.sfm.Error", (Object[])new Object[0]), ERROR, ERROR_HOVERED);
    }

    public static ErrorIndicator warning() {
        return new ErrorIndicator(I18n.func_135052_a((String)"error.sfm.Warning", (Object[])new Object[0]), WARNING, WARNING_HOVERED);
    }

    private ErrorIndicator(String heading, TextureWrapper background, TextureWrapper backgroundHovered) {
        this.heading = heading;
        this.background = background;
        this.backgroundHovered = backgroundHovered;
        this.setDimensions(background.getPortionWidth(), background.getPortionHeight());
    }

    public void clearErrors() {
        this.errors.clear();
        this.errors.add(this.heading);
    }

    public void populateErrors(IErrorPopulator handler) {
        handler.populateErrors(this.errors);
    }

    public void repopulateErrors(IErrorPopulator handler) {
        this.clearErrors();
        handler.populateErrors(this.errors);
    }

    @Override
    public void render(int mouseX, int mouseY, float particleTicks) {
        RenderEventDispatcher.onPreRender(this, mouseX, mouseY);
        if (this.errors.size() > 1) {
            if (this.isInside(mouseX, mouseY)) {
                this.backgroundHovered.draw(this.getAbsoluteX(), this.getAbsoluteY());
                WidgetScreen.getCurrent().setHoveringText(this.errors, mouseX, mouseY);
            } else {
                this.background.draw(this.getAbsoluteX(), this.getAbsoluteY());
            }
        }
        RenderEventDispatcher.onPostRender(this, mouseX, mouseY);
    }
}

