/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.setup;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import vswe.stevesfactory.blocks.BUDBlock;
import vswe.stevesfactory.blocks.BUDTileEntity;
import vswe.stevesfactory.blocks.BlockInteractorBlock;
import vswe.stevesfactory.blocks.BlockInteractorTileEntity;
import vswe.stevesfactory.blocks.CableBlock;
import vswe.stevesfactory.blocks.CableTileEntity;
import vswe.stevesfactory.blocks.FactoryManagerBlock;
import vswe.stevesfactory.blocks.FactoryManagerTileEntity;
import vswe.stevesfactory.blocks.ItemIntakeBlock;
import vswe.stevesfactory.blocks.ItemIntakeTileEntity;
import vswe.stevesfactory.blocks.RedstoneEmitterBlock;
import vswe.stevesfactory.blocks.RedstoneEmitterTileEntity;
import vswe.stevesfactory.blocks.RedstoneInputBlock;
import vswe.stevesfactory.blocks.RedstoneInputTileEntity;
import vswe.stevesfactory.blocks.SignUpdaterBlock;
import vswe.stevesfactory.blocks.SignUpdaterTileEntity;
import vswe.stevesfactory.blocks.WorldInteractorBlock;
import vswe.stevesfactory.blocks.WorldInteractorTileEntity;
import vswe.stevesfactory.render.WorkingAreaRenderer;
import vswe.stevesfactory.setup.BlockBuilder;
import vswe.stevesfactory.setup.ModItems;

@Mod.EventBusSubscriber(modid="sfm", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ModBlocks {
    private static List<BlockBuilder<?>> pendingBlocks = new ArrayList();
    @ObjectHolder(value="sfm:factory_manager")
    public static FactoryManagerBlock factoryManagerBlock;
    @ObjectHolder(value="sfm:factory_manager")
    public static TileEntityType<FactoryManagerTileEntity> factoryManagerTileEntity;
    @ObjectHolder(value="sfm:cable")
    public static CableBlock cableBlock;
    @ObjectHolder(value="sfm:cable")
    public static TileEntityType<CableTileEntity> cableTileEntity;
    @ObjectHolder(value="sfm:redstone_emitter")
    public static RedstoneEmitterBlock redstoneEmitterBlock;
    @ObjectHolder(value="sfm:redstone_emitter")
    public static TileEntityType<RedstoneEmitterTileEntity> redstoneEmitterTileEntity;
    @ObjectHolder(value="sfm:redstone_input")
    public static RedstoneInputBlock redstoneInputBlock;
    @ObjectHolder(value="sfm:redstone_input")
    public static TileEntityType<RedstoneInputTileEntity> redstoneInputTileEntity;
    @ObjectHolder(value="sfm:item_intake")
    public static ItemIntakeBlock itemIntakeBlock;
    @ObjectHolder(value="sfm:item_intake")
    public static TileEntityType<ItemIntakeTileEntity> itemIntakeTileEntity;
    @ObjectHolder(value="sfm:instant_item_intake")
    public static ItemIntakeBlock instantItemIntakeBlock;
    @ObjectHolder(value="sfm:instant_item_intake")
    public static TileEntityType<ItemIntakeTileEntity> instantItemIntakeTileEntity;
    @ObjectHolder(value="sfm:bud")
    public static BUDBlock budBlock;
    @ObjectHolder(value="sfm:bud")
    public static TileEntityType<BUDTileEntity> budTileEntity;
    @ObjectHolder(value="sfm:block_interactor")
    public static BlockInteractorBlock blockInteractorBlock;
    @ObjectHolder(value="sfm:block_interactor")
    public static TileEntityType<BlockInteractorTileEntity> blockInteractorTileEntity;
    @ObjectHolder(value="sfm:world_interactor")
    public static WorldInteractorBlock worldInteractorBlock;
    @ObjectHolder(value="sfm:world_interactor")
    public static TileEntityType<WorldInteractorTileEntity> worldInteractorTileEntity;
    @ObjectHolder(value="sfm:sign_updater")
    public static SignUpdaterBlock signUpdaterBlock;
    @ObjectHolder(value="sfm:sign_updater")
    public static TileEntityType<SignUpdaterTileEntity> signUpdaterTileEntity;

    private ModBlocks() {
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        pendingBlocks.forEach(b -> event.getRegistry().register((IForgeRegistryEntry)b.construct()));
    }

    @SubscribeEvent
    public static void registerItemBlocks(RegistryEvent.Register<Item> event) {
        pendingBlocks.forEach(b -> event.getRegistry().register((IForgeRegistryEntry)b.constructItemBlock()));
    }

    @SubscribeEvent
    public static void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
        pendingBlocks.forEach(b -> event.getRegistry().register(b.constructTileEntityType()));
    }

    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        pendingBlocks.forEach(BlockBuilder::tryRegisterTileEntityRenderer);
    }

    @SubscribeEvent
    public static void finishLoading(FMLLoadCompleteEvent event) {
        pendingBlocks = null;
    }

    static {
        pendingBlocks.add(new BlockBuilder("factory_manager").properties(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(3.0f, 10.0f)).constructor(FactoryManagerBlock::new).item(ModItems.defaultItemProperties()).tileEntity(block -> TileEntityType.Builder.func_223042_a(FactoryManagerTileEntity::new, (Block[])new Block[]{block})));
        pendingBlocks.add(new BlockBuilder("cable").properties(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(1.0f, 10.0f)).constructor(CableBlock::new).item(ModItems.defaultItemProperties()).tileEntity(block -> TileEntityType.Builder.func_223042_a(CableTileEntity::new, (Block[])new Block[]{block})));
        pendingBlocks.add(new BlockBuilder("redstone_emitter").properties(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(1.8f, 10.0f)).constructor(RedstoneEmitterBlock::new).item(ModItems.defaultItemProperties()).tileEntity(block -> TileEntityType.Builder.func_223042_a(RedstoneEmitterTileEntity::new, (Block[])new Block[]{block})));
        pendingBlocks.add(new BlockBuilder("redstone_input").properties(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(1.8f, 10.0f)).constructor(RedstoneInputBlock::new).item(ModItems.defaultItemProperties()).tileEntity(block -> TileEntityType.Builder.func_223042_a(RedstoneInputTileEntity::new, (Block[])new Block[]{block})));
        pendingBlocks.add(new BlockBuilder("item_intake").properties(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(1.8f, 10.0f)).constructor(props -> new ItemIntakeBlock(ItemIntakeTileEntity::regular, (Block.Properties)props)).item(ModItems.defaultItemProperties()).tileEntity(block -> TileEntityType.Builder.func_223042_a(ItemIntakeTileEntity::regular, (Block[])new Block[]{block})).forClient(() -> builder -> builder.renderer(WorkingAreaRenderer::new)));
        pendingBlocks.add(new BlockBuilder("instant_item_intake").properties(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(1.8f, 10.0f)).constructor(props -> new ItemIntakeBlock(ItemIntakeTileEntity::instant, (Block.Properties)props)).item(ModItems.defaultItemProperties()).tileEntity(block -> TileEntityType.Builder.func_223042_a(ItemIntakeTileEntity::instant, (Block[])new Block[]{block})).forClient(() -> builder -> builder.renderer(WorkingAreaRenderer::new)));
        pendingBlocks.add(new BlockBuilder("bud").properties(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(1.8f, 10.0f)).constructor(BUDBlock::new).item(ModItems.defaultItemProperties()).tileEntity(block -> TileEntityType.Builder.func_223042_a(BUDTileEntity::new, (Block[])new Block[]{block})));
        pendingBlocks.add(new BlockBuilder("block_interactor").properties(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(1.8f, 10.0f)).constructor(BlockInteractorBlock::new).item(ModItems.defaultItemProperties()).tileEntity(block -> TileEntityType.Builder.func_223042_a(BlockInteractorTileEntity::new, (Block[])new Block[]{block})));
        pendingBlocks.add(new BlockBuilder("world_interactor").properties(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(1.8f, 10.0f)).constructor(WorldInteractorBlock::new).item(ModItems.defaultItemProperties()).tileEntity(block -> TileEntityType.Builder.func_223042_a(WorldInteractorTileEntity::new, (Block[])new Block[]{block})));
        pendingBlocks.add(new BlockBuilder("sign_updater").properties(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(1.8f, 10.0f)).constructor(SignUpdaterBlock::new).item(ModItems.defaultItemProperties()).tileEntity(block -> TileEntityType.Builder.func_223042_a(SignUpdaterTileEntity::new, (Block[])new Block[]{block})));
    }
}

