/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.network;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fml.network.NetworkEvent;
import vswe.stevesfactory.StevesFactoryManager;
import vswe.stevesfactory.blocks.ItemIntakeTileEntity;

public final class PacketSyncIntakeData {
    private DimensionType dimension;
    private BlockPos pos;
    private int radius;
    private boolean rendering;
    private ItemIntakeTileEntity.Mode mode;

    public static void encode(PacketSyncIntakeData msg, PacketBuffer buf) {
        buf.func_192572_a(Objects.requireNonNull(msg.dimension.getRegistryName()));
        buf.func_179255_a(msg.pos);
        buf.func_150787_b(msg.radius);
        buf.writeBoolean(msg.rendering);
        buf.func_179249_a((Enum)msg.mode);
    }

    public static PacketSyncIntakeData decode(PacketBuffer buf) {
        DimensionType dimension = DimensionType.func_193417_a((ResourceLocation)buf.func_192575_l());
        BlockPos pos = buf.func_179259_c();
        int radius = buf.func_150792_a();
        boolean rendering = buf.readBoolean();
        ItemIntakeTileEntity.Mode mode = (ItemIntakeTileEntity.Mode)buf.func_179257_a(ItemIntakeTileEntity.Mode.class);
        return new PacketSyncIntakeData(dimension, pos, radius, rendering, mode);
    }

    public static void handle(PacketSyncIntakeData msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity sender = ((NetworkEvent.Context)ctx.get()).getSender();
            Preconditions.checkState((sender != null ? 1 : 0) != 0, (Object)"Invalid usage of a client to server packet");
            World world = sender.field_70170_p;
            TileEntity tile = world.func_175625_s(msg.pos);
            if (tile instanceof ItemIntakeTileEntity) {
                ItemIntakeTileEntity intake = (ItemIntakeTileEntity)tile;
                intake.setRadius(msg.radius);
                intake.setRendering(msg.rendering);
                intake.setMode(msg.mode);
            } else {
                StevesFactoryManager.logger.error("Received packet with invalid item intake position {}!", (Object)msg);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public PacketSyncIntakeData(DimensionType dimension, BlockPos pos, int radius, boolean rendering, ItemIntakeTileEntity.Mode mode) {
        this.dimension = dimension;
        this.pos = pos;
        this.radius = radius;
        this.rendering = rendering;
        this.mode = mode;
    }
}

