/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.library.gui.widget.box;

import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import vswe.stevesfactory.library.gui.debug.RenderEventDispatcher;
import vswe.stevesfactory.library.gui.widget.AbstractContainer;
import vswe.stevesfactory.library.gui.widget.IWidget;

public class Box<T extends IWidget>
extends AbstractContainer<T>
implements IWidget {
    private List<T> children = new ArrayList<T>();
    private List<T> childrenView = Collections.unmodifiableList(this.children);
    private Consumer<List<T>> layout;
    private boolean paused;

    public Box(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.layout = l -> {};
        this.paused = false;
    }

    public Box(Point location, Dimension dimensions) {
        super(location, dimensions);
        this.layout = l -> {};
        this.paused = false;
    }

    @Override
    public void onParentPositionChanged() {
        int oldAbsX = this.getAbsoluteX();
        int oldAbsY = this.getAbsoluteY();
        super.onParentPositionChanged();
        if (this.getAbsoluteX() != oldAbsX || this.getAbsoluteY() != oldAbsY) {
            for (IWidget child : this.children) {
                child.onParentPositionChanged();
            }
        }
    }

    @Override
    public List<T> getChildren() {
        return this.childrenView;
    }

    @Override
    public Box<T> addChildren(T widget) {
        this.children.add(widget);
        widget.setParentWidget(this);
        this.reflow();
        return this;
    }

    @Override
    public Box<T> addChildren(Collection<T> widgets) {
        this.children.addAll(widgets);
        widgets.forEach(widget -> widget.setParentWidget(this));
        this.reflow();
        return this;
    }

    @Override
    public Box<T> addChildren(Iterable<T> widgets) {
        super.addChildren(widgets);
        return this;
    }

    @Override
    public Box<T> addChildren(Iterator<T> widgets) {
        super.addChildren(widgets);
        return this;
    }

    public Box<T> updateChildLocation(T child, Point point) {
        child.setLocation(point);
        this.reflow();
        return this;
    }

    public Box<T> updateChildLocation(T child, int x, int y) {
        child.setLocation(x, y);
        this.reflow();
        return this;
    }

    @Override
    public void render(int mouseX, int mouseY, float particleTicks) {
        if (this.isEnabled()) {
            RenderEventDispatcher.onPreRender(this, mouseX, mouseY);
            for (IWidget child : this.children) {
                child.render(mouseX, mouseY, particleTicks);
            }
            RenderEventDispatcher.onPostRender(this, mouseX, mouseY);
        }
    }

    public Box<T> pause() {
        this.paused = true;
        return this;
    }

    public Box<T> unpause() {
        this.paused = false;
        this.reflow();
        return this;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public Box<T> setLayout(Consumer<List<T>> layout) {
        this.layout = layout;
        return this;
    }

    @Override
    public void reflow() {
        this.layout.accept(this.children);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isEnabled()) {
            return super.mouseClicked(mouseX, mouseY, button);
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.isEnabled()) {
            return super.mouseReleased(mouseX, mouseY, button);
        }
        return false;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isEnabled()) {
            return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double scroll) {
        if (this.isEnabled()) {
            return super.mouseScrolled(mouseX, mouseY, scroll);
        }
        return false;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.isEnabled()) {
            return super.keyPressed(keyCode, scanCode, modifiers);
        }
        return false;
    }

    @Override
    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (this.isEnabled()) {
            return super.keyReleased(keyCode, scanCode, modifiers);
        }
        return false;
    }

    @Override
    public boolean charTyped(char charTyped, int keyCode) {
        if (this.isEnabled()) {
            return super.charTyped(charTyped, keyCode);
        }
        return false;
    }

    @Override
    public void mouseMoved(double mouseX, double mouseY) {
        if (this.isEnabled()) {
            super.mouseMoved(mouseX, mouseY);
        }
    }

    @Override
    public void update(float particleTicks) {
        if (this.isEnabled()) {
            super.update(particleTicks);
        }
    }
}

