/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.blocks;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import vswe.stevesfactory.Config;
import vswe.stevesfactory.api.network.ICable;
import vswe.stevesfactory.api.network.INetworkController;
import vswe.stevesfactory.blocks.ItemIntakeBlock;
import vswe.stevesfactory.render.IWorkingAreaProvider;
import vswe.stevesfactory.setup.ModBlocks;
import vswe.stevesfactory.ui.intake.ItemIntakeContainer;
import vswe.stevesfactory.utils.NetworkHelper;

public abstract class ItemIntakeTileEntity
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider,
ICable,
IWorkingAreaProvider {
    private static final int STATE_READY = 0;
    private static final int STATE_RELOAD = -1;
    private LazyOptional<ItemStackHandler> invCap = LazyOptional.of(() -> new ItemStackHandler(this.getInventorySize()));
    private Mode mode = Mode.FRONT;
    private int radius = 0;
    private boolean rendering = false;
    private AxisAlignedBB pickupBox = new AxisAlignedBB(BlockPos.field_177992_a);
    private int ticks;

    public static ItemIntakeTileEntity regular() {
        return new ItemIntakeTileEntity((TileEntityType)ModBlocks.itemIntakeTileEntity){

            @Override
            public boolean isCable() {
                return (Boolean)Config.COMMON.isItemIntakeBlockCables.get();
            }

            @Override
            public boolean ignorePickupDelay() {
                return false;
            }

            @Override
            public int getInventorySize() {
                return (Integer)Config.COMMON.regularInventorySize.get();
            }

            @Override
            public int getMaximumRadius() {
                return (Integer)Config.COMMON.regularMaxRadius.get();
            }

            @Override
            protected int getPickupInterval() {
                return (Integer)Config.COMMON.regularPickupInterval.get();
            }
        };
    }

    public static ItemIntakeTileEntity instant() {
        return new ItemIntakeTileEntity((TileEntityType)ModBlocks.instantItemIntakeTileEntity){

            @Override
            public boolean isCable() {
                return (Boolean)Config.COMMON.isInstantItemIntakeBlockCables.get();
            }

            @Override
            public boolean ignorePickupDelay() {
                return true;
            }

            @Override
            public int getInventorySize() {
                return (Integer)Config.COMMON.instantInventorySize.get();
            }

            @Override
            public int getMaximumRadius() {
                return (Integer)Config.COMMON.instantMaxRadius.get();
            }

            @Override
            protected int getPickupInterval() {
                return (Integer)Config.COMMON.instantPickupInterval.get();
            }
        };
    }

    private ItemIntakeTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public void onLoad() {
        super.onLoad();
        this.ticks = -1;
    }

    public void func_73660_a() {
        assert (this.field_145850_b != null);
        if (!this.field_145850_b.field_72995_K) {
            if (this.ticks == -1) {
                this.reload();
                this.ticks = 0;
                return;
            }
            if (this.ticks == 0) {
                this.collectItems();
                this.ticks = this.getPickupInterval();
                return;
            }
            --this.ticks;
        }
    }

    public void reload() {
        this.setMode(this.mode);
        this.setRadius(this.radius);
        this.setRendering(this.rendering);
    }

    private void collectItems() {
        assert (this.field_145850_b != null);
        ItemStackHandler handler = (ItemStackHandler)this.invCap.orElseThrow(RuntimeException::new);
        List items = this.field_145850_b.func_217357_a(ItemEntity.class, this.pickupBox);
        for (ItemEntity item : items) {
            if (!this.ignorePickupDelay() && item.func_174874_s() || !item.func_70089_S()) continue;
            ItemStack leftover = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)item.func_92059_d(), (boolean)false);
            if (leftover.func_190926_b()) {
                item.func_70106_y();
                continue;
            }
            item.func_92058_a(leftover);
        }
    }

    public abstract boolean ignorePickupDelay();

    public abstract int getInventorySize();

    public int getRadius() {
        return this.radius;
    }

    public abstract int getMaximumRadius();

    public void setRadius(int radius) {
        this.radius = MathHelper.func_76125_a((int)radius, (int)0, (int)this.getMaximumRadius());
        BlockState state = this.func_195044_w();
        BlockPos origin = this.mode == Mode.CENTERED ? this.field_174879_c : this.field_174879_c.func_177967_a((Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208155_H), this.radius + 1);
        this.pickupBox = new AxisAlignedBB(origin).func_186662_g((double)this.radius);
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        if (this.mode != mode) {
            assert (this.field_145850_b != null);
            this.mode = mode;
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a(ItemIntakeBlock.MODE_PROPERTY, (Comparable)((Object)mode)));
            this.setRadius(this.radius);
        }
    }

    public void cycleMode() {
        int max;
        int next = this.mode.ordinal() + 1;
        this.setMode(Mode.VALUES[next >= (max = Mode.VALUES.length) ? 0 : next]);
    }

    protected abstract int getPickupInterval();

    @Override
    public AxisAlignedBB getWorkingArea() {
        return this.pickupBox;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.pickupBox;
    }

    @Override
    public boolean isRendering() {
        return this.rendering;
    }

    public void setRendering(boolean rendering) {
        this.rendering = rendering;
    }

    @Override
    public BlockPos getPosition() {
        return this.field_174879_c;
    }

    @Override
    public void addLinksFor(INetworkController controller) {
        NetworkHelper.updateLinksFor(controller, this);
    }

    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.readCustom(tag);
    }

    public void readCustom(CompoundNBT tag) {
        this.mode = Mode.VALUES[tag.func_74762_e("Mode")];
        this.radius = tag.func_74762_e("Radius");
        this.rendering = tag.func_74767_n("Rendering");
        this.invCap.ifPresent(inv -> inv.deserializeNBT(tag.func_74775_l("Inventory")));
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        this.writeCustom(tag);
        return super.func_189515_b(tag);
    }

    public CompoundNBT writeCustom(CompoundNBT tag) {
        tag.func_74768_a("Mode", this.mode.ordinal());
        tag.func_74768_a("Radius", this.radius);
        tag.func_74757_a("Rendering", this.rendering);
        this.invCap.map(ItemStackHandler::serializeNBT).ifPresent(data -> tag.func_218657_a("Inventory", (INBT)data));
        return tag;
    }

    protected void invalidateCaps() {
        this.invCap.invalidate();
        super.invalidateCaps();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.invCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("gui.sfm.Title.ItemIntake", new Object[0]);
    }

    public Container createMenu(int i, PlayerInventory inv, PlayerEntity player) {
        return new ItemIntakeContainer(i, this);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void handleUpdateTag(CompoundNBT tag) {
        super.handleUpdateTag(tag);
        this.reload();
    }

    public static enum Mode implements IStringSerializable
    {
        FRONT("front", "gui.sfm.ItemIntake.Mode.Front"),
        CENTERED("centered", "gui.sfm.ItemIntake.Mode.Centered");

        public final String name;
        public final String statusTranslationKey;
        public static final Mode[] VALUES;

        private Mode(String name, String statusTranslationKey) {
            this.name = name;
            this.statusTranslationKey = statusTranslationKey;
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            VALUES = Mode.values();
        }
    }
}

