/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.api.visibility;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.ResourceLocation;
import vswe.stevesfactory.api.logic.IProcedureType;

@ParametersAreNonnullByDefault
public final class GUIVisibility {
    private static final Map<ResourceLocation, BooleanSupplier> map = new HashMap<ResourceLocation, BooleanSupplier>();

    private GUIVisibility() {
    }

    public static boolean isEnabled(IProcedureType<?> type) {
        ResourceLocation id = Objects.requireNonNull(type.getRegistryName());
        return GUIVisibility.isEnabled(id);
    }

    public static boolean isEnabled(ResourceLocation registryName) {
        return map.getOrDefault(registryName, () -> true).getAsBoolean();
    }

    public static void registerEnableState(IProcedureType<?> type, BooleanSupplier getter) {
        Preconditions.checkNotNull(type);
        ResourceLocation id = Objects.requireNonNull(type.getRegistryName());
        GUIVisibility.registerEnableState(id, getter);
    }

    public static void registerEnableState(ResourceLocation id, BooleanSupplier getter) {
        Preconditions.checkNotNull((Object)id);
        BooleanSupplier prev = map.putIfAbsent(id, getter);
        Preconditions.checkState((prev == null ? 1 : 0) != 0);
    }
}

