/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.network;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import me.desht.modularrouters.client.render.item_beam.ItemBeam;
import me.desht.modularrouters.client.render.item_beam.ItemBeamDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.network.NetworkEvent;

public class ItemBeamMessage {
    private static final Vec3d HALF_BLOCK = new Vec3d(0.5, 0.5, 0.5);
    private int duration;
    private BlockPos pos1;
    private BlockPos pos2;
    private ItemStack stack;
    private int color;
    private boolean itemFade;

    public ItemBeamMessage() {
    }

    public ItemBeamMessage(ByteBuf buf) {
        PacketBuffer pb = new PacketBuffer(buf);
        this.pos1 = pb.func_179259_c();
        this.pos2 = pb.func_179259_c();
        this.stack = pb.func_150791_c();
        this.color = pb.readInt();
        this.itemFade = pb.readBoolean();
        this.duration = pb.func_150792_a();
    }

    public ItemBeamMessage(BlockPos pos1, BlockPos pos2, ItemStack stack, int color, int duration) {
        this.pos1 = pos1;
        this.pos2 = pos2;
        this.stack = stack;
        this.color = color;
        this.itemFade = false;
        this.duration = duration;
    }

    public ItemBeamMessage withFadeout() {
        this.itemFade = true;
        return this;
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer pb = new PacketBuffer(buf);
        pb.func_179255_a(this.pos1);
        pb.func_179255_a(this.pos2);
        pb.func_150788_a(this.stack);
        pb.writeInt(this.color);
        pb.writeBoolean(this.itemFade);
        pb.func_150787_b(this.duration);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ItemBeamDispatcher.getInstance().addBeam(new ItemBeam(this.pos1, this.pos2, this.stack, this.color, Math.max(5, this.duration + 1), this.itemFade)));
        ctx.get().setPacketHandled(true);
    }
}

