/*
 * Decompiled with CFR 0.152.
 */
package com.performant.coremod.commands;

import com.performant.coremod.event.EventHandlerB;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.IEventListener;

public class ReportData {
    private static final String TP_COMMAND = "/execute as @s in %s run tp %d %d %d";
    public static HashMap<UUID, ReportData> entityReport = new HashMap();
    public static HashMap<BlockPos, ReportData> tileEntityReport = new HashMap();
    public MobEntity entity;
    public Goal lagGoal;
    public TileEntity te;
    public World world;
    public int totalTickTime = 0;

    public int getTotelTickTime() {
        return this.totalTickTime;
    }

    public static void addEntityReport(Entity entity, ReportData data) {
        ReportData existing = entityReport.get(entity.func_110124_au());
        if (existing != null) {
            if (existing.totalTickTime < data.totalTickTime || existing.lagGoal == null) {
                existing.lagGoal = data.lagGoal;
            }
            existing.totalTickTime += data.totalTickTime;
        } else {
            entityReport.put(entity.func_110124_au(), data);
        }
    }

    public static void addTileEntityReport(TileEntity te, ReportData data) {
        ReportData existing = tileEntityReport.get(te.func_174877_v().func_177982_a(te.func_145831_w() != null ? te.func_145831_w().field_73011_w.func_186058_p().func_186068_a() : 0, 0, 0));
        if (existing != null) {
            existing.totalTickTime += data.totalTickTime;
        } else {
            tileEntityReport.put(te.func_174877_v().func_177982_a(te.func_145831_w() != null ? te.func_145831_w().field_73011_w.func_186058_p().func_186068_a() : 0, 0, 0), data);
        }
    }

    public static void reportEntities(CommandSource source, int startIndex) {
        if (entityReport.isEmpty()) {
            source.func_197030_a((ITextComponent)new StringTextComponent("\u00c2\u00a79Result is empty, no AI was throttled or startGatherData command was not run yet. Server may not have reached the configured lag threshold before loadbalancing."), false);
            return;
        }
        ArrayList<ReportData> sortedData = new ArrayList<ReportData>(entityReport.values());
        sortedData.sort(Comparator.comparingInt(ReportData::getTotelTickTime).reversed());
        int i = 0;
        for (i = startIndex; i < startIndex + 5 && i < sortedData.size(); ++i) {
            ReportData data = (ReportData)sortedData.get(i);
            if (!data.entity.func_70089_S()) {
                sortedData.remove(i);
                --i;
                continue;
            }
            source.func_197030_a(new StringTextComponent("\u00c2\u00a72Entity:\u00c2\u00a7f" + data.entity.func_200600_R().func_212546_e().func_150254_d()).func_150257_a(new StringTextComponent(" \u00c2\u00a72pos:\u00c2\u00a7e" + data.entity.func_180425_c()).func_150255_a(new Style().func_150227_a(Boolean.valueOf(true)).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format(TP_COMMAND, data.entity.field_70170_p.field_73011_w.func_186058_p().getRegistryName().toString(), (int)data.entity.field_70165_t, (int)data.entity.field_70163_u, (int)data.entity.field_70161_v))))).func_150257_a((ITextComponent)new StringTextComponent(" \u00c2\u00a72tickTime:\u00c2\u00a7f" + data.totalTickTime + " \u00c2\u00a72AITask:\u00c2\u00a7f" + (data.lagGoal == null ? "" : data.lagGoal.toString()))), false);
        }
        if (i + 1 < sortedData.size()) {
            source.func_197030_a(new StringTextComponent("next ---->").func_150255_a(new Style().func_150227_a(Boolean.valueOf(true)).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/performant reportEntities %d", i)))), false);
        }
    }

    public static void reportTileEntities(CommandSource source, int startIndex) {
        if (tileEntityReport.isEmpty()) {
            source.func_197030_a((ITextComponent)new StringTextComponent("\u00c2\u00a79Result is empty, no Tileentity was throttled or startGatherData command was not run yet. Server may not have reached the configured lag threshold before loadbalancing."), false);
            return;
        }
        ArrayList<ReportData> sortedData = new ArrayList<ReportData>(tileEntityReport.values());
        sortedData.sort(Comparator.comparingInt(ReportData::getTotelTickTime).reversed());
        int i = 0;
        for (i = startIndex; i < startIndex + 5 && i < sortedData.size(); ++i) {
            ReportData data = (ReportData)sortedData.get(i);
            if (data.te.func_145837_r()) {
                sortedData.remove(i);
                --i;
                continue;
            }
            source.func_197030_a(new StringTextComponent("\u00c2\u00a72Tileentity:\u00c2\u00a7f ").func_150257_a((ITextComponent)new TranslationTextComponent(data.te.func_195044_w().func_177230_c().func_149739_a(), new Object[0])).func_150257_a(new StringTextComponent(" \u00c2\u00a72pos:\u00c2\u00a7e" + data.te.func_174877_v()).func_150255_a(new Style().func_150227_a(Boolean.valueOf(true)).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format(TP_COMMAND, data.world.field_73011_w.func_186058_p().getRegistryName().toString(), data.te.func_174877_v().func_177958_n(), data.te.func_174877_v().func_177956_o(), data.te.func_174877_v().func_177952_p()))))).func_150257_a((ITextComponent)new StringTextComponent(" \u00c2\u00a72tickTime:\u00c2\u00a7f" + data.totalTickTime)), false);
        }
        if (i + 1 < sortedData.size()) {
            source.func_197030_a(new StringTextComponent("next ---->").func_150255_a(new Style().func_150227_a(Boolean.valueOf(true)).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/performant reportTileEntities %d", i)))), false);
        }
    }

    public static void reportEventData(CommandSource source, int startIndex) {
        ArrayList<EventReportData> listeners = new ArrayList<EventReportData>();
        ReportData.addPausedListenersToFrom(listeners, EventHandlerB.preWorldlisteners, EventHandlerB.preWorldTickPause, "preWorldTickEvent");
        ReportData.addPausedListenersToFrom(listeners, EventHandlerB.postWorldlisteners, EventHandlerB.postWorldTickPause, "postWorldTickEvent");
        ReportData.addPausedListenersToFrom(listeners, EventHandlerB.preServerlisteners, EventHandlerB.preServerTickPause, "preServerTickEvent");
        ReportData.addPausedListenersToFrom(listeners, EventHandlerB.postServerlisteners, EventHandlerB.postServerTickPause, "postServerTickEvent");
        listeners.sort(Comparator.comparingInt(rec$ -> ((EventReportData)rec$).getPauseTime()).reversed());
        int i = 0;
        for (i = startIndex; i < startIndex + 5 && i < listeners.size(); ++i) {
            EventReportData data = (EventReportData)listeners.get(i);
            source.func_197030_a((ITextComponent)new StringTextComponent("\u00c2\u00a72" + data.eventName + "\u00c2\u00a7f took: \u00c2\u00a72" + data.pauseTime + " \u00c2\u00a7f cause: \u00c2\u00a75 " + data.listener.toString().replace("ASM: net.minecraftforge.common.ForgeInternalHandler", "")), false);
        }
        if (i + 1 < listeners.size()) {
            source.func_197030_a(new StringTextComponent("next ---->").func_150255_a(new Style().func_150227_a(Boolean.valueOf(true)).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/performant reportEvents %d", i)))), false);
        }
    }

    private static void addPausedListenersToFrom(List<EventReportData> listeners, IEventListener[] listenersAdd, int[][] pauseTimesAdd, String name) {
        if (listenersAdd == null) {
            return;
        }
        for (int i = 0; i < listenersAdd.length; ++i) {
            if (pauseTimesAdd[0][i] <= 0) continue;
            listeners.add(new EventReportData(listenersAdd[i], pauseTimesAdd[1][i], name));
        }
    }

    private static class EventReportData {
        public IEventListener listener;
        public int pauseTime;
        public String eventName;

        public EventReportData(IEventListener listener, int pauseTime, String eventName) {
            this.listener = listener;
            this.pauseTime = pauseTime;
            this.eventName = eventName;
        }

        private int getPauseTime() {
            return this.pauseTime;
        }
    }
}

