/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.energy;

import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import owmii.lib.compat.curios.CuriosCompat;
import owmii.lib.util.Player;
import owmii.lib.util.Safe;
import owmii.lib.util.Stack;
import owmii.lib.util.lambda.Checker;

public class Energy
implements IEnergyStorage {
    public static final Energy EMPTY = Energy.create(0L);
    public static final Long MAX = 9000000000000000000L;
    public static final Long MIN = 0L;
    private long capacity;
    private long stored;
    private long maxExtract;
    private long maxReceive;

    public Energy(Energy energy) {
        this(energy.capacity, energy.maxExtract, energy.maxReceive);
        this.setStored(energy.stored);
    }

    public Energy(long capacity, long maxExtract, long maxReceive) {
        this.capacity = capacity;
        this.maxExtract = maxExtract;
        this.maxReceive = maxReceive;
    }

    public static Energy create(long capacity) {
        return Energy.create(capacity, capacity, capacity);
    }

    public static Energy create(long capacity, long transfer) {
        return Energy.create(capacity, transfer, transfer);
    }

    public static Energy from(Energy energy) {
        return Energy.create(energy.capacity, energy.maxExtract, energy.maxReceive);
    }

    public static Energy create(long capacity, long maxExtract, long maxReceive) {
        return new Energy(capacity, maxExtract, maxReceive);
    }

    public void readCapacity(CompoundNBT nbt) {
        this.capacity = nbt.func_74763_f("EnergyCapacity");
    }

    public CompoundNBT writeCapacity(CompoundNBT nbt) {
        nbt.func_74772_a("EnergyCapacity", this.capacity);
        return nbt;
    }

    public void readStored(CompoundNBT nbt) {
        this.stored = nbt.func_74763_f("StoredEnergy");
    }

    public CompoundNBT writeStored(CompoundNBT nbt) {
        nbt.func_74772_a("StoredEnergy", this.stored);
        return nbt;
    }

    public void readTransfer(CompoundNBT nbt) {
        this.maxExtract = nbt.func_74763_f("MaxEnergyExtract");
        this.maxReceive = nbt.func_74763_f("MaxEnergyReceive");
    }

    public CompoundNBT writeTransfer(CompoundNBT nbt) {
        nbt.func_74772_a("MaxEnergyExtract", this.maxExtract);
        nbt.func_74772_a("MaxEnergyReceive", this.maxReceive);
        return nbt;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        long energyReceived = Math.min(this.capacity - this.stored, Math.min(this.maxReceive, (long)maxReceive));
        if (!simulate) {
            this.stored += energyReceived;
        }
        return (int)energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        long energyExtracted = Math.min(this.stored, Math.min(this.maxExtract, (long)maxExtract));
        if (!simulate) {
            this.stored -= energyExtracted;
        }
        return (int)energyExtracted;
    }

    public void produce(long amount) {
        this.stored = Math.min(this.stored + amount, this.capacity);
    }

    public void consume(long amount) {
        this.stored = Math.max(this.stored - amount, 0L);
    }

    public long chargeInventory(PlayerEntity player, Checker<ItemStack> checker) {
        int received;
        long amount;
        long l = 0L;
        for (ItemStack stack1 : Player.invStacks(player)) {
            if (stack1.func_190926_b() || !Energy.isPresent(stack1) || !checker.check(stack1)) continue;
            amount = Math.min(this.getMaxExtract(), (long)this.getEnergyStored());
            if (amount <= 0L) break;
            received = Energy.receive(stack1, amount, false);
            l += (long)this.extractEnergy(received, false);
        }
        if (CuriosCompat.isLoaded()) {
            for (ItemStack stack1 : CuriosCompat.getAllStacks(player)) {
                if (stack1.func_190926_b() || !Energy.isPresent(stack1) || !checker.check(stack1)) continue;
                amount = Math.min(this.getMaxExtract(), (long)this.getEnergyStored());
                if (amount <= 0L) break;
                received = Energy.receive(stack1, amount, false);
                l += (long)this.extractEnergy(received, false);
            }
        }
        return l;
    }

    public long getEmpty() {
        return this.getCapacity() - this.getStored();
    }

    public long getCapacity() {
        return this.capacity;
    }

    public Energy setCapacity(long capacity) {
        this.capacity = capacity;
        return this;
    }

    public long getStored() {
        return this.stored;
    }

    public Energy setStored(long stored) {
        this.stored = Math.max(0L, Math.min(this.capacity, stored));
        return this;
    }

    public long getMaxExtract() {
        return this.maxExtract;
    }

    public Energy setMaxExtract(long maxExtract) {
        this.maxExtract = maxExtract;
        return this;
    }

    public long getMaxReceive() {
        return this.maxReceive;
    }

    public Energy setMaxReceive(long maxReceive) {
        this.maxReceive = maxReceive;
        return this;
    }

    public Energy setMaxTransfer() {
        this.maxReceive = MAX;
        this.maxExtract = MAX;
        return this;
    }

    public Energy setTransfer(long transfer) {
        this.maxReceive = transfer;
        this.maxExtract = transfer;
        return this;
    }

    public int getEnergyStored() {
        return Safe.integer(this.stored);
    }

    public int getMaxEnergyStored() {
        return Safe.integer(this.capacity);
    }

    public boolean canExtract() {
        return this.maxExtract > 0L && !this.isEmpty();
    }

    public boolean canReceive() {
        return this.maxReceive > 0L && !this.isFull();
    }

    public int toPixels(int total) {
        int i = (int)((float)this.stored / (float)this.capacity * (float)total);
        return !this.isEmpty() && i < 1 ? 1 : i;
    }

    public boolean hasEnergy() {
        return !this.isEmpty();
    }

    public boolean isEmpty() {
        return this.capacity > 0L && this.stored <= 0L;
    }

    public boolean isFull() {
        return this.stored > 0L && this.stored >= this.capacity;
    }

    public static int extract(ItemStack stack, long energy, boolean simulate) {
        return ((IEnergyStorage)Energy.get(stack).orElse((Object)EMPTY)).extractEnergy(Safe.integer(energy), simulate);
    }

    public static int receive(ItemStack stack, long energy, boolean simulate) {
        return ((IEnergyStorage)Energy.get(stack).orElse((Object)EMPTY)).receiveEnergy(Safe.integer(energy), simulate);
    }

    public static int getStored(ItemStack stack) {
        return ((IEnergyStorage)Energy.get(stack).orElse((Object)EMPTY)).getEnergyStored();
    }

    public static void ifPresent(ItemStack stack, NonNullConsumer<? super IEnergyStorage> consumer) {
        Energy.get(stack).ifPresent(consumer);
    }

    public static boolean isPresent(ItemStack stack) {
        return Energy.get(stack).isPresent();
    }

    public static LazyOptional<IEnergyStorage> get(ItemStack stack) {
        return !stack.func_190926_b() ? stack.getCapability(CapabilityEnergy.ENERGY, null) : LazyOptional.empty();
    }

    public static int extract(@Nullable TileEntity tile, Direction direction, long energy, boolean simulate) {
        return tile == null ? 0 : ((IEnergyStorage)Energy.get(tile, direction).orElse((Object)EMPTY)).extractEnergy(Safe.integer(energy), simulate);
    }

    public static int receive(@Nullable TileEntity tile, Direction direction, long energy, boolean simulate) {
        return tile == null ? 0 : ((IEnergyStorage)Energy.get(tile, direction).orElse((Object)EMPTY)).receiveEnergy(Safe.integer(energy), simulate);
    }

    public static void ifPresent(@Nullable TileEntity tile, @Nullable Direction direction, NonNullConsumer<? super IEnergyStorage> consumer) {
        Energy.get(tile, direction).ifPresent(consumer);
    }

    public static boolean isPresent(@Nullable TileEntity tile, @Nullable Direction direction) {
        return Energy.get(tile, direction).isPresent();
    }

    public static LazyOptional<IEnergyStorage> get(@Nullable TileEntity tile, @Nullable Direction direction) {
        return tile == null ? LazyOptional.empty() : tile.getCapability(CapabilityEnergy.ENERGY, direction != null ? direction.func_176734_d() : null);
    }

    public static boolean canExtract(@Nullable TileEntity tile, @Nullable Direction direction) {
        return tile != null && ((IEnergyStorage)Energy.get(tile, direction).orElse((Object)EMPTY)).canExtract();
    }

    public static boolean canReceive(@Nullable TileEntity tile, @Nullable Direction direction) {
        return tile != null && ((IEnergyStorage)Energy.get(tile, direction).orElse((Object)EMPTY)).canReceive();
    }

    public static class Item
    extends Energy {
        private final ItemStack stack;

        public Item(ItemStack stack, Item energy) {
            super(energy);
            this.stack = stack;
        }

        public Item(ItemStack stack, long capacity, long maxExtract, long maxReceive) {
            super(capacity, maxExtract, maxReceive);
            this.stack = stack;
            this.readStored(Stack.getTagOrEmpty(stack).func_74775_l("lollipopTileStorableNBT"));
        }

        @Override
        public int receiveEnergy(int maxReceive, boolean simulate) {
            int energy = super.receiveEnergy(maxReceive, simulate);
            if (!simulate) {
                this.writeStored(this.stack.func_190925_c("lollipopTileStorableNBT"));
            }
            return energy;
        }

        @Override
        public int extractEnergy(int maxExtract, boolean simulate) {
            int energy = super.extractEnergy(maxExtract, simulate);
            if (!simulate) {
                this.writeStored(this.stack.func_190925_c("lollipopTileStorableNBT"));
            }
            return energy;
        }

        public static class Provider
        implements ICapabilityProvider {
            private final ItemStack stack;
            private final long capacity;
            private final long maxExtract;
            private final long maxReceive;

            public Provider(ItemStack stack, long capacity, long maxExtract, long maxReceive) {
                this.stack = stack;
                this.capacity = capacity;
                this.maxExtract = maxExtract;
                this.maxReceive = maxReceive;
            }

            public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
                return cap == CapabilityEnergy.ENERGY ? LazyOptional.of(() -> new Item(this.stack, this.capacity, this.maxExtract, this.maxReceive)).cast() : LazyOptional.empty();
            }
        }
    }
}

