/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.client.screen.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class IconButton
extends Button {
    private final List<String> tooltip = new ArrayList<String>();
    private final ResourceLocation texture;
    private final Screen screen;
    private int xTexStart;
    private int yTexStart;
    private int yDiffText;
    private final int uvw;
    private final int uvh;

    public IconButton(int x, int y, int w, int h, int xTexStart, int yTexStart, int yDiffText, ResourceLocation icon, Button.IPressable iPressable, Screen screen) {
        this(x, y, w, h, xTexStart, yTexStart, yDiffText, icon, 256, 256, iPressable, screen);
    }

    public IconButton(int x, int y, int w, int h, int xTexStart, int yTexStart, int yDiffText, ResourceLocation location, int uvw, int uvh, Button.IPressable pressable, Screen screen) {
        this(x, y, w, h, xTexStart, yTexStart, yDiffText, location, uvw, uvh, pressable, "", screen);
    }

    public IconButton(int x, int y, int w, int h, int xTexStart, int yTexStart, int yDiffText, ResourceLocation texture, int uvw, int uvh, Button.IPressable p_i51136_11_, String p_i51136_12_, Screen screen) {
        super(x, y, w, h, p_i51136_12_, p_i51136_11_);
        this.uvw = uvw;
        this.uvh = uvh;
        this.xTexStart = xTexStart;
        this.yTexStart = yTexStart;
        this.yDiffText = yDiffText;
        this.texture = texture;
        this.screen = screen;
    }

    public void renderToolTip(int x, int y) {
        super.renderToolTip(x, y);
        this.screen.renderTooltip(this.tooltip, x, y);
    }

    public IconButton tooltip(String s, Object ... args) {
        return this.tooltip(s, TextFormatting.RESET, args);
    }

    public IconButton tooltip(String s, TextFormatting formatting, Object ... args) {
        this.tooltip.add(formatting + I18n.func_135052_a((String)s, (Object[])args));
        return this;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setIconDiff(int xTexStart) {
        this.xTexStart = xTexStart;
    }

    public List<String> getTooltip() {
        return this.tooltip;
    }

    public void renderButton(int x, int y, float p_renderButton_3_) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(this.texture);
        RenderSystem.disableDepthTest();
        int i = this.yTexStart;
        if (this.isHovered()) {
            i += this.yDiffText;
        }
        IconButton.blit((int)this.x, (int)this.y, (float)this.xTexStart, (float)i, (int)this.width, (int)this.height, (int)this.uvw, (int)this.uvh);
        RenderSystem.enableDepthTest();
    }
}

