/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.energy.IEnergyStorage;
import owmii.lib.api.energy.INoTileEnergy;
import owmii.lib.block.AbstractBlock;
import owmii.lib.block.TileBase;
import owmii.lib.config.IEnergyConfig;
import owmii.lib.energy.Energy;
import owmii.lib.energy.SideConfig;
import owmii.lib.item.BlockItemBase;
import owmii.lib.item.EnergyBlockItem;
import owmii.lib.util.IVariant;
import owmii.lib.util.Text;

public abstract class AbstractEnergyBlock<E extends IVariant>
extends AbstractBlock<E> {
    public AbstractEnergyBlock(Block.Properties properties, E variant) {
        super(properties, variant);
    }

    public AbstractEnergyBlock(Block.Properties properties) {
        super(properties);
    }

    @Override
    public BlockItemBase getBlockItem(Item.Properties properties, @Nullable ItemGroup group) {
        return new EnergyBlockItem(this, properties, group);
    }

    public abstract IEnergyConfig<E> getEnergyConfig();

    public SideConfig.Type getTransferType() {
        return SideConfig.Type.ALL;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        if (this.checkValidEnergySide()) {
            Direction direction = (Direction)state.func_177229_b((IProperty)FACING);
            BlockPos blockpos = pos.func_177972_a(direction);
            BlockState state1 = worldIn.func_180495_p(blockpos);
            TileEntity tile = worldIn.func_175625_s(blockpos);
            return state1.func_177230_c() instanceof INoTileEnergy || Energy.isPresent(tile, direction);
        }
        return super.func_196260_a(state, worldIn, pos);
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileBase.EnergyStorage) {
            TileBase.EnergyStorage storage = (TileBase.EnergyStorage)tile;
            return storage.getEnergyStorage().toPixels(15);
        }
        return super.func_180641_l(blockState, worldIn, pos);
    }

    protected boolean checkValidEnergySide() {
        return false;
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        Energy.ifPresent(stack, (NonNullConsumer<? super IEnergyStorage>)((NonNullConsumer)storage -> {
            if (storage instanceof Energy.Item) {
                Energy.Item energy = (Energy.Item)storage;
                this.addEnergyInfo(stack, energy, tooltip);
                this.addEnergyTransferInfo(stack, energy, tooltip);
                this.additionalEnergyInfo(stack, energy, tooltip);
                tooltip.add((ITextComponent)new StringTextComponent(""));
            }
        }));
    }

    public void addEnergyInfo(ItemStack stack, Energy.Item storage, List<ITextComponent> tooltip) {
        if (storage.getCapacity() > 0L) {
            tooltip.add(new TranslationTextComponent("info.lollipop.stored.energy.fe", new Object[]{TextFormatting.DARK_GRAY + Text.addCommas(storage.getStored()), Text.numFormat(storage.getCapacity())}).func_211708_a(TextFormatting.GRAY));
        }
    }

    public void addEnergyTransferInfo(ItemStack stack, Energy.Item storage, List<ITextComponent> tooltip) {
        long re;
        long ext = storage.getMaxExtract();
        if (ext + (re = storage.getMaxReceive()) > 0L) {
            if (ext == re) {
                tooltip.add(new TranslationTextComponent("info.lollipop.max.transfer.fe", new Object[]{TextFormatting.DARK_GRAY + Text.numFormat(ext)}).func_211708_a(TextFormatting.GRAY));
            } else {
                if (ext > 0L) {
                    tooltip.add(new TranslationTextComponent("info.lollipop.max.extract.fe", new Object[]{TextFormatting.DARK_GRAY + Text.numFormat(ext)}).func_211708_a(TextFormatting.GRAY));
                }
                if (re > 0L) {
                    tooltip.add(new TranslationTextComponent("info.lollipop.max.receive.fe", new Object[]{TextFormatting.DARK_GRAY + Text.numFormat(re)}).func_211708_a(TextFormatting.GRAY));
                }
            }
        }
    }

    public void additionalEnergyInfo(ItemStack stack, Energy.Item energy, List<ITextComponent> tooltip) {
    }
}

