/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.modifier.attribute;

import com.google.common.collect.Maps;
import com.valkyrieofnight.vlib.modifier.attribute.Attribute;
import com.valkyrieofnight.vlib.modifier.attribute.AttributeID;
import java.util.Map;

public class AttributeRegistry {
    private static AttributeRegistry inst;
    protected Map<AttributeID, Attribute> attributeMap = Maps.newHashMap();

    public static AttributeRegistry getInstance() {
        if (inst == null) {
            inst = new AttributeRegistry();
        }
        return inst;
    }

    private AttributeRegistry() {
    }

    public void register(Attribute attribute) {
        if (attribute == null) {
            return;
        }
        this.attributeMap.put(attribute.getID(), attribute);
    }

    public boolean hasAttribute(AttributeID attributeID) {
        if (attributeID == null) {
            return false;
        }
        return this.attributeMap.containsKey(attributeID);
    }

    public Attribute getByID(AttributeID attributeID) {
        if (!this.attributeMap.containsKey(attributeID)) {
            return null;
        }
        return this.attributeMap.get(attributeID);
    }
}

