/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import com.mojang.datafixers.DataFixer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.DefaultTypeReferences;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.storage.IPlayerFileData;
import net.minecraft.world.storage.SaveFormat;
import net.minecraft.world.storage.SessionLockException;
import net.minecraft.world.storage.WorldInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SaveHandler
implements IPlayerFileData {
    private static final Logger field_215773_b = LogManager.getLogger();
    private final File field_215774_c;
    private final File field_215775_d;
    private final long field_215776_e = Util.func_211177_b();
    private final String field_215777_f;
    private final TemplateManager field_215778_g;
    protected final DataFixer field_215772_a;

    public SaveHandler(File file, String string, @Nullable MinecraftServer minecraftServer, DataFixer dataFixer) {
        this.field_215772_a = dataFixer;
        this.field_215774_c = new File(file, string);
        this.field_215774_c.mkdirs();
        this.field_215775_d = new File(this.field_215774_c, "playerdata");
        this.field_215777_f = string;
        if (minecraftServer != null) {
            this.field_215775_d.mkdirs();
            this.field_215778_g = new TemplateManager(minecraftServer, this.field_215774_c, dataFixer);
        } else {
            this.field_215778_g = null;
        }
        this.func_215770_h();
    }

    public void func_75755_a(WorldInfo worldInfo, @Nullable CompoundNBT compoundNBT) {
        worldInfo.func_76078_e(19133);
        \u2603 = worldInfo.func_76082_a(compoundNBT);
        \u2603 = new CompoundNBT();
        \u2603.func_218657_a("Data", \u2603);
        try {
            File file = new File(this.field_215774_c, "level.dat_new");
            \u2603 = new File(this.field_215774_c, "level.dat_old");
            \u2603 = new File(this.field_215774_c, "level.dat");
            CompressedStreamTools.func_74799_a(\u2603, new FileOutputStream(file));
            if (\u2603.exists()) {
                \u2603.delete();
            }
            \u2603.renameTo(\u2603);
            if (\u2603.exists()) {
                \u2603.delete();
            }
            file.renameTo(\u2603);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void func_215770_h() {
        try {
            File file = new File(this.field_215774_c, "session.lock");
            try (DataOutputStream \u26032 = new DataOutputStream(new FileOutputStream(file));){
                \u26032.writeLong(this.field_215776_e);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException("Failed to check session lock, aborting");
        }
    }

    public File func_75765_b() {
        return this.field_215774_c;
    }

    public void func_75762_c() throws SessionLockException {
        try {
            File file = new File(this.field_215774_c, "session.lock");
            try (DataInputStream \u26032 = new DataInputStream(new FileInputStream(file));){
                if (\u26032.readLong() != this.field_215776_e) {
                    throw new SessionLockException("The save is being accessed from another location, aborting");
                }
            }
        }
        catch (IOException iOException) {
            throw new SessionLockException("Failed to check session lock, aborting");
        }
    }

    @Nullable
    public WorldInfo func_75757_d() {
        File file = new File(this.field_215774_c, "level.dat");
        if (file.exists() && (\u2603 = SaveFormat.func_215780_a(file, this.field_215772_a)) != null) {
            return \u2603;
        }
        file = new File(this.field_215774_c, "level.dat_old");
        if (file.exists()) {
            return SaveFormat.func_215780_a(file, this.field_215772_a);
        }
        return null;
    }

    public void func_75761_a(WorldInfo worldInfo) {
        this.func_75755_a(worldInfo, null);
    }

    @Override
    public void func_75753_a(PlayerEntity playerEntity) {
        try {
            CompoundNBT compoundNBT = playerEntity.func_189511_e(new CompoundNBT());
            File \u26032 = new File(this.field_215775_d, playerEntity.func_189512_bd() + ".dat.tmp");
            File \u26033 = new File(this.field_215775_d, playerEntity.func_189512_bd() + ".dat");
            CompressedStreamTools.func_74799_a(compoundNBT, new FileOutputStream(\u26032));
            if (\u26033.exists()) {
                \u26033.delete();
            }
            \u26032.renameTo(\u26033);
        }
        catch (Exception exception) {
            field_215773_b.warn("Failed to save player data for {}", (Object)playerEntity.func_200200_C_().getString());
        }
    }

    @Override
    @Nullable
    public CompoundNBT func_75752_b(PlayerEntity playerEntity) {
        CompoundNBT compoundNBT = null;
        try {
            File file = new File(this.field_215775_d, playerEntity.func_189512_bd() + ".dat");
            if (file.exists() && file.isFile()) {
                compoundNBT = CompressedStreamTools.func_74796_a(new FileInputStream(file));
            }
        }
        catch (Exception exception) {
            field_215773_b.warn("Failed to load player data for {}", (Object)playerEntity.func_200200_C_().getString());
        }
        if (compoundNBT != null) {
            int n = compoundNBT.func_150297_b("DataVersion", 3) ? compoundNBT.func_74762_e("DataVersion") : -1;
            playerEntity.func_70020_e(NBTUtil.func_210822_a(this.field_215772_a, DefaultTypeReferences.PLAYER, compoundNBT, n));
        }
        return compoundNBT;
    }

    public String[] func_215771_d() {
        String[] stringArray = this.field_215775_d.list();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith(".dat")) continue;
            stringArray[i] = stringArray[i].substring(0, stringArray[i].length() - 4);
        }
        return stringArray;
    }

    public TemplateManager func_186340_h() {
        return this.field_215778_g;
    }

    public DataFixer func_197718_i() {
        return this.field_215772_a;
    }
}

