/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.impl.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.NBTCompoundTagArgument;
import net.minecraft.command.arguments.NBTPathArgument;
import net.minecraft.command.arguments.NBTTagArgument;
import net.minecraft.command.impl.data.BlockDataAccessor;
import net.minecraft.command.impl.data.EntityDataAccessor;
import net.minecraft.command.impl.data.IDataAccessor;
import net.minecraft.command.impl.data.StorageAccessor;
import net.minecraft.nbt.CollectionNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TranslationTextComponent;

public class DataCommand {
    private static final SimpleCommandExceptionType field_198949_b = new SimpleCommandExceptionType((Message)new TranslationTextComponent("commands.data.merge.failed", new Object[0]));
    private static final DynamicCommandExceptionType field_198950_c = new DynamicCommandExceptionType(object -> new TranslationTextComponent("commands.data.get.invalid", object));
    private static final DynamicCommandExceptionType field_201229_d = new DynamicCommandExceptionType(object -> new TranslationTextComponent("commands.data.get.unknown", object));
    private static final SimpleCommandExceptionType field_218957_g = new SimpleCommandExceptionType((Message)new TranslationTextComponent("commands.data.get.multiple", new Object[0]));
    private static final DynamicCommandExceptionType field_218958_h = new DynamicCommandExceptionType(object -> new TranslationTextComponent("commands.data.modify.expected_list", object));
    private static final DynamicCommandExceptionType field_218959_i = new DynamicCommandExceptionType(object -> new TranslationTextComponent("commands.data.modify.expected_object", object));
    private static final DynamicCommandExceptionType field_218960_j = new DynamicCommandExceptionType(object -> new TranslationTextComponent("commands.data.modify.invalid_index", object));
    public static final List<Function<String, IDataProvider>> field_198948_a = ImmutableList.of(EntityDataAccessor.field_198926_a, BlockDataAccessor.field_198930_a, StorageAccessor.field_229833_a_);
    public static final List<IDataProvider> field_218955_b = (List)field_198948_a.stream().map(function -> (IDataProvider)function.apply("target")).collect(ImmutableList.toImmutableList());
    public static final List<IDataProvider> field_218956_c = (List)field_198948_a.stream().map(function -> (IDataProvider)function.apply("source")).collect(ImmutableList.toImmutableList());

    public static void func_198937_a(CommandDispatcher<CommandSource> commandDispatcher2) {
        CommandDispatcher<CommandSource> commandDispatcher2;
        LiteralArgumentBuilder literalArgumentBuilder = (LiteralArgumentBuilder)Commands.func_197057_a("data").requires(commandSource -> commandSource.func_197034_c(2));
        for (IDataProvider iDataProvider : field_218955_b) {
            ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)literalArgumentBuilder.then(iDataProvider.func_198920_a((ArgumentBuilder<CommandSource, ?>)Commands.func_197057_a("merge"), argumentBuilder -> argumentBuilder.then(Commands.func_197056_a("nbt", NBTCompoundTagArgument.func_218043_a()).executes(commandContext -> DataCommand.func_198946_a((CommandSource)commandContext.getSource(), iDataProvider.func_198919_a((CommandContext<CommandSource>)commandContext), NBTCompoundTagArgument.func_218042_a(commandContext, "nbt"))))))).then(iDataProvider.func_198920_a((ArgumentBuilder<CommandSource, ?>)Commands.func_197057_a("get"), argumentBuilder -> argumentBuilder.executes(commandContext -> DataCommand.func_198947_a((CommandSource)commandContext.getSource(), iDataProvider.func_198919_a((CommandContext<CommandSource>)commandContext))).then(((RequiredArgumentBuilder)Commands.func_197056_a("path", NBTPathArgument.func_197149_a()).executes(commandContext -> DataCommand.func_201228_b((CommandSource)commandContext.getSource(), iDataProvider.func_198919_a((CommandContext<CommandSource>)commandContext), NBTPathArgument.func_197148_a((CommandContext<CommandSource>)commandContext, "path")))).then(Commands.func_197056_a("scale", DoubleArgumentType.doubleArg()).executes(commandContext -> DataCommand.func_198938_a((CommandSource)commandContext.getSource(), iDataProvider.func_198919_a((CommandContext<CommandSource>)commandContext), NBTPathArgument.func_197148_a((CommandContext<CommandSource>)commandContext, "path"), DoubleArgumentType.getDouble((CommandContext)commandContext, (String)"scale")))))))).then(iDataProvider.func_198920_a((ArgumentBuilder<CommandSource, ?>)Commands.func_197057_a("remove"), argumentBuilder -> argumentBuilder.then(Commands.func_197056_a("path", NBTPathArgument.func_197149_a()).executes(commandContext -> DataCommand.func_198942_a((CommandSource)commandContext.getSource(), iDataProvider.func_198919_a((CommandContext<CommandSource>)commandContext), NBTPathArgument.func_197148_a((CommandContext<CommandSource>)commandContext, "path"))))))).then(DataCommand.func_218935_a((argumentBuilder, iModificationSourceArgumentBuilder) -> argumentBuilder.then(Commands.func_197057_a("insert").then(Commands.func_197056_a("index", IntegerArgumentType.integer()).then(iModificationSourceArgumentBuilder.create((commandContext, compoundNBT, nBTPath, list) -> {
                int n = IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"index");
                return DataCommand.func_218944_a(n, compoundNBT, nBTPath, list);
            })))).then(Commands.func_197057_a("prepend").then(iModificationSourceArgumentBuilder.create((commandContext, compoundNBT, nBTPath, list) -> DataCommand.func_218944_a(0, compoundNBT, nBTPath, list)))).then(Commands.func_197057_a("append").then(iModificationSourceArgumentBuilder.create((commandContext, compoundNBT, nBTPath, list) -> DataCommand.func_218944_a(-1, compoundNBT, nBTPath, list)))).then(Commands.func_197057_a("set").then(iModificationSourceArgumentBuilder.create((commandContext, compoundNBT, nBTPath, list) -> nBTPath.func_218076_b(compoundNBT, ((INBT)Iterables.getLast((Iterable)list))::func_74737_b)))).then(Commands.func_197057_a("merge").then(iModificationSourceArgumentBuilder.create((commandContext, compoundNBT, nBTPath, list) -> {
                List<INBT> list2 = nBTPath.func_218073_a(compoundNBT, CompoundNBT::new);
                int \u26032 = 0;
                for (INBT iNBT : list2) {
                    CompoundNBT compoundNBT2;
                    if (!(iNBT instanceof CompoundNBT)) {
                        throw field_218959_i.create((Object)iNBT);
                    }
                    CompoundNBT compoundNBT3 = (CompoundNBT)iNBT;
                    compoundNBT2 = compoundNBT3.func_74737_b();
                    for (INBT iNBT2 : list) {
                        if (!(iNBT2 instanceof CompoundNBT)) {
                            throw field_218959_i.create((Object)iNBT2);
                        }
                        compoundNBT3.func_197643_a((CompoundNBT)iNBT2);
                    }
                    \u26032 += compoundNBT2.equals(compoundNBT3) ? 0 : 1;
                }
                return \u26032;
            })))));
        }
        commandDispatcher2.register(literalArgumentBuilder);
    }

    private static int func_218944_a(int n, CompoundNBT compoundNBT, NBTPathArgument.NBTPath nBTPath, List<INBT> list) throws CommandSyntaxException {
        \u2603 = nBTPath.func_218073_a(compoundNBT, ListNBT::new);
        int n2 = 0;
        for (INBT iNBT : \u2603) {
            if (!(iNBT instanceof CollectionNBT)) {
                throw field_218958_h.create((Object)iNBT);
            }
            boolean bl = false;
            CollectionNBT \u26032 = (CollectionNBT)iNBT;
            int \u26033 = n < 0 ? \u26032.size() + n + 1 : n;
            for (INBT iNBT2 : list) {
                try {
                    if (!\u26032.func_218660_b(\u26033, iNBT2.func_74737_b())) continue;
                    ++\u26033;
                    bl = true;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw field_218960_j.create((Object)\u26033);
                }
            }
            n2 += bl ? 1 : 0;
        }
        return n2;
    }

    private static ArgumentBuilder<CommandSource, ?> func_218935_a(BiConsumer<ArgumentBuilder<CommandSource, ?>, IModificationSourceArgumentBuilder> biConsumer) {
        LiteralArgumentBuilder<CommandSource> literalArgumentBuilder = Commands.func_197057_a("modify");
        for (IDataProvider iDataProvider : field_218955_b) {
            iDataProvider.func_198920_a((ArgumentBuilder<CommandSource, ?>)literalArgumentBuilder, argumentBuilder -> {
                BiConsumer biConsumer2;
                RequiredArgumentBuilder<CommandSource, NBTPathArgument.NBTPath> requiredArgumentBuilder = Commands.func_197056_a("targetPath", NBTPathArgument.func_197149_a());
                for (IDataProvider iDataProvider2 : field_218956_c) {
                    biConsumer.accept((ArgumentBuilder<CommandSource, ?>)requiredArgumentBuilder, iModificationType -> iDataProvider2.func_198920_a((ArgumentBuilder<CommandSource, ?>)Commands.func_197057_a("from"), argumentBuilder -> argumentBuilder.executes(commandContext -> {
                        List<INBT> list = Collections.singletonList(iDataProvider2.func_198919_a((CommandContext<CommandSource>)commandContext).func_198923_a());
                        return DataCommand.func_218933_a((CommandContext<CommandSource>)commandContext, iDataProvider, iModificationType, list);
                    }).then(Commands.func_197056_a("sourcePath", NBTPathArgument.func_197149_a()).executes(commandContext -> {
                        IDataAccessor iDataAccessor = iDataProvider2.func_198919_a((CommandContext<CommandSource>)commandContext);
                        NBTPathArgument.NBTPath \u26032 = NBTPathArgument.func_197148_a((CommandContext<CommandSource>)commandContext, "sourcePath");
                        List<INBT> \u26033 = \u26032.func_218071_a(iDataAccessor.func_198923_a());
                        return DataCommand.func_218933_a((CommandContext<CommandSource>)commandContext, iDataProvider, iModificationType, \u26033);
                    }))));
                }
                biConsumer.accept((ArgumentBuilder<CommandSource, ?>)requiredArgumentBuilder, iModificationType -> (LiteralArgumentBuilder)Commands.func_197057_a("value").then(Commands.func_197056_a("value", NBTTagArgument.func_218085_a()).executes(commandContext -> {
                    List<INBT> list = Collections.singletonList(NBTTagArgument.func_218086_a(commandContext, "value"));
                    return DataCommand.func_218933_a((CommandContext<CommandSource>)commandContext, iDataProvider, iModificationType, list);
                })));
                return argumentBuilder.then(requiredArgumentBuilder);
            });
        }
        return literalArgumentBuilder;
    }

    private static int func_218933_a(CommandContext<CommandSource> commandContext, IDataProvider iDataProvider, IModificationType iModificationType, List<INBT> list) throws CommandSyntaxException {
        IDataAccessor iDataAccessor = iDataProvider.func_198919_a(commandContext);
        NBTPathArgument.NBTPath \u26032 = NBTPathArgument.func_197148_a(commandContext, "targetPath");
        CompoundNBT \u26033 = iDataAccessor.func_198923_a();
        int \u26034 = iModificationType.modify(commandContext, \u26033, \u26032, list);
        if (\u26034 == 0) {
            throw field_198949_b.create();
        }
        iDataAccessor.func_198925_a(\u26033);
        ((CommandSource)commandContext.getSource()).func_197030_a(iDataAccessor.func_198921_b(), true);
        return \u26034;
    }

    private static int func_198942_a(CommandSource commandSource, IDataAccessor iDataAccessor, NBTPathArgument.NBTPath nBTPath) throws CommandSyntaxException {
        CompoundNBT compoundNBT = iDataAccessor.func_198923_a();
        int \u26032 = nBTPath.func_218068_c(compoundNBT);
        if (\u26032 == 0) {
            throw field_198949_b.create();
        }
        iDataAccessor.func_198925_a(compoundNBT);
        commandSource.func_197030_a(iDataAccessor.func_198921_b(), true);
        return \u26032;
    }

    private static INBT func_218928_a(NBTPathArgument.NBTPath nBTPath, IDataAccessor iDataAccessor) throws CommandSyntaxException {
        List<INBT> list = nBTPath.func_218071_a(iDataAccessor.func_198923_a());
        Iterator \u26032 = list.iterator();
        INBT \u26033 = (INBT)\u26032.next();
        if (\u26032.hasNext()) {
            throw field_218957_g.create();
        }
        return \u26033;
    }

    private static int func_201228_b(CommandSource commandSource2, IDataAccessor iDataAccessor, NBTPathArgument.NBTPath nBTPath2) throws CommandSyntaxException {
        CommandSource commandSource2;
        int n;
        INBT iNBT = DataCommand.func_218928_a(nBTPath2, iDataAccessor);
        if (iNBT instanceof NumberNBT) {
            n = MathHelper.func_76128_c(((NumberNBT)iNBT).func_150286_g());
        } else if (iNBT instanceof CollectionNBT) {
            n = ((CollectionNBT)iNBT).size();
        } else if (iNBT instanceof CompoundNBT) {
            n = ((CompoundNBT)iNBT).func_186856_d();
        } else if (iNBT instanceof StringNBT) {
            n = iNBT.func_150285_a_().length();
        } else {
            NBTPathArgument.NBTPath nBTPath2;
            throw field_201229_d.create((Object)nBTPath2.toString());
        }
        commandSource2.func_197030_a(iDataAccessor.func_198924_b(iNBT), false);
        return n;
    }

    private static int func_198938_a(CommandSource commandSource, IDataAccessor iDataAccessor, NBTPathArgument.NBTPath nBTPath, double d) throws CommandSyntaxException {
        INBT iNBT = DataCommand.func_218928_a(nBTPath, iDataAccessor);
        if (!(iNBT instanceof NumberNBT)) {
            throw field_198950_c.create((Object)nBTPath.toString());
        }
        int \u26032 = MathHelper.func_76128_c(((NumberNBT)iNBT).func_150286_g() * d);
        commandSource.func_197030_a(iDataAccessor.func_198922_a(nBTPath, d, \u26032), false);
        return \u26032;
    }

    private static int func_198947_a(CommandSource commandSource, IDataAccessor iDataAccessor) throws CommandSyntaxException {
        commandSource.func_197030_a(iDataAccessor.func_198924_b(iDataAccessor.func_198923_a()), false);
        return 1;
    }

    private static int func_198946_a(CommandSource commandSource, IDataAccessor iDataAccessor, CompoundNBT compoundNBT) throws CommandSyntaxException {
        \u2603 = iDataAccessor.func_198923_a();
        if (\u2603.equals(\u2603 = \u2603.func_74737_b().func_197643_a(compoundNBT))) {
            throw field_198949_b.create();
        }
        iDataAccessor.func_198925_a(\u2603);
        commandSource.func_197030_a(iDataAccessor.func_198921_b(), true);
        return 1;
    }

    public static interface IDataProvider {
        public IDataAccessor func_198919_a(CommandContext<CommandSource> var1) throws CommandSyntaxException;

        public ArgumentBuilder<CommandSource, ?> func_198920_a(ArgumentBuilder<CommandSource, ?> var1, Function<ArgumentBuilder<CommandSource, ?>, ArgumentBuilder<CommandSource, ?>> var2);
    }

    static interface IModificationSourceArgumentBuilder {
        public ArgumentBuilder<CommandSource, ?> create(IModificationType var1);
    }

    static interface IModificationType {
        public int modify(CommandContext<CommandSource> var1, CompoundNBT var2, NBTPathArgument.NBTPath var3, List<INBT> var4) throws CommandSyntaxException;
    }
}

