/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.arguments;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.command.arguments.ArgumentSerializer;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.command.arguments.BlockPredicateArgument;
import net.minecraft.command.arguments.BlockStateArgument;
import net.minecraft.command.arguments.ColorArgument;
import net.minecraft.command.arguments.ColumnPosArgument;
import net.minecraft.command.arguments.ComponentArgument;
import net.minecraft.command.arguments.DimensionArgument;
import net.minecraft.command.arguments.EnchantmentArgument;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.EntitySummonArgument;
import net.minecraft.command.arguments.FunctionArgument;
import net.minecraft.command.arguments.GameProfileArgument;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.command.arguments.IRangeArgument;
import net.minecraft.command.arguments.ItemArgument;
import net.minecraft.command.arguments.ItemPredicateArgument;
import net.minecraft.command.arguments.MessageArgument;
import net.minecraft.command.arguments.NBTCompoundTagArgument;
import net.minecraft.command.arguments.NBTPathArgument;
import net.minecraft.command.arguments.NBTTagArgument;
import net.minecraft.command.arguments.ObjectiveArgument;
import net.minecraft.command.arguments.ObjectiveCriteriaArgument;
import net.minecraft.command.arguments.OperationArgument;
import net.minecraft.command.arguments.ParticleArgument;
import net.minecraft.command.arguments.PotionArgument;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.command.arguments.RotationArgument;
import net.minecraft.command.arguments.ScoreHolderArgument;
import net.minecraft.command.arguments.ScoreboardSlotArgument;
import net.minecraft.command.arguments.SlotArgument;
import net.minecraft.command.arguments.SwizzleArgument;
import net.minecraft.command.arguments.TeamArgument;
import net.minecraft.command.arguments.TimeArgument;
import net.minecraft.command.arguments.Vec2Argument;
import net.minecraft.command.arguments.Vec3Argument;
import net.minecraft.command.arguments.serializers.BrigadierSerializers;
import net.minecraft.network.PacketBuffer;
import net.minecraft.test.TestArgArgument;
import net.minecraft.test.TestTypeArgument;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ArgumentTypes {
    private static final Logger field_197488_a = LogManager.getLogger();
    private static final Map<Class<?>, Entry<?>> field_197489_b = Maps.newHashMap();
    private static final Map<ResourceLocation, Entry<?>> field_197490_c = Maps.newHashMap();

    public static <T extends ArgumentType<?>> void func_218136_a(String string, Class<T> clazz, IArgumentSerializer<T> iArgumentSerializer) {
        ResourceLocation resourceLocation = new ResourceLocation(string);
        if (field_197489_b.containsKey(clazz)) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " already has a serializer!");
        }
        if (field_197490_c.containsKey(resourceLocation)) {
            throw new IllegalArgumentException("'" + resourceLocation + "' is already a registered serializer!");
        }
        Entry \u26032 = new Entry(clazz, iArgumentSerializer, resourceLocation);
        field_197489_b.put(clazz, \u26032);
        field_197490_c.put(resourceLocation, \u26032);
    }

    public static void func_197483_a() {
        BrigadierSerializers.func_197511_a();
        ArgumentTypes.func_218136_a("entity", EntityArgument.class, new EntityArgument.Serializer());
        ArgumentTypes.func_218136_a("game_profile", GameProfileArgument.class, new ArgumentSerializer<GameProfileArgument>(GameProfileArgument::func_197108_a));
        ArgumentTypes.func_218136_a("block_pos", BlockPosArgument.class, new ArgumentSerializer<BlockPosArgument>(BlockPosArgument::func_197276_a));
        ArgumentTypes.func_218136_a("column_pos", ColumnPosArgument.class, new ArgumentSerializer<ColumnPosArgument>(ColumnPosArgument::func_212603_a));
        ArgumentTypes.func_218136_a("vec3", Vec3Argument.class, new ArgumentSerializer<Vec3Argument>(Vec3Argument::func_197301_a));
        ArgumentTypes.func_218136_a("vec2", Vec2Argument.class, new ArgumentSerializer<Vec2Argument>(Vec2Argument::func_197296_a));
        ArgumentTypes.func_218136_a("block_state", BlockStateArgument.class, new ArgumentSerializer<BlockStateArgument>(BlockStateArgument::func_197239_a));
        ArgumentTypes.func_218136_a("block_predicate", BlockPredicateArgument.class, new ArgumentSerializer<BlockPredicateArgument>(BlockPredicateArgument::func_199824_a));
        ArgumentTypes.func_218136_a("item_stack", ItemArgument.class, new ArgumentSerializer<ItemArgument>(ItemArgument::func_197317_a));
        ArgumentTypes.func_218136_a("item_predicate", ItemPredicateArgument.class, new ArgumentSerializer<ItemPredicateArgument>(ItemPredicateArgument::func_199846_a));
        ArgumentTypes.func_218136_a("color", ColorArgument.class, new ArgumentSerializer<ColorArgument>(ColorArgument::func_197063_a));
        ArgumentTypes.func_218136_a("component", ComponentArgument.class, new ArgumentSerializer<ComponentArgument>(ComponentArgument::func_197067_a));
        ArgumentTypes.func_218136_a("message", MessageArgument.class, new ArgumentSerializer<MessageArgument>(MessageArgument::func_197123_a));
        ArgumentTypes.func_218136_a("nbt_compound_tag", NBTCompoundTagArgument.class, new ArgumentSerializer<NBTCompoundTagArgument>(NBTCompoundTagArgument::func_218043_a));
        ArgumentTypes.func_218136_a("nbt_tag", NBTTagArgument.class, new ArgumentSerializer<NBTTagArgument>(NBTTagArgument::func_218085_a));
        ArgumentTypes.func_218136_a("nbt_path", NBTPathArgument.class, new ArgumentSerializer<NBTPathArgument>(NBTPathArgument::func_197149_a));
        ArgumentTypes.func_218136_a("objective", ObjectiveArgument.class, new ArgumentSerializer<ObjectiveArgument>(ObjectiveArgument::func_197157_a));
        ArgumentTypes.func_218136_a("objective_criteria", ObjectiveCriteriaArgument.class, new ArgumentSerializer<ObjectiveCriteriaArgument>(ObjectiveCriteriaArgument::func_197162_a));
        ArgumentTypes.func_218136_a("operation", OperationArgument.class, new ArgumentSerializer<OperationArgument>(OperationArgument::func_197184_a));
        ArgumentTypes.func_218136_a("particle", ParticleArgument.class, new ArgumentSerializer<ParticleArgument>(ParticleArgument::func_197190_a));
        ArgumentTypes.func_218136_a("rotation", RotationArgument.class, new ArgumentSerializer<RotationArgument>(RotationArgument::func_197288_a));
        ArgumentTypes.func_218136_a("scoreboard_slot", ScoreboardSlotArgument.class, new ArgumentSerializer<ScoreboardSlotArgument>(ScoreboardSlotArgument::func_197219_a));
        ArgumentTypes.func_218136_a("score_holder", ScoreHolderArgument.class, new ScoreHolderArgument.Serializer());
        ArgumentTypes.func_218136_a("swizzle", SwizzleArgument.class, new ArgumentSerializer<SwizzleArgument>(SwizzleArgument::func_197293_a));
        ArgumentTypes.func_218136_a("team", TeamArgument.class, new ArgumentSerializer<TeamArgument>(TeamArgument::func_197227_a));
        ArgumentTypes.func_218136_a("item_slot", SlotArgument.class, new ArgumentSerializer<SlotArgument>(SlotArgument::func_197223_a));
        ArgumentTypes.func_218136_a("resource_location", ResourceLocationArgument.class, new ArgumentSerializer<ResourceLocationArgument>(ResourceLocationArgument::func_197197_a));
        ArgumentTypes.func_218136_a("mob_effect", PotionArgument.class, new ArgumentSerializer<PotionArgument>(PotionArgument::func_197126_a));
        ArgumentTypes.func_218136_a("function", FunctionArgument.class, new ArgumentSerializer<FunctionArgument>(FunctionArgument::func_200021_a));
        ArgumentTypes.func_218136_a("entity_anchor", EntityAnchorArgument.class, new ArgumentSerializer<EntityAnchorArgument>(EntityAnchorArgument::func_201024_a));
        ArgumentTypes.func_218136_a("int_range", IRangeArgument.IntRange.class, new IRangeArgument.IntRange.Serializer());
        ArgumentTypes.func_218136_a("float_range", IRangeArgument.FloatRange.class, new IRangeArgument.FloatRange.Serializer());
        ArgumentTypes.func_218136_a("item_enchantment", EnchantmentArgument.class, new ArgumentSerializer<EnchantmentArgument>(EnchantmentArgument::func_201945_a));
        ArgumentTypes.func_218136_a("entity_summon", EntitySummonArgument.class, new ArgumentSerializer<EntitySummonArgument>(EntitySummonArgument::func_211366_a));
        ArgumentTypes.func_218136_a("dimension", DimensionArgument.class, new ArgumentSerializer<DimensionArgument>(DimensionArgument::func_212595_a));
        ArgumentTypes.func_218136_a("time", TimeArgument.class, new ArgumentSerializer<TimeArgument>(TimeArgument::func_218091_a));
        if (SharedConstants.field_206244_b) {
            ArgumentTypes.func_218136_a("test_argument", TestArgArgument.class, new ArgumentSerializer<TestArgArgument>(TestArgArgument::func_229665_a_));
            ArgumentTypes.func_218136_a("test_class", TestTypeArgument.class, new ArgumentSerializer<TestTypeArgument>(TestTypeArgument::func_229611_a_));
        }
    }

    @Nullable
    private static Entry<?> func_197482_a(ResourceLocation resourceLocation) {
        return field_197490_c.get(resourceLocation);
    }

    @Nullable
    private static Entry<?> func_201040_a(ArgumentType<?> argumentType) {
        return field_197489_b.get(argumentType.getClass());
    }

    public static <T extends ArgumentType<?>> void func_197484_a(PacketBuffer packetBuffer, T t) {
        Entry<?> entry = ArgumentTypes.func_201040_a(t);
        if (entry == null) {
            field_197488_a.error("Could not serialize {} ({}) - will not be sent to client!", t, t.getClass());
            packetBuffer.func_192572_a(new ResourceLocation(""));
            return;
        }
        packetBuffer.func_192572_a(entry.field_197481_c);
        entry.field_197480_b.func_197072_a(t, packetBuffer);
    }

    @Nullable
    public static ArgumentType<?> func_197486_a(PacketBuffer packetBuffer) {
        ResourceLocation resourceLocation = packetBuffer.func_192575_l();
        Entry<?> \u26032 = ArgumentTypes.func_197482_a(resourceLocation);
        if (\u26032 == null) {
            field_197488_a.error("Could not deserialize {}", (Object)resourceLocation);
            return null;
        }
        return \u26032.field_197480_b.func_197071_b(packetBuffer);
    }

    private static <T extends ArgumentType<?>> void func_201042_a(JsonObject jsonObject, T t) {
        Entry<?> entry = ArgumentTypes.func_201040_a(t);
        if (entry == null) {
            field_197488_a.error("Could not serialize argument {} ({})!", t, t.getClass());
            jsonObject.addProperty("type", "unknown");
        } else {
            jsonObject.addProperty("type", "argument");
            jsonObject.addProperty("parser", entry.field_197481_c.toString());
            JsonObject jsonObject2 = new JsonObject();
            entry.field_197480_b.func_212244_a(t, jsonObject2);
            if (jsonObject2.size() > 0) {
                jsonObject.add("properties", (JsonElement)jsonObject2);
            }
        }
    }

    public static <S> JsonObject func_200388_a(CommandDispatcher<S> commandDispatcher, CommandNode<S> commandNode) {
        JsonObject jsonObject;
        JsonObject jsonObject2 = new JsonObject();
        if (commandNode instanceof RootCommandNode) {
            jsonObject2.addProperty("type", "root");
        } else if (commandNode instanceof LiteralCommandNode) {
            jsonObject2.addProperty("type", "literal");
        } else if (commandNode instanceof ArgumentCommandNode) {
            ArgumentTypes.func_201042_a(jsonObject2, ((ArgumentCommandNode)commandNode).getType());
        } else {
            field_197488_a.error("Could not serialize node {} ({})!", commandNode, commandNode.getClass());
            jsonObject2.addProperty("type", "unknown");
        }
        jsonObject = new JsonObject();
        for (CommandNode commandNode2 : commandNode.getChildren()) {
            jsonObject.add(commandNode2.getName(), (JsonElement)ArgumentTypes.func_200388_a(commandDispatcher, commandNode2));
        }
        if (jsonObject.size() > 0) {
            jsonObject2.add("children", (JsonElement)jsonObject);
        }
        if (commandNode.getCommand() != null) {
            jsonObject2.addProperty("executable", Boolean.valueOf(true));
        }
        if (commandNode.getRedirect() != null && !(\u2603 = commandDispatcher.getPath(commandNode.getRedirect())).isEmpty()) {
            CommandNode commandNode2;
            commandNode2 = new JsonArray();
            for (String string : \u2603) {
                commandNode2.add(string);
            }
            jsonObject2.add("redirect", (JsonElement)commandNode2);
        }
        return jsonObject2;
    }

    static class Entry<T extends ArgumentType<?>> {
        public final Class<T> field_197479_a;
        public final IArgumentSerializer<T> field_197480_b;
        public final ResourceLocation field_197481_c;

        private Entry(Class<T> clazz, IArgumentSerializer<T> iArgumentSerializer, ResourceLocation resourceLocation) {
            this.field_197479_a = clazz;
            this.field_197480_b = iArgumentSerializer;
            this.field_197481_c = resourceLocation;
        }
    }
}

