/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.block.BlockGraveMarble;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModPerks;

public class DeathHandler {
    public static final DeathHandler INSTANCE = new DeathHandler();
    public final String IS_PLAYER_DEAD_NBT_BOOL = "tb_is_player_dead";
    public final String PRESERVED_EFFECTS_NBT_LIST = "tb_preserved_effects";
    public final String LAST_DEATH_LOCATION_NBT_TAG = "tb_last_death_location";
    private final HashMap<UUID, Pair<GraveModel, BlockGraveMarble.MarbleType>> optionFavoriteGrave = new HashMap();
    private final HashMap<UUID, Boolean> optionEquipElytraInPriority = new HashMap();
    private final HashMap<UUID, Boolean> optionKnowledgeMessage = new HashMap();
    private final HashMap<UUID, Boolean> optionPriorizeToolOnHotbar = new HashMap();
    private final HashMap<UUID, Boolean> optionActivateGraveBySneaking = new HashMap();
    private final HashMap<String, Location> lastGraveList = new HashMap();

    private DeathHandler() {
    }

    public Location getLastGrave(String playerName) {
        return this.lastGraveList.getOrDefault(playerName, Location.ORIGIN);
    }

    public void removeGrave(Location pos) {
        Iterator<Map.Entry<String, Location>> it = this.lastGraveList.entrySet().iterator();
        while (it.hasNext()) {
            Location gravePos = it.next().getValue();
            if (!gravePos.equals(pos)) continue;
            it.remove();
        }
    }

    public void logLastGrave(@Nullable PlayerEntity player, int x, int y, int z, int dim) {
        if (player == null) {
            return;
        }
        this.lastGraveList.put(player.func_146103_bH().getName(), new Location(x, y, z, dim));
        if (((Boolean)ConfigTombstone.general.logPlayerGrave.get()).booleanValue()) {
            ModTombstone.LOGGER.info("A new grave of the player " + player.func_146103_bH().getName() + " was created at position [x:" + x + ", y:" + y + ", z:" + z + ", dim:" + dim + "]");
        }
    }

    public boolean isNoGraveLocation(Location location) {
        for (String s : (List)ConfigTombstone.general.noGraveLocation.get()) {
            String[] res;
            if (s.isEmpty() || !((res = s.split(",")).length == 5 ? new Location((int)Integer.valueOf(res[0].trim()), (int)Integer.valueOf(res[1].trim()), (int)Integer.valueOf(res[2].trim()), Integer.valueOf(res[3].trim())).isInRangeAndDimension(location, Integer.valueOf(res[4].trim())) : res.length == 1 && location.dim == Integer.valueOf(res[0].trim()))) continue;
            return true;
        }
        return false;
    }

    public void setLastDeathLocation(PlayerEntity player, Location location) {
        NBTStackHelper.setLocation(EntityHelper.getPersistentTag(player), "tb_last_death_location", location);
    }

    public Location getLastDeathLocation(PlayerEntity player) {
        return NBTStackHelper.getLocation(EntityHelper.getPersistentTag(player), "tb_last_death_location");
    }

    public void addPlayerDead(PlayerEntity player) {
        CompoundNBT persistentTag = EntityHelper.getPersistentTag(player);
        persistentTag.func_74757_a("tb_is_player_dead", true);
        this.setLastDeathLocation(player, new Location((Entity)player));
        if (((Boolean)ConfigTombstone.general.restoreEffectsOnDeath.get()).booleanValue() || EffectHelper.isPotionActive((LivingEntity)player, ModEffects.preservation)) {
            NBTStackHelper.setEffectlist(persistentTag, "tb_preserved_effects", player.func_70651_bq().stream().filter(EffectHelper::isAllowedEffect));
        }
        persistentTag.func_74768_a("tb_experience_total", EntityHelper.getPlayerTotalXp(player));
        persistentTag.func_74768_a("tb_experience_level", player.field_71068_ca);
        persistentTag.func_74776_a("tb_experience_bar", player.field_71106_cc);
    }

    public void restorePlayerDead(PlayerEntity player) {
        if (!this.isPlayerDead(player)) {
            return;
        }
        if (!Helper.isDisabledPerk(ModPerks.ghostly_shape, player)) {
            EffectHelper.addEffect((LivingEntity)player, ModEffects.ghostly_shape, (Integer)SharedConfigTombstone.general.ghostlyShapeDuration.get() * 20, EntityHelper.getPerkLevelWithBonus(player, ModPerks.ghostly_shape), new boolean[0]);
        }
        CompoundNBT persistentTag = EntityHelper.getPersistentTag(player);
        persistentTag.func_82580_o("tb_is_player_dead");
        List<EffectInstance> effectInstances = NBTStackHelper.getEffectList(persistentTag, "tb_preserved_effects", EffectHelper::isAllowedEffect);
        if (!effectInstances.isEmpty()) {
            effectInstances.forEach(effectInstance -> EffectHelper.addEffect((LivingEntity)player, effectInstance));
            persistentTag.func_82580_o("tb_preserved_effects");
        }
    }

    public boolean isPlayerDead(PlayerEntity player) {
        return EntityHelper.getPersistentTag(player).func_74767_n("tb_is_player_dead");
    }

    public DeathHandler setFavoriteGrave(UUID id, @Nullable GraveModel graveType, @Nullable BlockGraveMarble.MarbleType marbleType) {
        this.optionFavoriteGrave.put(id, (Pair<GraveModel, BlockGraveMarble.MarbleType>)Pair.of((Object)((Object)(graveType != null ? graveType : GraveModel.getDefault())), (Object)((Object)(marbleType != null ? marbleType : BlockGraveMarble.MarbleType.getDefault()))));
        return this;
    }

    public Pair<GraveModel, BlockGraveMarble.MarbleType> getFavoriteGrave(ServerPlayerEntity player) {
        return this.optionFavoriteGrave.getOrDefault(player.func_110124_au(), (Pair<GraveModel, BlockGraveMarble.MarbleType>)Pair.of((Object)((Object)GraveModel.getDefault()), (Object)((Object)BlockGraveMarble.MarbleType.getDefault())));
    }

    public DeathHandler setOptionEquipElytraInPriority(UUID id, boolean value) {
        this.optionEquipElytraInPriority.put(id, value);
        return this;
    }

    public boolean getOptionEquipElytraInPriority(UUID id) {
        return this.optionEquipElytraInPriority.getOrDefault(id, false);
    }

    public DeathHandler setOptionKnowledgeMessage(UUID id, boolean value) {
        this.optionKnowledgeMessage.put(id, value);
        return this;
    }

    public boolean getOptionKnowledgeMessage(UUID id) {
        return this.optionKnowledgeMessage.getOrDefault(id, true);
    }

    public DeathHandler setOptionPriorizeToolOnHotbar(UUID id, boolean value) {
        this.optionPriorizeToolOnHotbar.put(id, value);
        return this;
    }

    public boolean getOptionPriorizeToolOnHotbar(UUID id) {
        return this.optionPriorizeToolOnHotbar.getOrDefault(id, false);
    }

    public DeathHandler setOptionActivateGraveBySneaking(UUID id, boolean value) {
        this.optionActivateGraveBySneaking.put(id, value);
        return this;
    }

    public boolean getOptionActivateGraveBySneaking(UUID id) {
        return this.optionActivateGraveBySneaking.getOrDefault(id, false);
    }

    public void clear() {
        this.optionFavoriteGrave.clear();
        this.optionEquipElytraInPriority.clear();
        this.optionKnowledgeMessage.clear();
        this.optionPriorizeToolOnHotbar.clear();
        this.optionActivateGraveBySneaking.clear();
        this.lastGraveList.clear();
        CooldownHandler.INSTANCE.clear();
    }
}

