/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.OptionSlider;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.SliderPercentageOption;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.ForgeConfigSpec;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.block.BlockGraveMarble;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.gui.BooleanConfigOption;
import ovh.corail.tombstone.gui.ColorButtonHandler;
import ovh.corail.tombstone.gui.IntegerConfigOption;
import ovh.corail.tombstone.gui.TBGuiButton;
import ovh.corail.tombstone.gui.TBScreen;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.registry.ModBlocks;

public class GuiConfig
extends TBScreen {
    private static final ResourceLocation tablet = new ResourceLocation("tombstone", "textures/block/grave_plate.png");
    private TabConfig tab = TabConfig.GRAVE;
    private Widget buttonGraveTexture;
    private Widget buttonLeftArrow;
    private Widget buttonRightArrow;
    private GraveModel graveModel;
    private BlockGraveMarble.MarbleType marbleType;
    private ColorButtonHandler colorButtonHandler1;
    private ColorButtonHandler colorButtonHandler2;
    private ColorButtonHandler colorButtonHandler3;
    private boolean enhanced_tooltips;
    private boolean highlightGrave;
    private boolean skipRespawnScreen;
    private boolean showShadowStep;
    private boolean enableHalloweenEffect;
    private boolean dateInMCTime;
    private boolean displayKnowledgeMessage;
    private boolean equipElytraInPriority;
    private boolean showInfoOnEnchantment;
    private boolean showMagicCircle;
    private boolean priorizeToolOnHotbar;
    private boolean activateGraveBySneaking;
    private List<Widget> misc1Buttons = new ArrayList<Widget>();
    private ConfigTombstone.Client.GraveSkinRule graveSkinRule;
    private ConfigTombstone.Client.FogDensity fogDensity;
    private ConfigTombstone.Client.FogPeriod fogPeriod;
    private ColorButtonHandler colorButtonHandler0;
    private ColorButtonHandler colorButtonHandler4;
    private List<Widget> misc2Buttons = new ArrayList<Widget>();

    public GuiConfig() {
        super((ITextComponent)new StringTextComponent("Tombstone Config"));
    }

    public GuiConfig(Minecraft minecraft, Screen screen) {
        this();
    }

    @Override
    public void init() {
        super.init();
        this.buttons.clear();
        int posY = 0;
        for (TabConfig currentTab : TabConfig.values()) {
            this.addButton((Widget)new TBGuiButton(this.guiLeft - 50, this.guiTop + posY, 40, 20, currentTab.name(), pressable -> {
                this.tab = currentTab;
                this.updateButtons();
            }));
            posY += 20;
        }
        this.addButton((Widget)new TBGuiButton(this.guiLeft - 50, this.guiTop + posY, 40, 20, "SAVE", pressable -> this.saveConfig()));
        this.enhanced_tooltips = (Boolean)ConfigTombstone.client.showEnhancedTooltips.get();
        this.skipRespawnScreen = (Boolean)ConfigTombstone.client.skipRespawnScreen.get();
        this.dateInMCTime = (Boolean)ConfigTombstone.client.dateInMCTime.get();
        this.displayKnowledgeMessage = (Boolean)ConfigTombstone.client.displayKnowledgeMessage.get();
        this.equipElytraInPriority = (Boolean)ConfigTombstone.client.equipElytraInPriority.get();
        this.showInfoOnEnchantment = (Boolean)ConfigTombstone.client.showInfoOnEnchantment.get();
        this.graveSkinRule = (ConfigTombstone.Client.GraveSkinRule)((Object)ConfigTombstone.client.graveSkinRule.get());
        this.fogDensity = (ConfigTombstone.Client.FogDensity)((Object)ConfigTombstone.client.fogDensity.get());
        this.priorizeToolOnHotbar = (Boolean)ConfigTombstone.client.priorizeToolOnHotbar.get();
        this.activateGraveBySneaking = (Boolean)ConfigTombstone.client.activateGraveBySneaking.get();
        this.misc1Buttons.clear();
        this.misc1Buttons.add(new BooleanConfigOption("Enhanced Tooltips", () -> this.enhanced_tooltips, b -> {
            this.enhanced_tooltips = b;
        }).func_216586_a(this.getMinecraft().field_71474_y, this.guiLeft + 3, this.guiTop + 36, 190));
        this.misc1Buttons.add(new BooleanConfigOption("Skip Respawn Screen", () -> this.skipRespawnScreen, b -> {
            this.skipRespawnScreen = b;
        }).func_216586_a(this.getMinecraft().field_71474_y, this.guiLeft + 3, this.guiTop + 50, 190));
        this.misc1Buttons.add(new BooleanConfigOption("Date in MC Time", () -> this.dateInMCTime, b -> {
            this.dateInMCTime = b;
        }).func_216586_a(this.getMinecraft().field_71474_y, this.guiLeft + 3, this.guiTop + 64, 190));
        this.misc1Buttons.add(new BooleanConfigOption("Display Knowledge Message", () -> this.displayKnowledgeMessage, b -> {
            this.displayKnowledgeMessage = b;
        }).func_216586_a(this.getMinecraft().field_71474_y, this.guiLeft + 3, this.guiTop + 78, 190));
        this.misc1Buttons.add(new BooleanConfigOption("Equip Elytra in Priority", () -> this.equipElytraInPriority, b -> {
            this.equipElytraInPriority = b;
        }).func_216586_a(this.getMinecraft().field_71474_y, this.guiLeft + 3, this.guiTop + 92, 190));
        this.misc1Buttons.add(new BooleanConfigOption("Show Info on Enchantment", () -> this.showInfoOnEnchantment, b -> {
            this.showInfoOnEnchantment = b;
        }).func_216586_a(this.getMinecraft().field_71474_y, this.guiLeft + 3, this.guiTop + 106, 190));
        this.misc1Buttons.add(new IntegerConfigOption("Grave Skin", () -> this.graveSkinRule.ordinal(), b -> {
            this.graveSkinRule = ConfigTombstone.Client.GraveSkinRule.values()[b];
        }, ConfigTombstone.Client.GraveSkinRule.values().length - 1){

            @Override
            protected String getOptionName() {
                return this.func_216617_a() + ConfigTombstone.Client.GraveSkinRule.values()[this.get()].name();
            }
        }.func_216586_a(this.getMinecraft().field_71474_y, this.guiLeft + 3, this.guiTop + 120, 190));
        this.misc1Buttons.add(new IntegerConfigOption("Fog Density", () -> this.fogDensity.ordinal(), b -> {
            this.fogDensity = ConfigTombstone.Client.FogDensity.values()[b];
        }, ConfigTombstone.Client.FogDensity.values().length - 1){

            @Override
            protected String getOptionName() {
                return this.func_216617_a() + ConfigTombstone.Client.FogDensity.values()[this.get()].name();
            }
        }.func_216586_a(this.getMinecraft().field_71474_y, this.guiLeft + 3, this.guiTop + 134, 190));
        this.misc1Buttons.add(new BooleanConfigOption("Favor Tools On Hotbar", () -> this.priorizeToolOnHotbar, b -> {
            this.priorizeToolOnHotbar = b;
        }).func_216586_a(this.getMinecraft().field_71474_y, this.guiLeft + 3, this.guiTop + 148, 190));
        this.misc1Buttons.add(new BooleanConfigOption("Activate Grave By Sneaking", () -> this.activateGraveBySneaking, b -> {
            this.activateGraveBySneaking = b;
        }).func_216586_a(this.getMinecraft().field_71474_y, this.guiLeft + 3, this.guiTop + 162, 190));
        for (Widget w : this.misc1Buttons) {
            this.addButton(w);
        }
        this.highlightGrave = (Boolean)ConfigTombstone.client.highlight.get();
        this.showShadowStep = (Boolean)ConfigTombstone.client.showShadowStep.get();
        this.enableHalloweenEffect = (Boolean)ConfigTombstone.client.enableHalloweenEffect.get();
        this.showMagicCircle = (Boolean)ConfigTombstone.client.showMagicCircle.get();
        this.fogPeriod = (ConfigTombstone.Client.FogPeriod)ConfigTombstone.client.fogPeriod.get();
        this.misc2Buttons.clear();
        this.misc2Buttons.add(new BooleanConfigOption("Highlight Grave", () -> this.highlightGrave, b -> {
            this.highlightGrave = b;
        }).func_216586_a(this.getMinecraft().field_71474_y, this.guiLeft + 3, this.guiTop + 36, 190));
        this.misc2Buttons.add(new BooleanConfigOption("Show ShadowStep", () -> this.showShadowStep, b -> {
            this.showShadowStep = b;
        }).func_216586_a(this.getMinecraft().field_71474_y, this.guiLeft + 3, this.guiTop + 50, 190));
        this.misc2Buttons.add(new BooleanConfigOption("Enable Halloween Effect", () -> this.enableHalloweenEffect, b -> {
            this.enableHalloweenEffect = b;
        }).func_216586_a(this.getMinecraft().field_71474_y, this.guiLeft + 3, this.guiTop + 64, 190));
        this.misc2Buttons.add(new BooleanConfigOption("Shows Magic circles", () -> this.showMagicCircle, b -> {
            this.showMagicCircle = b;
        }).func_216586_a(this.getMinecraft().field_71474_y, this.guiLeft + 3, this.guiTop + 78, 190));
        this.misc2Buttons.add(new IntegerConfigOption("Fog Period", () -> this.fogPeriod.ordinal(), b -> {
            this.fogPeriod = ConfigTombstone.Client.FogPeriod.values()[b];
        }, ConfigTombstone.Client.FogPeriod.values().length - 1){

            @Override
            protected String getOptionName() {
                return this.func_216617_a() + ConfigTombstone.Client.FogPeriod.values()[this.get()].name();
            }
        }.func_216586_a(this.getMinecraft().field_71474_y, this.guiLeft + 3, this.guiTop + 92, 190));
        for (Widget w : this.misc2Buttons) {
            this.addButton(w);
        }
        Integer color = (Integer)ConfigTombstone.client.particleCastingColor.get();
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b2 = color & 0xFF;
        this.colorButtonHandler0 = new ColorButtonHandler(this.getMinecraft().field_71474_y, this.buttons, this.children, this.guiLeft + 100, this.guiTop + 111, 80, 4, r, g, b2, "particleCastingColor");
        color = (Integer)ConfigTombstone.client.fogColor.get();
        r = color >> 16 & 0xFF;
        g = color >> 8 & 0xFF;
        b2 = color & 0xFF;
        this.colorButtonHandler4 = new ColorButtonHandler(this.getMinecraft().field_71474_y, this.buttons, this.children, this.guiLeft + 100, this.guiTop + 136, 80, 4, r, g, b2, "fogColor");
        this.graveModel = (GraveModel)((Object)ConfigTombstone.client.favoriteGrave.get());
        this.marbleType = (BlockGraveMarble.MarbleType)((Object)ConfigTombstone.client.favoriteGraveMarble.get());
        this.buttonGraveTexture = new OptionSlider(this.getMinecraft().field_71474_y, this.guiRight - 10 - 30, this.guiTop + 40, 30, 20, new SliderPercentageOption("texture", 0.0, 1.0, 1.0f, settings -> this.marbleType.ordinal(), (settings, d) -> {
            this.marbleType = BlockGraveMarble.MarbleType.byId(d.intValue());
        }, (settings, d) -> this.marbleType.func_176610_l()));
        this.addButton(this.buttonGraveTexture);
        this.buttonLeftArrow = new TBGuiButton(this.guiLeft + 10, this.guiBottom - 25, 40, 15, "<-", pressable -> {
            do {
                this.graveModel = this.graveModel.getPrevious();
            } while (this.graveModel.isOnlyContributor() && !Helper.isContributor);
        });
        this.addButton(this.buttonLeftArrow);
        this.buttonRightArrow = new TBGuiButton(this.guiRight - 10 - 40, this.guiBottom - 25, 40, 15, "->", pressable -> {
            do {
                this.graveModel = this.graveModel.getNext();
            } while (this.graveModel.isOnlyContributor() && !Helper.isContributor);
        });
        this.addButton(this.buttonRightArrow);
        color = (Integer)ConfigTombstone.client.textColorRIP.get();
        r = color >> 16 & 0xFF;
        g = color >> 8 & 0xFF;
        b2 = color & 0xFF;
        this.colorButtonHandler1 = new ColorButtonHandler(this.getMinecraft().field_71474_y, this.buttons, this.children, this.guiLeft + 6, this.guiTop + 57, 40, 4, r, g, b2, "ripText");
        color = (Integer)ConfigTombstone.client.textColorOwner.get();
        r = color >> 16 & 0xFF;
        g = color >> 8 & 0xFF;
        b2 = color & 0xFF;
        this.colorButtonHandler2 = new ColorButtonHandler(this.getMinecraft().field_71474_y, this.buttons, this.children, this.guiLeft + 6, this.guiTop + 87, 40, 4, r, g, b2, "deathDateText");
        color = (Integer)ConfigTombstone.client.textColorDeathDate.get();
        r = color >> 16 & 0xFF;
        g = color >> 8 & 0xFF;
        b2 = color & 0xFF;
        this.colorButtonHandler3 = new ColorButtonHandler(this.getMinecraft().field_71474_y, this.buttons, this.children, this.guiLeft + 6, this.guiTop + 121, 40, 4, r, g, b2, "diedOnText");
        this.updateButtons();
    }

    private <T> boolean updateConfig(ForgeConfigSpec.ConfigValue<T> config, T newValue) {
        if (config.get() != newValue) {
            config.set(newValue);
            return true;
        }
        return false;
    }

    private void saveConfig() {
        boolean isModified = this.updateConfig(ConfigTombstone.client.favoriteGrave, this.graveModel);
        isModified = this.updateConfig(ConfigTombstone.client.favoriteGraveMarble, this.marbleType) || isModified;
        isModified = this.updateConfig(ConfigTombstone.client.displayKnowledgeMessage, this.displayKnowledgeMessage) || isModified;
        isModified = this.updateConfig(ConfigTombstone.client.equipElytraInPriority, this.equipElytraInPriority) || isModified;
        isModified = this.updateConfig(ConfigTombstone.client.priorizeToolOnHotbar, this.priorizeToolOnHotbar) || isModified;
        boolean requirePacket = isModified = this.updateConfig(ConfigTombstone.client.activateGraveBySneaking, this.activateGraveBySneaking) || isModified;
        isModified = this.updateConfig(ConfigTombstone.client.textColorRIP, this.colorButtonHandler1.getColor()) || isModified;
        isModified = this.updateConfig(ConfigTombstone.client.textColorOwner, this.colorButtonHandler2.getColor()) || isModified;
        isModified = this.updateConfig(ConfigTombstone.client.textColorDeathDate, this.colorButtonHandler3.getColor()) || isModified;
        isModified = this.updateConfig(ConfigTombstone.client.showEnhancedTooltips, this.enhanced_tooltips) || isModified;
        isModified = this.updateConfig(ConfigTombstone.client.highlight, this.highlightGrave) || isModified;
        isModified = this.updateConfig(ConfigTombstone.client.skipRespawnScreen, this.skipRespawnScreen) || isModified;
        isModified = this.updateConfig(ConfigTombstone.client.showShadowStep, this.showShadowStep) || isModified;
        isModified = this.updateConfig(ConfigTombstone.client.enableHalloweenEffect, this.enableHalloweenEffect) || isModified;
        isModified = this.updateConfig(ConfigTombstone.client.dateInMCTime, this.dateInMCTime) || isModified;
        isModified = this.updateConfig(ConfigTombstone.client.showInfoOnEnchantment, this.showInfoOnEnchantment) || isModified;
        isModified = this.updateConfig(ConfigTombstone.client.graveSkinRule, this.graveSkinRule) || isModified;
        isModified = this.updateConfig(ConfigTombstone.client.fogDensity, this.fogDensity) || isModified;
        isModified = this.updateConfig(ConfigTombstone.client.showMagicCircle, this.showMagicCircle) || isModified;
        isModified = this.updateConfig(ConfigTombstone.client.particleCastingColor, this.colorButtonHandler0.getColor()) || isModified;
        isModified = this.updateConfig(ConfigTombstone.client.fogColor, this.colorButtonHandler4.getColor()) || isModified;
        boolean bl = isModified = this.updateConfig(ConfigTombstone.client.fogPeriod, this.fogPeriod) || isModified;
        if (isModified) {
            ConfigTombstone.CLIENT_SPEC.save();
        }
        if (requirePacket) {
            ModTombstone.PROXY.markConfigDirty();
        }
        this.onClose();
    }

    private void updateButtons() {
        switch (this.tab) {
            case GRAVE: {
                this.enableGraveButtons();
                this.disableColorButtons();
                this.disableMiscButtons();
                this.disableEffectButtons();
                break;
            }
            case PLATE: {
                this.enableColorButtons();
                this.disableGraveButtons();
                this.disableMiscButtons();
                this.disableEffectButtons();
                break;
            }
            case MISC: {
                this.enableMiscButtons();
                this.disableGraveButtons();
                this.disableColorButtons();
                this.disableEffectButtons();
                break;
            }
            case EFFECT: {
                this.disableColorButtons();
                this.enableEffectButtons();
                this.disableGraveButtons();
                this.disableMiscButtons();
            }
        }
    }

    private void enableGraveButtons() {
        this.buttonGraveTexture.active = true;
        this.buttonGraveTexture.visible = true;
        this.buttonLeftArrow.active = true;
        this.buttonLeftArrow.visible = true;
        this.buttonRightArrow.active = true;
        this.buttonRightArrow.visible = true;
    }

    private void disableGraveButtons() {
        this.buttonGraveTexture.active = false;
        this.buttonGraveTexture.visible = false;
        this.buttonLeftArrow.active = false;
        this.buttonLeftArrow.visible = false;
        this.buttonRightArrow.active = false;
        this.buttonRightArrow.visible = false;
    }

    private void enableColorButtons() {
        this.colorButtonHandler1.enableButtons();
        this.colorButtonHandler2.enableButtons();
        this.colorButtonHandler3.enableButtons();
        this.colorButtonHandler4.enableButtons();
    }

    private void disableColorButtons() {
        this.colorButtonHandler1.disableButtons();
        this.colorButtonHandler2.disableButtons();
        this.colorButtonHandler3.disableButtons();
        this.colorButtonHandler4.disableButtons();
    }

    private void enableMiscButtons() {
        for (Widget widget : this.misc1Buttons) {
            if (widget == null) continue;
            widget.active = true;
            widget.visible = true;
        }
    }

    private void disableMiscButtons() {
        for (Widget widget : this.misc1Buttons) {
            if (widget == null) continue;
            widget.active = false;
            widget.visible = false;
        }
    }

    private void enableEffectButtons() {
        for (Widget widget : this.misc2Buttons) {
            if (widget == null) continue;
            widget.active = true;
            widget.visible = true;
        }
        this.colorButtonHandler0.enableButtons();
        this.colorButtonHandler4.enableButtons();
    }

    private void disableEffectButtons() {
        for (Widget widget : this.misc2Buttons) {
            if (widget == null) continue;
            widget.active = false;
            widget.visible = false;
        }
        this.colorButtonHandler0.disableButtons();
        this.colorButtonHandler4.disableButtons();
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        String customTitle = this.title.func_150254_d();
        this.font.getClass();
        GuiConfig.fill((int)(this.guiLeft + 5), (int)(this.guiTop + 5), (int)(this.guiRight - 5), (int)(this.guiTop + 20 + 9), (int)0x55000000);
        int n = this.halfWidth - this.font.func_78256_a(customTitle) / 2;
        ((Object)((Object)this)).getClass();
        this.drawString(this.font, customTitle, n, this.guiTop + 14, -1);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        String playerName = this.getMinecraft().field_71439_g != null ? this.getMinecraft().field_71439_g.func_200200_C_().func_150254_d() : "Corail31";
        switch (this.tab) {
            case GRAVE: {
                ItemStack stack = new ItemStack((IItemProvider)ModBlocks.decorative_graves.get((Object)this.graveModel));
                String graveName = stack.func_200301_q().func_150254_d();
                ItemBlockGrave.setModelTexture(stack, this.marbleType.ordinal());
                ItemBlockGrave.setEngravedName(stack, playerName);
                String graveString = I18n.func_135052_a((String)graveName, (Object[])new Object[0]);
                int n2 = this.halfWidth - this.font.func_78256_a(graveString) / 2;
                ((Object)((Object)this)).getClass();
                this.drawString(this.font, graveString, n2, this.guiBottom - 55, -1);
                GuiConfig.fill((int)(this.guiLeft + 5), (int)(this.guiTop + 35), (int)(this.guiRight - 5), (int)(this.guiBottom - 42), (int)0x50000000);
                this.renderStackInGui(stack, this.guiLeft + 40, this.guiTop + 32, 6.0, true);
                break;
            }
            case PLATE: {
                this.getMinecraft().field_71446_o.func_110577_a(tablet);
                GuiConfig.blit((int)(this.guiLeft + 46), (int)(this.guiTop + 36), (float)0.0f, (float)0.0f, (int)154, (int)154, (int)154, (int)154);
                int adjustText = 24;
                String ripString = TextFormatting.BOLD + "R.I.P.";
                this.drawString(this.font, ripString, this.halfWidth - this.font.func_78256_a(ripString) / 2 + adjustText, this.guiTop + 60, this.colorButtonHandler1.getColor());
                String ownerString = TextFormatting.BOLD + playerName;
                this.drawString(this.font, ownerString, this.halfWidth - this.font.func_78256_a(ownerString) / 2 + adjustText, this.guiTop + 90, this.colorButtonHandler2.getColor());
                String diedOnString = TextFormatting.ITALIC.toString() + "Hasn't died yet";
                this.drawString(this.font, diedOnString, this.halfWidth - this.font.func_78256_a(diedOnString) / 2 + adjustText, this.guiTop + 120, this.colorButtonHandler3.getColor());
                String soonString = TextFormatting.ITALIC.toString() + "but will soon";
                this.drawString(this.font, soonString, this.halfWidth - this.font.func_78256_a(soonString) / 2 + adjustText, this.guiTop + 130, this.colorButtonHandler3.getColor());
                break;
            }
            case MISC: {
                GuiConfig.fill((int)(this.guiLeft + 5), (int)(this.guiTop + 35), (int)(this.guiLeft + this.xSize - 5), (int)(this.guiTop + 194), (int)0x55000000);
                break;
            }
            case EFFECT: {
                GuiConfig.fill((int)(this.guiLeft + 5), (int)(this.guiTop + 35), (int)(this.guiLeft + this.xSize - 5), (int)(this.guiTop + 194), (int)0x55000000);
                this.drawString(this.font, "Particle Color", this.guiLeft + 20, this.guiTop + 115, this.colorButtonHandler0.getColor());
                this.drawString(this.font, "Fog Color", this.guiLeft + 20, this.guiTop + 140, this.colorButtonHandler4.getColor());
            }
        }
        super.render(mouseX, mouseY, partialTicks);
    }

    private void renderStackInGui(ItemStack stack, int xPosition, int yPosition, double scale, boolean isSpinning) {
        boolean flag;
        RenderSystem.pushMatrix();
        this.getMinecraft().field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
        this.getMinecraft().field_71446_o.func_229267_b_(AtlasTexture.field_110575_b).func_174937_a(false, false);
        RenderSystem.enableRescaleNormal();
        RenderSystem.scaled((double)scale, (double)scale, (double)scale);
        RenderSystem.enableAlphaTest();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.translatef((float)((float)((double)xPosition / scale)), (float)((float)((double)yPosition / scale)), (float)(100.0f + this.itemRenderer.field_77023_b));
        RenderSystem.translatef((float)8.0f, (float)8.0f, (float)0.0f);
        RenderSystem.scalef((float)16.0f, (float)-16.0f, (float)16.0f);
        MatrixStack matrixStack = new MatrixStack();
        IRenderTypeBuffer.Impl irendertypebuffer$impl = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        Item item = stack.func_77973_b();
        IBakedModel bakedModel = this.itemRenderer.func_184393_a(stack, null, null);
        boolean bl = flag = !bakedModel.func_177556_c();
        if (flag) {
            RenderHelper.func_227783_c_();
        }
        if (isSpinning) {
            // empty if block
        }
        this.itemRenderer.func_229111_a_(stack, ItemCameraTransforms.TransformType.GUI, false, matrixStack, (IRenderTypeBuffer)irendertypebuffer$impl, 0xF000F0, OverlayTexture.field_229196_a_, bakedModel);
        irendertypebuffer$impl.func_228461_a_();
        RenderSystem.enableDepthTest();
        if (flag) {
            RenderHelper.func_227784_d_();
        }
        RenderSystem.disableAlphaTest();
        RenderSystem.disableRescaleNormal();
        double scaleRev = 1.0 / scale;
        RenderSystem.scaled((double)scaleRev, (double)scaleRev, (double)scaleRev);
        RenderSystem.popMatrix();
    }

    static enum TabConfig {
        GRAVE,
        PLATE,
        MISC,
        EFFECT;

    }
}

