/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.config;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.block.BlockGraveMarble;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.helper.Helper;

public class ConfigTombstone {
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client client;
    public static final General general;
    public static final VillageSiege village_siege;
    public static final DecorativeGrave decorative_grave;
    public static final Enchantments enchantments;
    public static final Recovery recovery;
    public static final Loot loot;
    public static final Compatibility compatibility;
    public static final ForgeConfigSpec GENERAL_SPEC;

    private static String getTranslation(String name) {
        return "tombstone.config." + name;
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        client = (Client)specPair.getLeft();
        ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
        general = new General(BUILDER);
        village_siege = new VillageSiege(BUILDER);
        decorative_grave = new DecorativeGrave(BUILDER);
        enchantments = new Enchantments(BUILDER);
        recovery = new Recovery(BUILDER);
        loot = new Loot(BUILDER);
        compatibility = new Compatibility(BUILDER);
        GENERAL_SPEC = BUILDER.build();
    }

    @Mod.EventBusSubscriber(modid="tombstone", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ConfigEvent {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void onReloadConfig(ModConfig.Reloading event) {
            if (event.getConfig().getModId().equals("tombstone") && (event.getConfig().getType() == ModConfig.Type.CLIENT || event.getConfig().getType() == ModConfig.Type.SERVER)) {
                ModTombstone.PROXY.markConfigDirty();
            }
        }
    }

    public static class Compatibility {
        public final ForgeConfigSpec.ConfigValue<Boolean> allowCurioAutoEquip;
        public final ForgeConfigSpec.ConfigValue<Boolean> keepCosmeticArmor;
        public final ForgeConfigSpec.ConfigValue<Boolean> disableDisenchantmentForTetra;

        public Compatibility(ForgeConfigSpec.Builder builder) {
            builder.comment("Allows to enable some features related to others mods").push("compatibility");
            this.allowCurioAutoEquip = builder.comment("Allows to auto-equip the slots from Curio mod [false/true|default:true]").translation(ConfigTombstone.getTranslation("allow_curio_auto_equip")).define("allow_curio_auto_equip", true);
            this.keepCosmeticArmor = builder.comment("Keeps the cosmetic armor when you die [false/true|default:true]").translation(ConfigTombstone.getTranslation("keep_cosmetic_armor")).define("keep_cosmetic_armor", true);
            this.disableDisenchantmentForTetra = builder.comment("Disables to disenchant items from tetra mod [false/true|default:false]").translation(ConfigTombstone.getTranslation("disable_disenchantment_for_tetra")).define("disable_disenchantment_for_tetra", false);
            builder.pop();
        }
    }

    public static class VillageSiege {
        public final ForgeConfigSpec.ConfigValue<Boolean> handleVillageSiege;
        public final ForgeConfigSpec.ConfigValue<Boolean> logSiegeState;
        public final ForgeConfigSpec.ConfigValue<Boolean> glowingCreatureTest;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowCreativePlayersForSiege;
        public final ForgeConfigSpec.ConfigValue<Integer> siegeChance;
        public final ForgeConfigSpec.ConfigValue<Integer> siegeMaxCreature;
        public final ForgeConfigSpec.ConfigValue<Boolean> undeadWearHelmInSiege;
        public final ForgeConfigSpec.ConfigValue<Integer> delaySiegeTest;
        public final ForgeConfigSpec.ConfigValue<Boolean> persistentMobInSiege;
        public final ForgeConfigSpec.ConfigValue<Boolean> shufflePlayersForSiege;

        public VillageSiege(ForgeConfigSpec.Builder builder) {
            builder.comment("Allows to define the conditions for a village siege to begin").push("village_siege");
            this.handleVillageSiege = builder.comment("Allows to handle village sieges [false/true|default:true]").translation(ConfigTombstone.getTranslation("handle_village_siege")).define("handle_village_siege", true);
            this.logSiegeState = builder.comment("Logs the different states of a village siege while searching for an adequate place [false/true|default:false]").translation(ConfigTombstone.getTranslation("log_siege_state")).define("log_siege_state", false);
            this.glowingCreatureTest = builder.comment("The creatures of the siege have a glowing effect (only uses this for test purposes) [false/true|default:false]").translation(ConfigTombstone.getTranslation("glowing_creature_test")).define("glowing_creature_test", false);
            this.allowCreativePlayersForSiege = builder.comment("Allows to use the positions of creative players to define the siege location [false/true|default:true]").translation(ConfigTombstone.getTranslation("allow_creative_players_for_siege")).define("allow_creative_players_for_siege", true);
            this.siegeChance = builder.comment("Chance for a siege to occur [0..100|default:10]").translation(ConfigTombstone.getTranslation("siege_chance")).defineInRange("siege_chance", 10, 0, 100);
            this.siegeMaxCreature = builder.comment("Maximum of creatures appearing in a siege [0..100|default:20]").translation(ConfigTombstone.getTranslation("siege_max_creature")).defineInRange("siege_max_creature", 20, 0, 100);
            this.undeadWearHelmInSiege = builder.comment("Undeads always wear a helm when sieging [false/true|default:false]").translation(ConfigTombstone.getTranslation("undead_wear_helm_in_siege")).define("undead_wear_helm_in_siege", false);
            this.delaySiegeTest = builder.comment("Delay in seconds for a second test of siege when the first failed [0..2400|default:600]").translation(ConfigTombstone.getTranslation("delay_siege_test")).defineInRange("delay_siege_test", 600, 0, 2400);
            this.persistentMobInSiege = builder.comment("Mobs in siege are persistent [false/true|default:false]").translation(ConfigTombstone.getTranslation("persistent_mob_in_siege")).define("persistent_mob_in_siege", false);
            this.shufflePlayersForSiege = builder.comment("Shuffles the list of players before testing the siege location [false/true|default:true]").translation(ConfigTombstone.getTranslation("shuffle_players_for_siege")).define("shuffle_players_for_siege", true);
            builder.pop();
        }
    }

    public static class Recovery {
        public final ForgeConfigSpec.ConfigValue<Boolean> recoveryPlayerEnable;
        public final ForgeConfigSpec.ConfigValue<Integer> recoveryPlayerTimer;
        public final ForgeConfigSpec.ConfigValue<Integer> recoveryPlayerMaxSaves;
        public final ForgeConfigSpec.ConfigValue<Boolean> recoveryFamiliarEnable;
        public final ForgeConfigSpec.ConfigValue<Boolean> backupOnDeath;

        public Recovery(ForgeConfigSpec.Builder builder) {
            builder.comment("Options related to the command recovery and auto-save of players").push("recovery");
            this.recoveryPlayerEnable = builder.comment("Enables to backup automatically players [false/true|default:true]").translation(ConfigTombstone.getTranslation("recovery_player_enable")).define("recovery_player_enable", true);
            this.recoveryPlayerTimer = builder.comment("Time in minutes between players' backups [10..1000|default:40]").translation(ConfigTombstone.getTranslation("recovery_player_timer")).defineInRange("recovery_player_timer", 20, 5, 1000);
            this.recoveryPlayerMaxSaves = builder.comment("Maximum number of backups per player [5..100|default:15]").translation(ConfigTombstone.getTranslation("recovery_player_max_saves")).defineInRange("recovery_player_max_saves", 15, 5, 100);
            this.recoveryFamiliarEnable = builder.comment("Enables to backup automatically dead familiars [false/true|default:true]").translation(ConfigTombstone.getTranslation("recovery_familiar_enable")).define("recovery_familiar_enable", true);
            this.backupOnDeath = builder.comment("Backup players on death [false/true|default:false]").translation(ConfigTombstone.getTranslation("backup_on_death")).define("backup_on_death", false);
            builder.pop();
        }
    }

    public static class Loot {
        public final ForgeConfigSpec.ConfigValue<Integer> chanceDecorativeGraveOnBoss;
        public final ForgeConfigSpec.ConfigValue<Integer> chanceRandomPoppetOnBoss;
        public final ForgeConfigSpec.ConfigValue<Integer> chanceRandomScrollOnBoss;
        public final ForgeConfigSpec.ConfigValue<Boolean> undeadCanDropSkull;
        public final ForgeConfigSpec.ConfigValue<Integer> chanceSoulReceptacleOnBoss;
        public final ForgeConfigSpec.ConfigValue<Integer> chanceGraveDust;
        public final ForgeConfigSpec.ConfigValue<List<String>> treasureLootTable;

        public Loot(ForgeConfigSpec.Builder builder) {
            builder.comment("Allows to change the chance to drop some items").push("loot");
            this.chanceDecorativeGraveOnBoss = builder.comment("Chance on 1000 to receive a decorative grave on undead boss [0..1000|default:50]").translation(ConfigTombstone.getTranslation("chance_decorative_grave_on_boss")).defineInRange("chance_decorative_grave_on_boss", 30, 0, 1000);
            this.chanceRandomPoppetOnBoss = builder.comment("Chance on 1000 to receive a random poppet on undead boss [0..1000|default:100]").translation(ConfigTombstone.getTranslation("chance_random_poppet_on_boss")).defineInRange("chance_random_poppet_on_boss", 100, 0, 1000);
            this.chanceRandomScrollOnBoss = builder.comment("Chance on 1000 to receive a random scroll on undead boss [0..1000|default:100]").translation(ConfigTombstone.getTranslation("chance_random_scroll_on_boss")).defineInRange("chance_random_scroll_on_boss", 100, 0, 1000);
            this.undeadCanDropSkull = builder.comment("Allows the undeads to have a low chance to drop their skull [false/true|default:true]").translation(ConfigTombstone.getTranslation("undead_can_drop_skull")).define("undead_can_drop_skull", true);
            this.chanceSoulReceptacleOnBoss = builder.comment("Chance on 1000 to receive a Soul Receptacle on undead boss [0..1000|default:50]").translation(ConfigTombstone.getTranslation("chance_soul_receptacle_on_boss")).defineInRange("chance_soul_receptacle_on_boss", 50, 0, 1000);
            this.chanceGraveDust = builder.comment("Chance on 1000 for undead mobs to drop Grave's Dust [0..1000|default:100]").translation(ConfigTombstone.getTranslation("chance_grave_dust")).defineInRange("chance_grave_dust", 100, 0, 1000);
            this.treasureLootTable = builder.comment("Defines the allowed loottables having a chance to contain a magic item from Tombstone").translation(ConfigTombstone.getTranslation("treasure_loot_table")).define("treasure_loot_table", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:chests/end_city_treasure", "minecraft:chests/abandoned_mineshaft", "minecraft:chests/nether_bridge", "minecraft:chests/stronghold_library", "minecraft:chests/desert_pyramid", "minecraft:chests/jungle_temple", "minecraft:chests/igloo_chest", "minecraft:chests/woodland_mansion"}));
            builder.pop();
        }
    }

    public static class Client {
        public final ForgeConfigSpec.ConfigValue<FogDensity> fogDensity;
        public final ForgeConfigSpec.ConfigValue<Integer> particleCastingColor;
        public final ForgeConfigSpec.ConfigValue<Boolean> showMagicCircle;
        public final ForgeConfigSpec.ConfigValue<Boolean> showEnhancedTooltips;
        public final ForgeConfigSpec.ConfigValue<Boolean> highlight;
        public final ForgeConfigSpec.ConfigValue<Boolean> skipRespawnScreen;
        public final ForgeConfigSpec.ConfigValue<Boolean> showShadowStep;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableHalloweenEffect;
        public final ForgeConfigSpec.ConfigValue<Integer> textColorDeathDate;
        public final ForgeConfigSpec.ConfigValue<Integer> textColorRIP;
        public final ForgeConfigSpec.ConfigValue<Integer> textColorOwner;
        public final ForgeConfigSpec.ConfigValue<Boolean> dateInMCTime;
        public final ForgeConfigSpec.ConfigValue<Boolean> displayKnowledgeMessage;
        public final ForgeConfigSpec.ConfigValue<Boolean> equipElytraInPriority;
        public final ForgeConfigSpec.ConfigValue<GraveModel> favoriteGrave;
        public final ForgeConfigSpec.ConfigValue<BlockGraveMarble.MarbleType> favoriteGraveMarble;
        public final ForgeConfigSpec.ConfigValue<Boolean> showInfoOnEnchantment;
        public final ForgeConfigSpec.ConfigValue<GraveSkinRule> graveSkinRule;
        public final ForgeConfigSpec.ConfigValue<Boolean> priorizeToolOnHotbar;
        public final ForgeConfigSpec.ConfigValue<Integer> fogColor;
        public final ForgeConfigSpec.ConfigValue<FogPeriod> fogPeriod;
        public final ForgeConfigSpec.ConfigValue<Boolean> activateGraveBySneaking;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Personal Options that can be edited even on server").push("client");
            this.fogDensity = builder.comment("Fog density around the graves [NONE/LOW/NORMAL/HIGH|default:LOW]").translation(ConfigTombstone.getTranslation("fog_density")).defineEnum("fog_density", (Enum)FogDensity.LOW);
            this.particleCastingColor = builder.comment("Decimal value for the color of the particles when using magic items [0..16777215|default:125656]").translation(ConfigTombstone.getTranslation("particle_casting_color")).defineInRange("particle_casting_color", 14937088, 0, 0xFFFFFF);
            this.showMagicCircle = builder.comment("Shows the magic circles when using some items [false/true|default:true]").translation(ConfigTombstone.getTranslation("show_magic_circle")).define("show_magic_circle", true);
            this.showEnhancedTooltips = builder.comment("Shows all the infos in the tooltip of items [false/true|default:true]").translation(ConfigTombstone.getTranslation("show_enhanced_tooltips")).define("show_enhanced_tooltips", true);
            this.highlight = builder.comment("Highlights the tomb from far when holding the key [false/true|default:true]").translation(ConfigTombstone.getTranslation("highlight")).define("highlight", true);
            this.skipRespawnScreen = builder.comment("Skips the Respawn Screen [false/true|default:false]").translation(ConfigTombstone.getTranslation("skip_respawn_screen")).define("skip_respawn_screen", false);
            this.showShadowStep = builder.comment("Shows shadow step particles [false/true|default:true]").translation(ConfigTombstone.getTranslation("hide_shadow_step")).define("hide_shadow_step", true);
            this.enableHalloweenEffect = builder.comment("Enables the special rendering and particles for Halloween [false/true|default:true]").translation(ConfigTombstone.getTranslation("enable_halloween_effect")).define("enable_halloween_effect", true);
            this.textColorDeathDate = builder.comment("Decimal value for the color of the grave text <Death Date> [0..16777215|default:2962496]").translation(ConfigTombstone.getTranslation("text_color_death_date")).defineInRange("text_color_death_date", 2962496, 0, 0xFFFFFF);
            this.textColorRIP = builder.comment("Decimal value for the color of the grave text <R.I.P.> [0..16777215|default:2962496]").translation(ConfigTombstone.getTranslation("text_color_rip")).defineInRange("text_color_rip", 2962496, 0, 0xFFFFFF);
            this.textColorOwner = builder.comment("Decimal value for the color of the grave text <Owner Name> [0..16777215|default:5991302]").translation(ConfigTombstone.getTranslation("text_color_owner")).defineInRange("text_color_owner", 5991302, 0, 0xFFFFFF);
            this.dateInMCTime = builder.comment("Shows only the elapsed minecraft days since the death on graves [false/true|default:false]").translation(ConfigTombstone.getTranslation("date_in_mc_time")).define("date_in_mc_time", false);
            this.displayKnowledgeMessage = builder.comment("Display or not the messages of gain of points in knowledge of death [false/true|default:true]").translation(ConfigTombstone.getTranslation("display_knowledge_message")).define("display_knowledge_message", true);
            this.equipElytraInPriority = builder.comment("Equips elytra in priority when recovering your lost items [false/true|default:false]").translation(ConfigTombstone.getTranslation("equip_elytra_in_priority")).define("equip_elytra_in_priority", false);
            this.favoriteGrave = builder.comment("Favorite grave").translation(ConfigTombstone.getTranslation("favorite_grave")).defineEnum("favorite_grave", (Enum)GraveModel.GRAVE_SIMPLE);
            this.favoriteGraveMarble = builder.comment("Favorite grave marble").translation(ConfigTombstone.getTranslation("favorite_grave_marble")).defineEnum("favorite_grave_marble", (Enum)BlockGraveMarble.MarbleType.DARK);
            this.showInfoOnEnchantment = builder.comment("Shows the use of the Tombstone's enchantments in tooltip [false/true|default:true]").translation(ConfigTombstone.getTranslation("show_info_on_enchantment")).define("show_info_on_enchantment", true);
            this.graveSkinRule = builder.comment("Defines the rule to use for grave's skin [DEFAULT/FORCE_NORMAL/FORCE_HALLOWEEN|default:DEFAULT]").translation(ConfigTombstone.getTranslation("grave_skin_rule")).defineEnum("grave_skin_rule", (Enum)GraveSkinRule.DEFAULT);
            this.priorizeToolOnHotbar = builder.comment("Favor the tools on the hotbar when recovering a grave [false/true|default:false]").translation(ConfigTombstone.getTranslation("priorize_tool_on_hotbar")).define("priorize_tool_on_hotbar", false);
            this.fogColor = builder.comment("Decimal value of the fog color [0..16777215|default:125656]").translation(ConfigTombstone.getTranslation("fog_color")).defineInRange("fog_color", 0xFFFFFF, 0, 0xFFFFFF);
            this.fogPeriod = builder.comment("Period where graves produce fog [DAY/NIGHT/BOTH|default:NIGHT]").translation(ConfigTombstone.getTranslation("fog_period")).defineEnum("fog_period", (Enum)FogPeriod.NIGHT);
            this.activateGraveBySneaking = builder.comment("Allows to activate a grave by sneaking [false/true|default:true]").translation(ConfigTombstone.getTranslation("activate_grave_by_sneaking")).define("activate_grave_by_sneaking", true);
            builder.pop();
        }

        public static enum GraveSkinRule {
            DEFAULT,
            FORCE_NORMAL,
            FORCE_HALLOWEEN;

        }

        public static enum FogPeriod implements Predicate<World>
        {
            DAY(Helper::isDay),
            NIGHT(Helper::isNight),
            BOTH(world -> true),
            NEVER(world -> false);

            private final Predicate<World> predic;

            private FogPeriod(Predicate<World> predic) {
                this.predic = predic;
            }

            @Override
            public boolean test(World world) {
                return this.predic.test(world);
            }
        }

        public static enum FogDensity {
            NONE,
            LOW,
            NORMAL,
            HIGH;

        }
    }

    public static class DecorativeGrave {
        public final ForgeConfigSpec.ConfigValue<Integer> timeSoul;
        public final ForgeConfigSpec.ConfigValue<Integer> chanceSoul;
        public final ForgeConfigSpec.ConfigValue<Integer> chancePrayReward;
        public final ForgeConfigSpec.ConfigValue<Boolean> lostTabletSearchOutsideWorld;
        public final ForgeConfigSpec.ConfigValue<Boolean> lostTabletSearchModdedStructure;
        public final ForgeConfigSpec.ConfigValue<List<String>> lostTabletDeniedStructures;
        public final ForgeConfigSpec.ConfigValue<List<String>> blackListCapturableSouls;
        public final ForgeConfigSpec.ConfigValue<Boolean> purificationAffectNeutralEffects;
        public final ForgeConfigSpec.ConfigValue<Integer> durationVoodooPoppetEffects;

        public DecorativeGrave(ForgeConfigSpec.Builder builder) {
            builder.comment("For settings related to decorative tombs and magic items").push("decorative_grave");
            this.timeSoul = builder.comment("Time in minutes to check if a soul appears on a grave [10..10000|default:30]").translation(ConfigTombstone.getTranslation("time_soul")).defineInRange("time_soul", 30, 10, 10000);
            this.chanceSoul = builder.comment("Chance on 1000 that a soul appears on a grave [0..1000|default:100]").translation(ConfigTombstone.getTranslation("chance_soul")).defineInRange("chance_soul", 100, 0, 1000);
            this.chancePrayReward = builder.comment("Chance to receive a random beneficial spell effect when praying near a grave [0..100|default:40]").translation(ConfigTombstone.getTranslation("chance_pray_reward")).defineInRange("chance_pray_reward", 40, 0, 100);
            this.lostTabletSearchOutsideWorld = builder.comment("Allows lost tablets to find locations outside the current world [false/true|default:true]").translation(ConfigTombstone.getTranslation("lost_tablet_search_outside_world")).define("lost_tablet_search_outside_world", true);
            this.lostTabletSearchModdedStructure = builder.comment("Allows lost tablets to find modded structures [false/true|default:true]").translation(ConfigTombstone.getTranslation("lost_tablet_modded_structure")).define("lost_tablet_modded_structure", true);
            this.lostTabletDeniedStructures = builder.comment("The structures that can't be discovered by lost tablets").translation(ConfigTombstone.getTranslation("lost_tablet_denied_structures")).define("lost_tablet_denied_structures", new ArrayList());
            this.blackListCapturableSouls = builder.comment("The creatures that can't be captured in receptacle").translation(ConfigTombstone.getTranslation("black_list_capturable_souls")).define("black_list_capturable_souls", new ArrayList());
            this.purificationAffectNeutralEffects = builder.comment("Allows the purification effect to clear neutral effects [false/true|default:true]").translation(ConfigTombstone.getTranslation("purification_affect_neutral_effects")).define("purification_affect_neutral_effects", true);
            this.durationVoodooPoppetEffects = builder.comment("Duration of voodoo poppet's effects in seconds when preventing death [5..60000|default:60]").translation(ConfigTombstone.getTranslation("duration_voodoo_poppet_effects")).defineInRange("duration_voodoo_poppet_effects", 60, 5, 60000);
            builder.pop();
        }
    }

    public static class Enchantments {
        public final ForgeConfigSpec.ConfigValue<Boolean> restrictShadowStepToPlayer;
        public final ForgeConfigSpec.ConfigValue<Boolean> nerfPlagueBringer;
        public final ForgeConfigSpec.ConfigValue<Integer> maxDurationMagicSiphon;
        public final ForgeConfigSpec.ConfigValue<Integer> durationPlagueBringer;

        public Enchantments(ForgeConfigSpec.Builder builder) {
            builder.comment("Allows to customize or disable the enchantments").push("enchantments");
            this.restrictShadowStepToPlayer = builder.comment("Restricts the effect of Shadow Step to players [false/true|default:true]").translation(ConfigTombstone.getTranslation("restrict_shadow_step_to_player")).define("restrict_shadow_step_to_player", true);
            this.nerfPlagueBringer = builder.comment("The wearer is also affected by the effect if his alignment is not bad [false/true|default:true]").translation(ConfigTombstone.getTranslation("nerf_plague_bringer")).define("nerf_plague_bringer", true);
            this.maxDurationMagicSiphon = builder.comment("Maximum duration of stolen effects in minutes [1..MAX|default:1440]").translation(ConfigTombstone.getTranslation("max_duration_magic_siphon")).defineInRange("max_duration_magic_siphon", 1440, 1, Integer.MAX_VALUE);
            this.durationPlagueBringer = builder.comment("Duration of applied effects in seconds [1..MAX|default:10]").translation(ConfigTombstone.getTranslation("duration_plague_bringer")).defineInRange("duration_plague_bringer", 10, 1, Integer.MAX_VALUE);
            builder.pop();
        }
    }

    public static class General {
        public final ForgeConfigSpec.ConfigValue<Integer> snifferRange;
        public final ForgeConfigSpec.ConfigValue<Boolean> handlePlayerDeath;
        public final ForgeConfigSpec.ConfigValue<Boolean> logPlayerGrave;
        public final ForgeConfigSpec.ConfigValue<Boolean> playerGraveAccess;
        public final ForgeConfigSpec.ConfigValue<Boolean> graveKeyOnDeath;
        public final ForgeConfigSpec.ConfigValue<Boolean> lossOnDeathOnlyForAbandonedGrave;
        public final ForgeConfigSpec.ConfigValue<Boolean> lossOnDeathOnlyForStackableItems;
        public final ForgeConfigSpec.ConfigValue<Integer> chanceLossOnDeath;
        public final ForgeConfigSpec.ConfigValue<Integer> percentLossOnDeath;
        public final ForgeConfigSpec.ConfigValue<Boolean> restoreEffectsOnDeath;
        public final ForgeConfigSpec.ConfigValue<Boolean> teleportDim;
        public final ForgeConfigSpec.ConfigValue<Integer> knowledgeLoss;
        public final ForgeConfigSpec.ConfigValue<Boolean> nerfGhostlyShape;
        public final ForgeConfigSpec.ConfigValue<Boolean> preventDeathOutsideWorld;
        public final ForgeConfigSpec.ConfigValue<Boolean> pvpMode;
        public final ForgeConfigSpec.ConfigValue<Boolean> gravesBypassGriefingRules;
        public final ForgeConfigSpec.ConfigValue<List<String>> unhandledBeneficialEffects;
        public final ForgeConfigSpec.ConfigValue<List<String>> unhandledHarmfulEffects;
        public final ForgeConfigSpec.ConfigValue<List<String>> noGraveLocation;
        public final ForgeConfigSpec.ConfigValue<Integer> chanceMobOnGraveRecovery;
        public final ForgeConfigSpec.ConfigValue<Boolean> knowledgeReducePhantomSpawn;
        public final ForgeConfigSpec.ConfigValue<Integer> timeForPhantomSpawn;
        public final ForgeConfigSpec.ConfigValue<Boolean> persistantHalloween;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowGraveInWater;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowBeyondTheGraveDamage;
        public final ForgeConfigSpec.ConfigValue<Integer> cooldownRequestTeleport;
        public final ForgeConfigSpec.ConfigValue<Integer> cooldownTeleportDeath;
        public final ForgeConfigSpec.ConfigValue<Integer> cooldownTeleportBind;
        public final ForgeConfigSpec.ConfigValue<Boolean> autoEquipOnDeathRespawn;
        public final ForgeConfigSpec.ConfigValue<Boolean> fishingTreasureInOpenWater;

        public General(ForgeConfigSpec.Builder builder) {
            builder.comment("Miscellaneous options").push("general");
            this.snifferRange = builder.comment("The radius in which items should be collected when a grave is spawned [1..10|default:5]").translation(ConfigTombstone.getTranslation("sniffer_range")).defineInRange("sniffer_range", 5, 1, 10);
            this.handlePlayerDeath = builder.comment("Whether to handle player death [false/true|default:true]").translation(ConfigTombstone.getTranslation("handle_player_death")).define("handle_player_death", true);
            this.logPlayerGrave = builder.comment("Whether to log the positions of players' graves [false/true|default:true]").translation(ConfigTombstone.getTranslation("log_player_grave")).define("log_player_grave", true);
            this.playerGraveAccess = builder.comment("Whether to require a Grave's Key to access graves [false/true|default:true]").translation(ConfigTombstone.getTranslation("player_grave_access")).define("player_grave_access", true);
            this.graveKeyOnDeath = builder.comment("Whether to always give players a Grave's Key on death [false/true|default:true]").translation(ConfigTombstone.getTranslation("grave_key_on_death")).define("grave_key_on_death", true);
            this.lossOnDeathOnlyForAbandonedGrave = builder.comment("Only abandoned graves can have losses of items (based on the decay_time) [false/true|default:true]").translation(ConfigTombstone.getTranslation("loss_on_death_only_for_abandoned_grave")).define("loss_on_death_only_for_abandoned_grave", true);
            this.lossOnDeathOnlyForStackableItems = builder.comment("Only stackable items can be lost on death [false/true|default:true]").translation(ConfigTombstone.getTranslation("loss_on_death_only_for_stackable_items")).define("loss_on_death_only_for_stackable_items", true);
            this.chanceLossOnDeath = builder.comment("The chance that some items are lost on death [0..100|default:0]").translation(ConfigTombstone.getTranslation("chance_loss_on_death")).defineInRange("chance_loss_on_death", 0, 0, 100);
            this.percentLossOnDeath = builder.comment("The percentage of items that are lost on death [0..100|default:0]").translation(ConfigTombstone.getTranslation("percent_loss_on_death")).defineInRange("percent_loss_on_death", 0, 0, 100);
            this.restoreEffectsOnDeath = builder.comment("Whether to restore beneficial effects after a player dies [false/true|default:true]").translation(ConfigTombstone.getTranslation("restore_effects_on_death")).define("restore_effects_on_death", false);
            this.teleportDim = builder.comment("Allows teleportation to other dimensions [false/true|default:true]").translation(ConfigTombstone.getTranslation("teleport_dim")).define("teleport_dim", true);
            this.knowledgeLoss = builder.comment("Knowledge of Death loss why dying [0..500|default:0]").translation(ConfigTombstone.getTranslation("knowledge_loss")).defineInRange("knowledge_loss", 0, 0, 500);
            this.nerfGhostlyShape = builder.comment("Whether to cancel the Ghostly Shape effect on breaking a block or opening a chest [false/true|default:false]").translation(ConfigTombstone.getTranslation("nerf_ghostly_shape")).define("nerf_ghostly_shape", false);
            this.preventDeathOutsideWorld = builder.comment("Prevents death outside of world borders [false/true|default:false]").translation(ConfigTombstone.getTranslation("prevent_death_outside_world")).define("prevent_death_outside_world", false);
            this.pvpMode = builder.comment("Enables PvP mode, which allows players to open graves of players they kill [false/true|default:false]").translation(ConfigTombstone.getTranslation("pvp_mode")).define("pvp_mode", false);
            this.gravesBypassGriefingRules = builder.comment("Whether graves should be allowed to bypass anti-griefing rules [false/true|default:true]").translation(ConfigTombstone.getTranslation("graves_bypass_griefing_rules")).define("graves_bypass_griefing_rules", true);
            this.unhandledBeneficialEffects = builder.comment("Beneficial effects that can't used by certain features such as ankh of pray, lollipop, scroll of preservation, alchemy perk and magic siphon enchantment").translation(ConfigTombstone.getTranslation("unhandled_beneficial_effects")).define("unhandled_beneficial_effects", (Object)Lists.newArrayList((Object[])new String[]{"tombstone:ghostly_shape", "tombstone:preservation", "tombstone:exorcism"}));
            this.unhandledHarmfulEffects = builder.comment("Harmful effects that can't used by certain features such as tablet of cupidity and the enchantment plague bringer").translation(ConfigTombstone.getTranslation("unhandled_harmful_effects")).define("unhandled_harmful_effects", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:nausea"}));
            this.noGraveLocation = builder.comment("Graveless Areas").translation(ConfigTombstone.getTranslation("no_grave_location")).define("no_grave_location", (Object)Lists.newArrayList((Object[])new String[]{"0, 0, 0, -10000, 20"}));
            this.chanceMobOnGraveRecovery = builder.comment("The chance that creatures appear after the contents of a grave are retrieved [0..100|default:0]").translation(ConfigTombstone.getTranslation("chance_mob_on_grave_recovery")).defineInRange("chance_mob_on_grave_recovery", 0, 0, 100);
            this.knowledgeReducePhantomSpawn = builder.comment("Increases the minimum time without sleeping for phantom spawn around player based on their level in Knowledge of Death [false/true|default:true]").translation(ConfigTombstone.getTranslation("knowledge_reduce_phantom_spawn")).define("knowledge_reduce_phantom_spawn", true);
            this.timeForPhantomSpawn = builder.comment("Minimum time without sleeping for phantom to spawn around players [1200..MAX|default:72000]").translation(ConfigTombstone.getTranslation("time_for_phantom_spawn")).defineInRange("time_for_phantom_spawn", 72000, 1200, Integer.MAX_VALUE);
            this.persistantHalloween = builder.comment("The Halloween features also happen outside the dates of the event [false/true|default:false]").translation(ConfigTombstone.getTranslation("persistant_halloween")).worldRestart().define("persistant_halloween", false);
            this.allowGraveInWater = builder.comment("Allows player's graves to appear in water [false/true|default:true]").translation(ConfigTombstone.getTranslation("allow_grave_in_water")).define("allow_grave_in_water", true);
            this.allowBeyondTheGraveDamage = builder.comment("Allows players to be hurt by special damages related to some items [false/true|default:true]").translation(ConfigTombstone.getTranslation("allow_beyond_the_grave_damage")).define("allow_beyond_the_grave_damage", true);
            this.cooldownRequestTeleport = builder.comment("Cooldown in minutes to use the command tbrequestteleport [-1..1440|default:-1]").translation(ConfigTombstone.getTranslation("cooldown_request_teleport")).defineInRange("cooldown_request_teleport", -1, -1, 1440);
            this.cooldownTeleportDeath = builder.comment("Cooldown in minutes to use the command tbteleportdeath [-1..1440|default:-1]").translation(ConfigTombstone.getTranslation("cooldown_teleport_death")).defineInRange("cooldown_teleport_death", -1, -1, 1440);
            this.cooldownTeleportBind = builder.comment("Cooldown in minutes to use the command tbbind [-1..1440|default:-1]").translation(ConfigTombstone.getTranslation("cooldown_teleport_bind")).defineInRange("cooldown_teleport_bind", -1, -1, 1440);
            this.autoEquipOnDeathRespawn = builder.comment("Automatically equips any equipable items when respawning after a death [false/true|default:true]").translation(ConfigTombstone.getTranslation("auto_equip_on_death_respawn")).define("auto_equip_on_death_respawn", true);
            this.fishingTreasureInOpenWater = builder.comment("Fishing treasures can only be found in open water [false/true|default:true]").translation(ConfigTombstone.getTranslation("fishing_treasure_in_open_water")).define("fishing_treasure_in_open_water", true);
            builder.pop();
        }
    }
}

