/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maessentials.common.util;

import com.maciej916.maessentials.common.config.ModConfig;
import com.maciej916.maessentials.common.data.DataManager;
import com.maciej916.maessentials.common.lib.Location;
import com.maciej916.maessentials.common.lib.player.EssentialPlayer;
import com.maciej916.maessentials.common.lib.teleport.TeleportRequest;
import com.maciej916.maessentials.common.lib.teleport.TeleportSimple;
import com.maciej916.maessentials.common.util.LocationUtils;
import com.maciej916.maessentials.common.util.LogUtils;
import com.maciej916.maessentials.common.util.ModUtils;
import com.maciej916.maessentials.common.util.TextUtils;
import com.maciej916.maessentials.common.util.TimeUtils;
import java.util.ArrayList;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.server.ServerWorld;

public final class TeleportUtils {
    private static final ArrayList<TeleportSimple> teleportSimple = new ArrayList();
    private static final ArrayList<TeleportRequest> teleportRequests = new ArrayList();

    public static boolean simpleTeleport(ServerPlayerEntity player, Location location, String teleport, long delay) {
        EssentialPlayer eslPlayer = DataManager.getPlayer(player);
        if (eslPlayer.getTemp().isTeleportActive()) {
            TextUtils.sendMessage(player, "teleport.maessentials.active", new Object[0]);
            return false;
        }
        if (delay == 0L) {
            TextUtils.sendMessage(player, "teleport.maessentials.teleported", new Object[0]);
            TeleportUtils.doTeleport(player, location, true, true);
            return true;
        }
        eslPlayer.getTemp().setTeleportActive(new Location(player));
        TeleportSimple tpS = new TeleportSimple(player, location, teleport, delay);
        TeleportUtils.doSimpleTeleport(tpS);
        return true;
    }

    public static boolean requestTeleport(ServerPlayerEntity creator, ServerPlayerEntity player, ServerPlayerEntity target, long delay) {
        EssentialPlayer eslPlayer = DataManager.getPlayer(player);
        if (eslPlayer.getTemp().isTeleportActive()) {
            TextUtils.sendMessage(player, "teleport.maessentials.active", new Object[0]);
            return false;
        }
        TeleportRequest existTpR = TeleportUtils.findRequest(creator, player, target);
        if (existTpR != null) {
            TextUtils.sendMessage(player, "tpa.maessentials.exist", target.func_145748_c_());
            return false;
        }
        TeleportRequest tpR = new TeleportRequest(creator, player, target, delay);
        TeleportUtils.doRequetTeleport(tpR);
        return true;
    }

    public static void doSimpleTeleport(TeleportSimple simple) {
        teleportSimple.add(simple);
    }

    public static void doRequetTeleport(TeleportRequest request) {
        teleportRequests.add(request);
    }

    public static TeleportRequest findRequest(ServerPlayerEntity creator, ServerPlayerEntity player, ServerPlayerEntity target) {
        for (TeleportRequest tp : teleportRequests) {
            if (tp.getCreator() != creator || tp.getPlayer() != player || tp.getTarget() != target) continue;
            return tp;
        }
        return null;
    }

    public static TeleportRequest findRequest(ServerPlayerEntity creator, ServerPlayerEntity target) {
        for (TeleportRequest tp : teleportRequests) {
            if ((tp.getCreator() != target || tp.getPlayer() != creator || tp.getTarget() != target) && (tp.getPlayer() != target || tp.getTarget() != creator)) continue;
            return tp;
        }
        return null;
    }

    public static ArrayList<TeleportRequest> findRequest(ServerPlayerEntity player) {
        ArrayList<TeleportRequest> found = new ArrayList<TeleportRequest>();
        for (TeleportRequest tp : teleportRequests) {
            if (tp.getPlayer() != player && tp.getTarget() != player) continue;
            found.add(tp);
        }
        return found;
    }

    public static void acceptRequest(TeleportRequest request) {
        if (request.getDelay() == 0L) {
            TextUtils.sendMessage(request.getPlayer(), "teleport.maessentials.tpaccept.request", request.getTargetName());
            TextUtils.sendMessage(request.getTarget(), "teleport.maessentials.tpaccept.target", request.getPlayerName());
            TeleportUtils.doTeleport(request.getPlayer(), request.getDestination(), true, true);
            teleportRequests.remove(request);
        } else {
            TextUtils.sendMessage(request.getPlayer(), "teleport.maessentials.tpaccept.request.wait", ModConfig.tpa_delay);
            TextUtils.sendMessage(request.getTarget(), "teleport.maessentials.tpaccept.target.wait", request.getPlayerName());
            EssentialPlayer eslPlayer = DataManager.getPlayer(request.getPlayer());
            eslPlayer.getTemp().setTeleportActive(new Location(request.getPlayer()));
            request.setAccepted();
        }
    }

    public static void declineRequest(TeleportRequest request) {
        TextUtils.sendMessage(request.getPlayer(), "teleport.maessentials.tpdeny.request", request.getTargetName());
        TextUtils.sendMessage(request.getTarget(), "teleport.maessentials.tpdeny.target", request.getPlayerName());
        teleportRequests.remove(request);
    }

    public static void checkTeleports() {
        TeleportUtils.checkSimple();
        if (ModConfig.tpa_enable.booleanValue() || ModUtils.isDev()) {
            TeleportUtils.checkRequest();
        }
    }

    private static void checkSimple() {
        try {
            ArrayList<TeleportSimple> del = new ArrayList<TeleportSimple>();
            for (TeleportSimple tp : teleportSimple) {
                EssentialPlayer eslPlayer;
                Location tpLocation;
                ServerPlayerEntity player = tp.getPlayer();
                Location playerLocation = new Location(player);
                if (LocationUtils.checkLocation(playerLocation, tpLocation = (eslPlayer = DataManager.getPlayer(player)).getTemp().getTeleportLocation())) {
                    if (TimeUtils.currentTimestamp() < tp.getTeleportTime()) continue;
                    TextUtils.sendMessage(player, "teleport.maessentials.teleported", new Object[0]);
                    eslPlayer.getTemp().setTeleportNotActive();
                    eslPlayer.getUsage().setTeleportUsage(tp.getType());
                    eslPlayer.saveData();
                    TeleportUtils.doTeleport(player, tp.getDestination(), true, true);
                    del.add(tp);
                    continue;
                }
                TextUtils.sendMessage(player, "teleport.maessentials.moved", new Object[0]);
                eslPlayer.getTemp().setTeleportNotActive();
                del.add(tp);
            }
            teleportSimple.removeAll(del);
        }
        catch (Exception e) {
            System.out.println("checkSimple error:");
            System.out.println(e);
        }
    }

    private static void checkRequest() {
        try {
            ArrayList<TeleportRequest> del = new ArrayList<TeleportRequest>();
            for (TeleportRequest tp : teleportRequests) {
                if (tp.isAccepted()) {
                    ServerPlayerEntity player = tp.getPlayer();
                    if (player == null) continue;
                    Location playerLocation = new Location(player);
                    EssentialPlayer eslPlayer = DataManager.getPlayer(player);
                    Location tpLocation = eslPlayer.getTemp().getTeleportLocation();
                    if (LocationUtils.checkLocation(playerLocation, tpLocation)) {
                        if (TimeUtils.currentTimestamp() < tp.getTeleportTime()) continue;
                        TextUtils.sendMessage(tp.getPlayer(), "teleport.maessentials.tpaccept.request", tp.getTargetName());
                        TextUtils.sendMessage(tp.getTarget(), "teleport.maessentials.tpaccept.target", tp.getPlayerName());
                        eslPlayer.getTemp().setTeleportNotActive();
                        eslPlayer.getUsage().setTeleportUsage("tpa");
                        eslPlayer.saveData();
                        TeleportUtils.doTeleport(tp.getPlayer(), new Location(tp.getTarget()), true, true);
                        del.add(tp);
                        continue;
                    }
                    TextUtils.sendMessage(tp.getPlayer(), "teleport.maessentials.moved.request", new Object[0]);
                    TextUtils.sendMessage(tp.getTarget(), "teleport.maessentials.moved.target", tp.getPlayerName());
                    eslPlayer.getTemp().setTeleportNotActive();
                    del.add(tp);
                    continue;
                }
                if (TimeUtils.currentTimestamp() < tp.getTimeout()) continue;
                TextUtils.sendMessage(tp.getPlayer(), "teleport.maessentials.expired.target", tp.getTargetName());
                TextUtils.sendMessage(tp.getTarget(), "teleport.maessentials.expired.request", tp.getPlayerName());
                del.add(tp);
            }
            teleportRequests.removeAll(del);
        }
        catch (Exception e) {
            System.out.println("checkRequest error:");
            System.out.println(e);
        }
    }

    public static void doTeleport(ServerPlayerEntity player, Location loc, boolean exact, boolean saveLastLocation) {
        try {
            if (saveLastLocation) {
                EssentialPlayer eslPlayer = DataManager.getPlayer(player);
                eslPlayer.getData().setLastLocation(new Location(player));
                eslPlayer.saveData();
            }
            ServerWorld worldDest = player.field_71133_b.func_71218_a(loc.getDimension());
            if (exact) {
                player.func_200619_a(worldDest, loc.x, loc.y, loc.z, loc.rotationYaw, loc.rotationPitch);
            } else {
                player.func_200619_a(worldDest, loc.x + 0.5, loc.y + 0.5, loc.z, player.field_70177_z, player.field_70125_A);
            }
        }
        catch (Exception e) {
            LogUtils.err("Failed to do teleport for player " + player.func_145748_c_().getString() + ". Error: " + e.getMessage());
            TextUtils.sendMessage(player, "teleport.maessentials.teleport.failed", new Object[0]);
        }
    }
}

