/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maessentials.common.command.impl.player;

import com.maciej916.maessentials.common.command.BaseCommand;
import com.maciej916.maessentials.common.config.ModConfig;
import com.maciej916.maessentials.common.data.DataManager;
import com.maciej916.maessentials.common.lib.Location;
import com.maciej916.maessentials.common.lib.player.EssentialPlayer;
import com.maciej916.maessentials.common.util.LocationUtils;
import com.maciej916.maessentials.common.util.TeleportUtils;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class RndtpCommand
extends BaseCommand {
    public RndtpCommand(String command, int permissionLevel, boolean enabled) {
        super(command, permissionLevel, enabled);
    }

    @Override
    public LiteralArgumentBuilder<CommandSource> setExecution() {
        return (LiteralArgumentBuilder)this.builder.executes(context -> this.execute((CommandSource)context.getSource()));
    }

    private int execute(CommandSource source) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        ServerWorld world = source.func_197023_e();
        EssentialPlayer eslPlayer = DataManager.getPlayer(player);
        long cooldown = eslPlayer.getUsage().getTeleportCooldown("rndtp", ModConfig.rndtp_cooldown.intValue());
        if (cooldown != 0L) {
            this.sendMessage(player, "maessentials.cooldown", cooldown);
            return 1;
        }
        Location spawnLocation = DataManager.getWorld().getSpawn();
        if (spawnLocation.getDimensionID() != player.field_71093_bK.func_186068_a()) {
            this.sendMessage(player, "rndtp.maessentials.dimension", new Object[0]);
            return 1;
        }
        Location location = LocationUtils.findRandomTp((World)world, spawnLocation, player, 0);
        if (location == null) {
            this.sendMessage(player, "rndtp.maessentials.not_found", new Object[0]);
            return 1;
        }
        eslPlayer.getUsage().setCommandUsage("rndtp");
        eslPlayer.saveData();
        if (TeleportUtils.simpleTeleport(player, location, "rndtp", ModConfig.rndtp_delay.intValue())) {
            if (ModConfig.rndtp_delay == 0) {
                this.sendMessage(player, "rndtp.maessentials.teleport", new Object[0]);
            } else {
                this.sendMessage(player, "rndtp.maessentials.teleport.wait", ModConfig.rndtp_delay);
            }
        }
        return 1;
    }
}

