/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maessentials.common.command.impl.player;

import com.maciej916.maessentials.common.command.BaseCommand;
import com.maciej916.maessentials.common.config.ModConfig;
import com.maciej916.maessentials.common.data.DataManager;
import com.maciej916.maessentials.common.lib.Location;
import com.maciej916.maessentials.common.lib.player.EssentialPlayer;
import com.maciej916.maessentials.common.util.TeleportUtils;
import com.maciej916.maessentials.common.util.TimeUtils;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;

public class BackCommand
extends BaseCommand {
    public BackCommand(String command, int permissionLevel, boolean enabled) {
        super(command, permissionLevel, enabled);
    }

    @Override
    public LiteralArgumentBuilder<CommandSource> setExecution() {
        return (LiteralArgumentBuilder)this.builder.executes(context -> this.execute((CommandSource)context.getSource()));
    }

    private int execute(CommandSource source) throws CommandSyntaxException {
        boolean recentlyDied;
        ServerPlayerEntity player = source.func_197035_h();
        EssentialPlayer eslPlayer = DataManager.getPlayer(player);
        Location location = eslPlayer.getData().getLastLocation();
        if (location == null) {
            this.sendMessage(player, "back.maessentials.not_found", new Object[0]);
            return 1;
        }
        long deathTime = eslPlayer.getData().getLastDeath();
        boolean bl = recentlyDied = deathTime + (long)ModConfig.back_death_custom_cooldown.intValue() > TimeUtils.currentTimestamp();
        if (ModConfig.back_death_custom_cooldown != 0 && recentlyDied) {
            long cooldown = eslPlayer.getUsage().getTeleportCooldown("back", ModConfig.back_death_custom_cooldown.intValue());
            if (cooldown != 0L) {
                this.sendMessage(player, "back.maessentials.cooldown.teleport", cooldown);
                return 1;
            }
        } else {
            long cooldown = eslPlayer.getUsage().getTeleportCooldown("back", ModConfig.back_cooldown.intValue());
            if (cooldown != 0L) {
                this.sendMessage(player, "maessentials.cooldown.teleport", cooldown);
                return 1;
            }
        }
        eslPlayer.getUsage().setCommandUsage("back");
        eslPlayer.saveData();
        if (TeleportUtils.simpleTeleport(player, location, "back", ModConfig.back_delay.intValue())) {
            if (ModConfig.back_delay == 0) {
                this.sendMessage(player, "back.maessentials.success", new Object[0]);
            } else {
                this.sendMessage(player, "back.maessentials.success.wait", ModConfig.back_delay);
            }
        }
        return 1;
    }
}

