/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maessentials.common.command.impl.admin;

import com.maciej916.maessentials.common.command.BaseCommand;
import com.maciej916.maessentials.common.data.DataManager;
import com.maciej916.maessentials.common.lib.player.EssentialPlayer;
import com.maciej916.maessentials.common.lib.player.PlayerRestriction;
import com.maciej916.maessentials.common.util.TimeUtils;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.MessageArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class TempbanCommand
extends BaseCommand {
    public TempbanCommand(String command, int permissionLevel, boolean enabled) {
        super(command, permissionLevel, enabled);
    }

    @Override
    public LiteralArgumentBuilder<CommandSource> setExecution() {
        return (LiteralArgumentBuilder)this.builder.then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"targetPlayer", (ArgumentType)EntityArgument.func_197094_d()).executes(context -> this.execute((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"targetPlayer")))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"time", (ArgumentType)StringArgumentType.word()).executes(context -> this.execute((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"targetPlayer"), StringArgumentType.getString((CommandContext)context, (String)"time").toLowerCase()))).then(Commands.func_197056_a((String)"reason", (ArgumentType)MessageArgument.func_197123_a()).executes(context -> this.execute((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"targetPlayer"), StringArgumentType.getString((CommandContext)context, (String)"time").toLowerCase(), MessageArgument.func_197124_a((CommandContext)context, (String)"reason"))))));
    }

    private int execute(CommandSource source, ServerPlayerEntity targetPlayer) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        this.sendMessage(player, "tempban.maessentials.provide.time", new Object[0]);
        return 1;
    }

    private int execute(CommandSource source, ServerPlayerEntity targetPlayer, String time) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        this.doTempban(player, targetPlayer, time, "No reason provided");
        return 1;
    }

    private int execute(CommandSource source, ServerPlayerEntity targetPlayer, String time, ITextComponent reason) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        this.doTempban(player, targetPlayer, time, reason.getString());
        return 1;
    }

    private void doTempban(ServerPlayerEntity player, ServerPlayerEntity target, String time, String reason) {
        EssentialPlayer eslTargetPlayer = DataManager.getPlayer(target);
        PlayerRestriction ban = eslTargetPlayer.getRestrictions().getBan();
        long banTime = TimeUtils.parseDate(time, true);
        if (time.equals("perm")) {
            banTime = -1L;
        }
        if (banTime == 0L) {
            this.sendMessage(player, "maessentials.illegal_date", new Object[0]);
            return;
        }
        if (ban != null && (TimeUtils.currentTimestamp() < ban.getTime() || ban.getTime() == -1L)) {
            this.sendMessage(player, "tempban.maessentials.already_banned", target.func_145748_c_());
            return;
        }
        eslTargetPlayer.getRestrictions().setBan(banTime, reason);
        eslTargetPlayer.saveData();
        if (banTime == -1L) {
            this.sendGlobalMessage(player.field_71133_b.func_184103_al(), "tempban.maessentials.success.perm", target.func_145748_c_(), player.func_145748_c_(), reason);
            target.field_71135_a.func_194028_b((ITextComponent)new TranslationTextComponent("tempban.maessentials.success.perm.target", new Object[]{player.func_145748_c_(), reason}));
        } else {
            String displayTime = TimeUtils.formatDate(banTime - TimeUtils.currentTimestamp());
            this.sendGlobalMessage(player.field_71133_b.func_184103_al(), "tempban.maessentials.success", target.func_145748_c_(), player.func_145748_c_(), displayTime, reason);
            target.field_71135_a.func_194028_b((ITextComponent)new TranslationTextComponent("tempban.maessentials.success.target", new Object[]{player.func_145748_c_(), displayTime, reason}));
        }
    }
}

