/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maessentials.common.command.impl.admin;

import com.maciej916.maessentials.common.command.BaseCommand;
import com.maciej916.maessentials.common.config.ModConfig;
import com.maciej916.maessentials.common.network.Networking;
import com.maciej916.maessentials.common.network.packets.PacketSpeed;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.fml.network.NetworkDirection;

public class SpeedCommand
extends BaseCommand {
    private static final float flySpeedDefault = 0.05f;
    private static final float walkSpeedDefault = 0.1f;

    public SpeedCommand(String command, int permissionLevel, boolean enabled) {
        super(command, permissionLevel, enabled);
    }

    @Override
    public LiteralArgumentBuilder<CommandSource> setExecution() {
        return (LiteralArgumentBuilder)this.builder.then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"speed", (ArgumentType)IntegerArgumentType.integer()).executes(context -> this.execute((CommandSource)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"speed")))).then(Commands.func_197056_a((String)"targetPlayer", (ArgumentType)EntityArgument.func_197094_d()).executes(context -> this.execute((CommandSource)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"speed"), EntityArgument.func_197089_d((CommandContext)context, (String)"targetPlayer")))));
    }

    private int execute(CommandSource source, int speed) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        this.doSpeed(player, speed, player);
        return 1;
    }

    private int execute(CommandSource source, int speed, ServerPlayerEntity targetPlayer) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        this.doSpeed(player, speed, targetPlayer);
        return 1;
    }

    private void doSpeed(ServerPlayerEntity player, int speed, ServerPlayerEntity target) {
        if (target.field_71075_bZ.field_75100_b) {
            if (speed > ModConfig.speed_max_fly) {
                this.sendMessage(player, "speed.maessentials.max_fly", ModConfig.speed_max_fly);
            } else {
                float flySpeed = (float)speed * 0.05f;
                Networking.INSTANCE.sendTo((Object)new PacketSpeed(false, flySpeed), target.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
                if (player == target) {
                    this.sendMessage(player, "speed.maessentials.fly.self", speed);
                } else {
                    this.sendMessage(player, "speed.maessentials.fly.other", target.func_145748_c_(), speed);
                    this.sendMessage(target, "speed.maessentials.fly.self", speed);
                }
            }
        } else if (speed > ModConfig.speed_max_walk) {
            this.sendMessage(player, "speed.maessentials.max_walk", ModConfig.speed_max_fly);
        } else {
            float walkSpeed = (float)speed * 0.1f;
            Networking.INSTANCE.sendTo((Object)new PacketSpeed(true, walkSpeed), target.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
            if (player == target) {
                this.sendMessage(player, "speed.maessentials.walk.self", speed);
            } else {
                this.sendMessage(player, "speed.maessentials.walk.other", target.func_145748_c_(), speed);
                this.sendMessage(target, "speed.maessentials.walk.self", speed);
            }
        }
    }
}

