/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.item;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.ItemFluidContainer;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerItemCapacity;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.item.IInformationProvider;

public class DamageIndicatedItemComponent {
    public ItemFluidContainer item;

    public DamageIndicatedItemComponent(ItemFluidContainer item) {
        this.item = item;
    }

    public void fillItemGroup(ItemGroup itemGroup, NonNullList<ItemStack> items, Fluid fluid) {
        ItemStack itemStackFull = new ItemStack((IItemProvider)this.item);
        IFluidHandlerItemCapacity fluidHanderFull = (IFluidHandlerItemCapacity)FluidHelpers.getFluidHandlerItemCapacity(itemStackFull).orElse(null);
        fluidHanderFull.fill(new FluidStack(fluid, fluidHanderFull.getCapacity()), IFluidHandler.FluidAction.EXECUTE);
        items.add((Object)itemStackFull);
        ItemStack itemStackEmpty = new ItemStack((IItemProvider)this.item);
        items.add((Object)itemStackEmpty);
    }

    public ITextComponent getInfo(ItemStack itemStack) {
        int amount = 0;
        IFluidHandlerItemCapacity fluidHander = (IFluidHandlerItemCapacity)FluidHelpers.getFluidHandlerItemCapacity(itemStack).orElse(null);
        FluidStack fluidStack = (FluidStack)FluidUtil.getFluidContained((ItemStack)itemStack).orElse(null);
        if (!fluidStack.isEmpty()) {
            amount = fluidStack.getAmount();
        }
        return DamageIndicatedItemComponent.getInfo(fluidStack, amount, fluidHander.getCapacity());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ITextComponent getInfo(FluidStack fluidStack, int amount, int capacity) {
        StringTextComponent prefix = new StringTextComponent("");
        if (fluidStack != null) {
            prefix = new TranslationTextComponent(fluidStack.getTranslationKey(), new Object[0]).func_150258_a(": ");
        }
        return prefix.func_150258_a(String.format("%,d", amount)).func_150258_a(" / ").func_150258_a(String.format("%,d", capacity)).func_150258_a(" mB");
    }

    public void addInformation(ItemStack itemStack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        list.add((ITextComponent)new StringTextComponent(IInformationProvider.ITEM_PREFIX + ((IInformationProvider)itemStack.func_77973_b()).getInfo(itemStack)));
    }

    public double getDurability(ItemStack itemStack) {
        IFluidHandlerItemCapacity fluidHander = (IFluidHandlerItemCapacity)FluidHelpers.getFluidHandlerItemCapacity(itemStack).orElse(null);
        FluidStack fluidStack = (FluidStack)FluidUtil.getFluidContained((ItemStack)itemStack).orElse(null);
        double capacity = fluidHander.getCapacity();
        double amount = FluidHelpers.getAmount(fluidStack);
        return (capacity - amount) / capacity;
    }
}

