/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth;

import java.lang.reflect.Field;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Map;
import technicianlp.reauth.ReAuth;

final class JceWorkaround {
    JceWorkaround() {
    }

    public void removeCryptographyRestrictions() {
        try {
            Class<?> jceSecurity = Class.forName("javax.crypto.JceSecurity");
            Class<?> cryptoPermissions = Class.forName("javax.crypto.CryptoPermissions");
            Class<?> cryptoAllPermission = Class.forName("javax.crypto.CryptoAllPermission");
            this.setFinalField(jceSecurity, "isRestricted", null, true);
            PermissionCollection defaultPolicy = (PermissionCollection)this.getFieldValue(jceSecurity, "defaultPolicy", null);
            ((Map)this.getFieldValue(cryptoPermissions, "perms", defaultPolicy)).clear();
            defaultPolicy.add((Permission)this.getFieldValue(cryptoAllPermission, "INSTANCE", null));
        }
        catch (Exception e) {
            ReAuth.log.error("Exception removing cryptography restrictions", (Throwable)e);
        }
    }

    private <E> E getFieldValue(Class<?> clz, String name, Object target) throws ReflectiveOperationException {
        Field field = clz.getDeclaredField(name);
        field.setAccessible(true);
        return (E)field.get(target);
    }

    private void setFinalField(Class<?> clz, String name, Object target, Object value) throws ReflectiveOperationException {
        Field field = clz.getDeclaredField(name);
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set(target, value);
    }
}

