/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.potionsmaster.render.util.xray;

import com.thevortex.potionsmaster.PotionsMaster;
import com.thevortex.potionsmaster.render.util.BlockStore;
import com.thevortex.potionsmaster.render.util.StructureStore;
import com.thevortex.potionsmaster.render.util.WorldRegion;
import com.thevortex.potionsmaster.render.util.xray.Render;
import com.thevortex.potionsmaster.render.util.xray.RenderEnqueue;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.Vec3i;

public class Controller {
    private static final int[] distanceList = new int[]{8, 16, 32, 48, 64, 80, 128, 256};
    public static ArrayList blackList = new ArrayList<Block>(){
        {
            this.add(Blocks.field_150350_a);
            this.add(Blocks.field_150357_h);
            this.add(Blocks.field_150348_b);
            this.add(Blocks.field_150349_c);
            this.add(Blocks.field_150346_d);
        }
    };
    private static Vec3i lastPlayerPos = null;
    private static Future task;
    private static ExecutorService executor;
    private static boolean drawOres;

    public static BlockStore getBlockStore() {
        return PotionsMaster.blockStore;
    }

    public static StructureStore getStructureStore() {
        return PotionsMaster.structureStore;
    }

    public static boolean drawOres() {
        return drawOres && PotionsMaster.proxy.getClientWorld() != null;
    }

    public static void toggleDrawOres() {
        if (!drawOres) {
            Render.ores.clear();
            Render.structures.clear();
            executor = Executors.newSingleThreadExecutor();
            drawOres = true;
            Controller.requestBlockFinder(true);
        } else {
            Controller.shutdownExecutor();
        }
    }

    public static int getRadius() {
        return distanceList[2];
    }

    public static void incrementCurrentDist() {
    }

    public static void decrementCurrentDist() {
    }

    private static boolean playerHasMoved() {
        if (PotionsMaster.proxy.getClientWorld().func_201672_e() == null) {
            Controller.toggleDrawOres();
            return false;
        }
        return lastPlayerPos == null || lastPlayerPos.func_177958_n() != PotionsMaster.proxy.getClientPlayer().func_180425_c().func_177958_n() || lastPlayerPos.func_177952_p() != PotionsMaster.proxy.getClientPlayer().func_180425_c().func_177952_p();
    }

    private static void updatePlayerPosition() {
        lastPlayerPos = PotionsMaster.proxy.getClientPlayer().func_180425_c();
    }

    public static synchronized void requestBlockFinder(boolean force) {
        if (Controller.drawOres() && (task == null || task.isDone()) && (force || Controller.playerHasMoved())) {
            Controller.updatePlayerPosition();
            WorldRegion region = new WorldRegion(lastPlayerPos, Controller.getRadius());
            task = executor.submit(new RenderEnqueue(region));
        }
    }

    public static void shutdownExecutor() {
        drawOres = false;
        try {
            executor.shutdownNow();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        drawOres = false;
    }
}

