/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.compat.jei;

import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.blay09.mods.farmingforblockheads.api.IMarketEntry;
import net.blay09.mods.farmingforblockheads.block.ModBlocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class MarketCategory
implements IRecipeCategory<IMarketEntry> {
    public static final ResourceLocation UID = new ResourceLocation("farmingforblockheads:market");
    private static final ResourceLocation TEXTURE = new ResourceLocation("farmingforblockheads", "textures/gui/jei_market.png");
    private final IDrawable icon;
    private final IDrawableStatic background;

    public MarketCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.market));
        this.background = guiHelper.createDrawable(TEXTURE, 0, 0, 86, 48);
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends IMarketEntry> getRecipeClass() {
        return IMarketEntry.class;
    }

    public String getTitle() {
        return I18n.func_135052_a((String)("jei." + UID), (Object[])new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(IMarketEntry marketRecipe, IIngredients ingredients) {
        ingredients.setInput(VanillaTypes.ITEM, (Object)marketRecipe.getCostItem());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)marketRecipe.getOutputItem());
    }

    public void setRecipe(IRecipeLayout recipeLayout, IMarketEntry recipeWrapper, IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 15, 12);
        recipeLayout.getItemStacks().set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        recipeLayout.getItemStacks().init(1, false, 53, 12);
        recipeLayout.getItemStacks().set(1, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }

    public void draw(IMarketEntry recipe, double mouseX, double mouseY) {
        String costText = this.getFormattedCostString(recipe);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int stringWidth = fontRenderer.func_78256_a(costText);
        fontRenderer.func_175063_a(costText, 42.0f - (float)stringWidth / 2.0f, 35.0f, 0xFFFFFF);
    }

    private String getFormattedCostString(IMarketEntry entry) {
        String color = TextFormatting.GREEN.toString();
        if (entry.getCostItem().func_77973_b() == Items.field_151045_i) {
            color = TextFormatting.AQUA.toString();
        }
        return color + I18n.func_135052_a((String)"gui.farmingforblockheads:market.cost", (Object[])new Object[]{entry.getCostItem().func_190916_E(), entry.getCostItem().func_200301_q().func_150254_d()});
    }
}

