/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.init;

import java.util.Locale;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.block.craftingstation.CraftingStationContainer;
import net.silentchaos512.gear.block.craftingstation.CraftingStationScreen;
import net.silentchaos512.gear.block.salvager.SalvagerContainer;
import net.silentchaos512.gear.block.salvager.SalvagerScreen;
import net.silentchaos512.utils.Lazy;

public enum ModContainers {
    CRAFTING_STATION(CraftingStationContainer::new),
    SALVAGER(SalvagerContainer::new);

    private final Lazy<ContainerType<?>> type = Lazy.of(() -> new ContainerType(factory));

    private ModContainers(ContainerType.IFactory<?> factory) {
    }

    public ContainerType<?> type() {
        return (ContainerType)this.type.get();
    }

    public static void registerAll(RegistryEvent.Register<ContainerType<?>> event) {
        for (ModContainers container : ModContainers.values()) {
            ModContainers.register(container.name().toLowerCase(Locale.ROOT), container.type());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerScreens(FMLClientSetupEvent event) {
        ScreenManager.func_216911_a(CRAFTING_STATION.type(), CraftingStationScreen::new);
        ScreenManager.func_216911_a(SALVAGER.type(), SalvagerScreen::new);
    }

    private static void register(String name, ContainerType<?> type) {
        ResourceLocation id = SilentGear.getId(name);
        type.setRegistryName(id);
        ForgeRegistries.CONTAINERS.register(type);
    }
}

