/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.silentchaos512.gear.api.material.IPartMaterial;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.stats.StatModifierMap;
import net.silentchaos512.gear.gear.material.MaterialManager;

public final class SGearMaterialsCommand {
    private static final SuggestionProvider<CommandSource> MATERIAL_ID_SUGGESTIONS = (ctx, builder) -> ISuggestionProvider.func_212476_a(MaterialManager.getValues().stream().map(IPartMaterial::getId), (SuggestionsBuilder)builder);
    private static final Pattern FORMAT_CODES = Pattern.compile("\u00a7[0-9a-z]");

    private SGearMaterialsCommand() {
    }

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = Commands.func_197057_a((String)"sgear_mats");
        builder.then(Commands.func_197057_a((String)"list").executes(SGearMaterialsCommand::runList));
        builder.then(Commands.func_197057_a((String)"dump").executes(SGearMaterialsCommand::runDump));
        dispatcher.register(builder);
    }

    private static int runList(CommandContext<CommandSource> context) {
        String listStr = MaterialManager.getValues().stream().map(mat -> mat.getId().toString()).collect(Collectors.joining(", "));
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(listStr), true);
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int runDump(CommandContext<CommandSource> context) {
        String dirPath = "output/silentgear";
        String fileName = "material_export.tsv";
        File output = new File(dirPath, fileName);
        File directory = output.getParentFile();
        if (!directory.exists() && !directory.mkdirs()) {
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new StringTextComponent("Could not create directory: " + output.getParent()));
            return 0;
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(output), StandardCharsets.UTF_8);){
            StringBuilder builder = new StringBuilder("Name\tID\tType\tTier\t");
            ItemStats.allStatsOrdered().forEach(s -> builder.append(s.getDisplayName().func_150254_d()).append("\t"));
            builder.append("Traits\tTexture\tColor");
            writer.write(builder.toString());
            for (IPartMaterial material : MaterialManager.getValues()) {
                for (PartType partType : PartType.getValues()) {
                    if (!material.allowedInPart(partType)) continue;
                    writer.write(SGearMaterialsCommand.makeTsvLine(material, partType) + "\n");
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Wrote to " + output.getAbsolutePath()), true);
        }
        return 1;
    }

    private static String makeTsvLine(IPartMaterial material, PartType partType) {
        StringBuilder builder = new StringBuilder();
        SGearMaterialsCommand.appendTsv(builder, material.getDisplayName(ItemStack.field_190927_a, partType).getString());
        SGearMaterialsCommand.appendTsv(builder, material.getId().toString());
        SGearMaterialsCommand.appendTsv(builder, partType.getName());
        SGearMaterialsCommand.appendTsv(builder, material.getTier(partType));
        for (ItemStat stat : ItemStats.allStatsOrdered()) {
            Collection<StatInstance> statModifiers = material.getStatModifiers(stat, partType);
            SGearMaterialsCommand.appendTsv(builder, FORMAT_CODES.matcher(StatModifierMap.formatText(statModifiers, stat, 5).getString()).replaceAll(""));
        }
        SGearMaterialsCommand.appendTsv(builder, material.getTraits(partType).stream().map(t -> t.getTrait().getDisplayName(t.getLevel()).func_150254_d()).collect(Collectors.joining(", ")));
        SGearMaterialsCommand.appendTsv(builder, (Object)material.getTexture(ItemStack.field_190927_a, partType));
        SGearMaterialsCommand.appendTsv(builder, material.getColor(ItemStack.field_190927_a, partType));
        return builder.toString();
    }

    private static void appendTsv(StringBuilder builder, Object value) {
        builder.append(value).append("\t");
    }

    private static ITextComponent text(String key, Object ... args) {
        return new TranslationTextComponent("command.silentgear.parts." + key, args);
    }
}

