/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.util.GearGenerator;
import net.silentchaos512.lib.util.PlayerUtils;

public final class RandomGearCommand {
    private static final SuggestionProvider<CommandSource> itemIdSuggestions = (context, builder) -> ISuggestionProvider.func_212476_a(ForgeRegistries.ITEMS.getValues().stream().filter(item -> item instanceof ICoreItem).map(ForgeRegistryEntry::getRegistryName), (SuggestionsBuilder)builder);

    private RandomGearCommand() {
    }

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"sgear_random_gear").requires(source -> source.func_197034_c(2))).then(Commands.func_197056_a((String)"players", (ArgumentType)EntityArgument.func_197094_d()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"item", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(itemIdSuggestions).executes(context -> RandomGearCommand.run((CommandContext<CommandSource>)context, EntityArgument.func_197090_e((CommandContext)context, (String)"players"), ResourceLocationArgument.func_197195_e((CommandContext)context, (String)"item"), 3))).then(Commands.func_197056_a((String)"tier", (ArgumentType)IntegerArgumentType.integer()).executes(context -> RandomGearCommand.run((CommandContext<CommandSource>)context, EntityArgument.func_197090_e((CommandContext)context, (String)"players"), ResourceLocationArgument.func_197195_e((CommandContext)context, (String)"item"), IntegerArgumentType.getInteger((CommandContext)context, (String)"tier")))))));
    }

    private static int run(CommandContext<CommandSource> context, Collection<ServerPlayerEntity> players, ResourceLocation itemId, int tier) throws CommandSyntaxException {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(itemId);
        if (!(item instanceof ICoreItem)) {
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("command.silentgear.randomGear.invalidItem", new Object[0]));
            return 0;
        }
        for (ServerPlayerEntity player : players) {
            ItemStack stack = GearGenerator.create((ICoreItem)item, tier);
            if (stack.func_190926_b()) continue;
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.give.success.single", new Object[]{1, stack.func_151000_E(), player.func_145748_c_()}), true);
            PlayerUtils.giveItem((PlayerEntity)player, (ItemStack)stack.func_77946_l());
        }
        return 1;
    }
}

