/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.stats;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.lib.util.Lazy;

public final class ItemStats {
    static final List<ItemStat> STATS_IN_ORDER = new ArrayList<ItemStat>();
    public static final Lazy<IForgeRegistry<ItemStat>> REGISTRY = Lazy.of(() -> new RegistryBuilder().setType(ItemStat.class).setName(SilentGear.getId("stat")).create());
    public static final ItemStat DURABILITY = new ItemStat(1.0f, 1.0f, 2.1474836E9f, TextFormatting.BLUE, new ItemStat.Properties().displayAsInt().affectedByGrades(true).synergyApplies());
    public static final ItemStat ARMOR_DURABILITY = new ItemStat(1.0f, 1.0f, 1.3421773E8f, TextFormatting.BLUE, new ItemStat.Properties().displayAsInt().affectedByGrades(true).synergyApplies());
    public static final ItemStat REPAIR_EFFICIENCY = new ItemStat(1.0f, 0.0f, 1000.0f, TextFormatting.BLUE, new ItemStat.Properties().affectedByGrades(false));
    public static final ItemStat ENCHANTABILITY = new ItemStat(0.0f, 0.0f, 10000.0f, TextFormatting.BLUE, new ItemStat.Properties().displayAsInt().affectedByGrades(true).synergyApplies());
    public static final ItemStat RARITY = new ItemStat(0.0f, 0.0f, 10000.0f, TextFormatting.BLUE, new ItemStat.Properties().displayAsInt().affectedByGrades(true).hidden());
    public static final ItemStat HARVEST_LEVEL = new ItemStat(0.0f, 0.0f, 10000.0f, TextFormatting.YELLOW, new ItemStat.Properties().defaultOp(StatInstance.Operation.MAX).displayAsInt().affectedByGrades(false));
    public static final ItemStat HARVEST_SPEED = new ItemStat(1.0f, 0.0f, 10000.0f, TextFormatting.YELLOW, new ItemStat.Properties().affectedByGrades(true).synergyApplies().missingRodFunction(f -> Float.valueOf(Math.max(2.0f, f.floatValue() / 8.0f))));
    public static final ItemStat REACH_DISTANCE = new ItemStat(0.0f, -100.0f, 100.0f, TextFormatting.YELLOW, new ItemStat.Properties().affectedByGrades(false).missingRodFunction(f -> Float.valueOf(f.floatValue() - 1.5f)));
    public static final ItemStat MELEE_DAMAGE = new ItemStat(0.0f, 0.0f, 10000.0f, TextFormatting.GREEN, new ItemStat.Properties().affectedByGrades(true).synergyApplies().missingRodFunction(f -> Float.valueOf(f.floatValue() / 2.0f)));
    public static final ItemStat MAGIC_DAMAGE = new ItemStat(0.0f, 0.0f, 10000.0f, TextFormatting.GREEN, new ItemStat.Properties().affectedByGrades(true).synergyApplies());
    public static final ItemStat ATTACK_SPEED = new ItemStat(0.0f, -4.0f, 4.0f, TextFormatting.GREEN, new ItemStat.Properties().affectedByGrades(false));
    public static final ItemStat RANGED_DAMAGE = new ItemStat(0.0f, 0.0f, 10000.0f, TextFormatting.AQUA, new ItemStat.Properties().affectedByGrades(true).synergyApplies());
    public static final ItemStat RANGED_SPEED = new ItemStat(0.0f, -10.0f, 10.0f, TextFormatting.AQUA, new ItemStat.Properties().affectedByGrades(false));
    public static final ItemStat ARMOR = new ItemStat(0.0f, 0.0f, 40.0f, TextFormatting.LIGHT_PURPLE, new ItemStat.Properties().affectedByGrades(true).synergyApplies());
    public static final ItemStat ARMOR_TOUGHNESS = new ItemStat(0.0f, 0.0f, 40.0f, TextFormatting.LIGHT_PURPLE, new ItemStat.Properties().affectedByGrades(true).synergyApplies());
    public static final ItemStat MAGIC_ARMOR = new ItemStat(0.0f, 0.0f, 40.0f, TextFormatting.LIGHT_PURPLE, new ItemStat.Properties().affectedByGrades(true).synergyApplies());

    private ItemStats() {
    }

    public static Collection<ItemStat> allStatsOrdered() {
        return Collections.unmodifiableList(STATS_IN_ORDER);
    }

    @Nullable
    public static ItemStat byName(String name) {
        ResourceLocation id = SilentGear.getIdWithDefaultNamespace(name);
        return id != null ? (ItemStat)((IForgeRegistry)REGISTRY.get()).getValue(id) : null;
    }

    public static void createRegistry(RegistryEvent.NewRegistry event) {
        REGISTRY.get();
    }

    public static void registerStats(RegistryEvent.Register<ItemStat> event) {
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), DURABILITY, "durability");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), ARMOR_DURABILITY, "armor_durability");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), REPAIR_EFFICIENCY, "repair_efficiency");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), ENCHANTABILITY, "enchantability");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), RARITY, "rarity");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), HARVEST_LEVEL, "harvest_level");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), HARVEST_SPEED, "harvest_speed");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), REACH_DISTANCE, "reach_distance");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), MELEE_DAMAGE, "melee_damage");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), MAGIC_DAMAGE, "magic_damage");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), ATTACK_SPEED, "attack_speed");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), RANGED_DAMAGE, "ranged_damage");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), RANGED_SPEED, "ranged_speed");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), ARMOR, "armor");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), ARMOR_TOUGHNESS, "armor_toughness");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), MAGIC_ARMOR, "magic_armor");
    }

    private static void register(IForgeRegistry<ItemStat> registry, ItemStat stat, String name) {
        registry.register(stat.setRegistryName(SilentGear.getId(name)));
    }
}

