/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.material;

import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.parts.PartTraitInstance;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.parts.PartTextureType;

public interface IPartMaterial {
    public ResourceLocation getId();

    public int getTier(PartType var1);

    public Ingredient getIngredient(PartType var1);

    public boolean allowedInPart(PartType var1);

    public void retainData(@Nullable IPartMaterial var1);

    public Collection<StatInstance> getStatModifiers(ItemStack var1, ItemStat var2, PartType var3);

    default public Collection<StatInstance> getStatModifiers(ItemStat stat, PartType partType) {
        return this.getStatModifiers(ItemStack.field_190927_a, stat, partType);
    }

    public Collection<PartTraitInstance> getTraits(ItemStack var1, PartType var2);

    default public Collection<PartTraitInstance> getTraits(PartType partType) {
        return this.getTraits(ItemStack.field_190927_a, partType);
    }

    default public float getStat(ItemStat stat, PartType partType) {
        return stat.compute(0.0f, this.getStatModifiers(stat, partType));
    }

    default public float getStatUnclamped(ItemStat stat, PartType partType) {
        return stat.compute(0.0f, false, this.getStatModifiers(stat, partType));
    }

    default public boolean isCraftingAllowed(ICoreItem item, PartType partType) {
        if (partType == PartType.MAIN) {
            return this.getStatUnclamped(item.getDurabilityStat(), partType) > 0.0f;
        }
        return true;
    }

    public int getColor(ItemStack var1, PartType var2);

    public PartTextureType getTexture(ItemStack var1, PartType var2);

    public ITextComponent getDisplayName(ItemStack var1, PartType var2);

    @Nullable
    default public ITextComponent getDisplayNamePrefix(ItemStack gear, PartType partType) {
        return null;
    }

    default public boolean isVisible(PartType partType) {
        return true;
    }

    default public ItemStack getDisplayItem(PartType type, int ticks) {
        ItemStack[] stacks = this.getIngredient(type).func_193365_a();
        if (stacks.length == 0) {
            return ItemStack.field_190927_a;
        }
        return stacks[ticks / 20 % stacks.length];
    }
}

