/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.network;

import com.davenonymous.libnonymous.command.CommandOpenConfigGUI;
import com.davenonymous.libnonymous.gui.config.WidgetGuiConfig;
import com.davenonymous.libnonymous.network.PacketOpenConfigGui;
import java.lang.reflect.Field;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.config.ModConfig;

public class PacketOpenConfigGuiHandler
implements Consumer<PacketOpenConfigGui> {
    private static Field FIELD_MODCONTAINER_CONFIGS;

    protected static EnumMap<ModConfig.Type, ModConfig> getConfigsForModContainer(ModContainer container) {
        try {
            return (EnumMap)FIELD_MODCONTAINER_CONFIGS.get(container);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void openConfigGuiForAll(Screen parent) {
        List<ForgeConfigSpec> configSpecs = ModList.get().getMods().stream().map(m -> ModList.get().getModContainerById(m.getModId())).filter(m -> m.isPresent()).map(m -> PacketOpenConfigGuiHandler.getConfigsForModContainer((ModContainer)m.get())).flatMap(m -> m.values().stream()).map(m -> m.getSpec()).collect(Collectors.toList());
        Minecraft.func_71410_x().func_147108_a((Screen)new WidgetGuiConfig(parent, configSpecs));
    }

    @Override
    public void accept(PacketOpenConfigGui packet) {
        if (packet.all) {
            PacketOpenConfigGuiHandler.openConfigGuiForAll(null);
        } else {
            Optional optContainer = ModList.get().getModContainerById(packet.modId);
            if (optContainer.isPresent()) {
                EnumMap<ModConfig.Type, ModConfig> configs;
                ModContainer modContainer = (ModContainer)optContainer.get();
                if (packet.mode == CommandOpenConfigGUI.Mode.NATIVE) {
                    Optional optExtPoint = modContainer.getCustomExtension(ExtensionPoint.CONFIGGUIFACTORY);
                    if (optExtPoint.isPresent()) {
                        BiFunction configGuiFactory = (BiFunction)optExtPoint.get();
                        Screen screen = (Screen)configGuiFactory.apply(Minecraft.func_71410_x(), null);
                        Minecraft.func_71410_x().func_147108_a(screen);
                    } else {
                        Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent("libnonymous.config.error.no_native_menu_exists", new Object[0]), false);
                    }
                } else if (packet.mode == CommandOpenConfigGUI.Mode.BY_SPEC && (configs = PacketOpenConfigGuiHandler.getConfigsForModContainer(modContainer)) != null) {
                    List<ForgeConfigSpec> configSpecs = configs.values().stream().map(ModConfig::getSpec).collect(Collectors.toList());
                    Minecraft.func_71410_x().func_147108_a((Screen)new WidgetGuiConfig(null, configSpecs));
                }
            }
        }
    }

    static {
        try {
            FIELD_MODCONTAINER_CONFIGS = ModContainer.class.getDeclaredField("configs");
            FIELD_MODCONTAINER_CONFIGS.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }
}

