/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.item.armor;

import info.u_team.u_team_core.api.registry.IURegistryType;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;

public class UArmorItem
extends ArmorItem
implements IURegistryType {
    protected final String typeName;
    protected final String name;

    public UArmorItem(String name, Item.Properties properties, IArmorMaterial material, EquipmentSlotType slot) {
        this(name, null, properties, material, slot);
    }

    public UArmorItem(String name, ItemGroup group, Item.Properties properties, IArmorMaterial material, EquipmentSlotType slot) {
        super(material, slot, group == null ? properties : properties.func_200916_a(group));
        this.typeName = name + "_" + this.getTypeString(slot);
        this.name = name;
    }

    @Override
    public String getEntryName() {
        return this.typeName;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        if (!this.field_200882_e.func_200897_d().equals("invalid")) {
            return null;
        }
        return String.format("%s:textures/models/armor/%s_layer_%d%s.png", this.getRegistryName().func_110624_b(), this.name, slot == EquipmentSlotType.LEGS ? 2 : 1, type == null ? "" : String.format("_%s", type));
    }

    protected String getTypeString(EquipmentSlotType slot) {
        switch (slot) {
            case HEAD: {
                return "helmet";
            }
            case CHEST: {
                return "chestplate";
            }
            case LEGS: {
                return "leggings";
            }
            case FEET: {
                return "boots";
            }
        }
        return "invalid";
    }
}

