/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.intern.recipe;

import com.google.gson.JsonObject;
import info.u_team.u_team_core.intern.init.UCoreRecipeSerializers;
import info.u_team.u_team_core.recipeserializer.UShapedRecipeSerializer;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class NoMirrorShapedRecipe
extends ShapedRecipe {
    public NoMirrorShapedRecipe(ResourceLocation location, String group, int recipeWidth, int recipeHeigt, NonNullList<Ingredient> ingredients, ItemStack output) {
        super(location, group, recipeWidth, recipeHeigt, ingredients, output);
    }

    public boolean func_77569_a(CraftingInventory inventory, World world) {
        for (int i = 0; i <= inventory.func_174922_i() - this.func_192403_f(); ++i) {
            for (int j = 0; j <= inventory.func_174923_h() - this.func_192404_g(); ++j) {
                if (!this.func_77573_a(inventory, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return UCoreRecipeSerializers.NO_MIRROR_SHAPED;
    }

    public static class Serializer
    extends UShapedRecipeSerializer<NoMirrorShapedRecipe> {
        public Serializer(String name) {
            super(name);
        }

        public NoMirrorShapedRecipe read(ResourceLocation location, JsonObject json) {
            String[] pattern = Serializer.patternFromJson(JSONUtils.func_151214_t((JsonObject)json, (String)"pattern"));
            int recipeWidth = pattern[0].length();
            int recipeHeight = pattern.length;
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> ingredients = Serializer.deserializeIngredients(pattern, Serializer.deserializeKey(JSONUtils.func_152754_s((JsonObject)json, (String)"key")), recipeWidth, recipeHeight);
            ItemStack output = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            return new NoMirrorShapedRecipe(location, group, recipeWidth, recipeHeight, ingredients, output);
        }

        public NoMirrorShapedRecipe read(ResourceLocation location, PacketBuffer buffer) {
            int recipeWidth = buffer.func_150792_a();
            int recipeHeight = buffer.func_150792_a();
            String group = buffer.func_150789_c(Short.MAX_VALUE);
            NonNullList ingredients = NonNullList.func_191197_a((int)(recipeWidth * recipeHeight), (Object)Ingredient.field_193370_a);
            for (int k = 0; k < ingredients.size(); ++k) {
                ingredients.set(k, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            ItemStack output = buffer.func_150791_c();
            return new NoMirrorShapedRecipe(location, group, recipeWidth, recipeHeight, (NonNullList<Ingredient>)ingredients, output);
        }

        public void write(PacketBuffer buffer, NoMirrorShapedRecipe recipe) {
            buffer.func_150787_b(recipe.getRecipeWidth());
            buffer.func_150787_b(recipe.getRecipeHeight());
            buffer.func_180714_a(recipe.func_193358_e());
            for (Ingredient ingredient : recipe.func_192400_c()) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_150788_a(recipe.func_77571_b());
        }
    }
}

