/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.entitytype;

import info.u_team.u_team_core.UCoreMain;
import info.u_team.u_team_core.api.registry.IURegistryType;
import java.lang.reflect.Method;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.network.FMLPlayMessages;

public class UEntityType<T extends Entity>
extends EntityType<T>
implements IURegistryType {
    protected final String field_212547_aX;
    protected final BiFunction<EntityType<T>, World, T> clientFactory;

    protected UEntityType(String name, EntityType.IFactory<T> factory, EntityClassification classification, boolean serializable, boolean summonable, boolean immuneToFire, boolean spawnable, EntitySize size, Predicate<EntityType<?>> velocityUpdateSupplier, ToIntFunction<EntityType<?>> trackingRangeSupplier, ToIntFunction<EntityType<?>> updateIntervalSupplier, BiFunction<EntityType<T>, World, T> clientFactory) {
        super(factory, classification, serializable, summonable, immuneToFire, spawnable, size, velocityUpdateSupplier, trackingRangeSupplier, updateIntervalSupplier, null);
        this.field_212547_aX = name;
        this.clientFactory = clientFactory;
    }

    public T customClientSpawn(FMLPlayMessages.SpawnEntity packet, World world) {
        if (this.clientFactory != null) {
            return (T)((Entity)this.clientFactory.apply(this, world));
        }
        return (T)super.customClientSpawn(packet, world);
    }

    @Override
    public String getEntryName() {
        return this.field_212547_aX;
    }

    public static class UBuilder<T extends Entity> {
        private static final Method DEFAULT_VELOCITY_SUPPLIER_METHOD = ObfuscationReflectionHelper.findMethod(EntityType.class, (String)"defaultVelocitySupplier", (Class[])new Class[0]);
        private static final Method DEFAULT_TRACKING_RANGE_SUPPLIER_METHOD = ObfuscationReflectionHelper.findMethod(EntityType.class, (String)"defaultTrackingRangeSupplier", (Class[])new Class[0]);
        private static final Method DEFAULT_UPDATE_INTERVAL_SUPPLIER_METHOD = ObfuscationReflectionHelper.findMethod(EntityType.class, (String)"defaultUpdateIntervalSupplier", (Class[])new Class[0]);
        private final String name;
        private final EntityType.IFactory<T> factory;
        private final EntityClassification classification;
        private boolean serializable = true;
        private boolean summonable = true;
        private boolean immuneToFire;
        private Predicate<EntityType<?>> velocityUpdateSupplier;
        private ToIntFunction<EntityType<?>> trackingRangeSupplier;
        private ToIntFunction<EntityType<?>> updateIntervalSupplier;
        private BiFunction<EntityType<T>, World, T> clientFactory;
        private boolean spawnable;
        private EntitySize size = EntitySize.func_220314_b((float)0.6f, (float)1.8f);

        protected UBuilder(String name, EntityType.IFactory<T> factory, EntityClassification classification) {
            this.name = name;
            this.factory = factory;
            this.clientFactory = (arg_0, arg_1) -> factory.create(arg_0, arg_1);
            this.classification = classification;
        }

        public static <T extends Entity> UBuilder<T> create(String name, EntityType.IFactory<T> factory, EntityClassification classification) {
            return new UBuilder<T>(name, factory, classification);
        }

        public UBuilder<T> size(float width, float height) {
            this.size = EntitySize.func_220314_b((float)width, (float)height);
            return this;
        }

        public UBuilder<T> disableSummoning() {
            this.summonable = false;
            return this;
        }

        public UBuilder<T> disableSerialization() {
            this.serializable = false;
            return this;
        }

        public UBuilder<T> immuneToFire() {
            this.immuneToFire = true;
            return this;
        }

        public UBuilder<T> setUpdateInterval(int interval) {
            this.updateIntervalSupplier = type -> interval;
            return this;
        }

        public UBuilder<T> setTrackingRange(int range) {
            this.trackingRangeSupplier = type -> range;
            return this;
        }

        public UBuilder<T> setShouldReceiveVelocityUpdates(boolean value) {
            this.velocityUpdateSupplier = type -> value;
            return this;
        }

        public UBuilder<T> setCustomClientFactory(BiFunction<EntityType<T>, World, T> clientFactory) {
            this.clientFactory = clientFactory;
            return this;
        }

        public UBuilder<T> setSpawnable() {
            this.spawnable = true;
            return this;
        }

        public UEntityType<T> build() {
            if (this.velocityUpdateSupplier == null) {
                this.velocityUpdateSupplier = type -> (Boolean)this.getPrivateDefaultValue((EntityType<?>)type, DEFAULT_VELOCITY_SUPPLIER_METHOD);
            }
            if (this.trackingRangeSupplier == null) {
                this.trackingRangeSupplier = type -> (Integer)this.getPrivateDefaultValue((EntityType<?>)type, DEFAULT_TRACKING_RANGE_SUPPLIER_METHOD);
            }
            if (this.updateIntervalSupplier == null) {
                this.updateIntervalSupplier = type -> (Integer)this.getPrivateDefaultValue((EntityType<?>)type, DEFAULT_UPDATE_INTERVAL_SUPPLIER_METHOD);
            }
            return new UEntityType<T>(this.name, this.factory, this.classification, this.serializable, this.summonable, this.immuneToFire, this.spawnable, this.size, this.velocityUpdateSupplier, this.trackingRangeSupplier, this.updateIntervalSupplier, this.clientFactory);
        }

        private <D> D getPrivateDefaultValue(EntityType<?> type, Method method) {
            try {
                return (D)method.invoke(type, new Object[0]);
            }
            catch (Exception ex) {
                UCoreMain.LOGGER.error("Could not get default values for entity type {}.", (Object)this.name, (Object)ex);
                return null;
            }
        }
    }
}

