/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.container;

import info.u_team.u_team_core.api.sync.BufferReferenceHolder;
import info.u_team.u_team_core.intern.init.UCoreNetwork;
import info.u_team.u_team_core.intern.network.BufferPropertyContainerMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public abstract class UContainer
extends Container {
    private final List<BufferReferenceHolder> syncServerToClient = new ArrayList<BufferReferenceHolder>();
    private final List<BufferReferenceHolder> syncClientToServer = new ArrayList<BufferReferenceHolder>();

    public UContainer(ContainerType<?> type, int id) {
        super(type, id);
    }

    protected <E extends BufferReferenceHolder> E addServerToClientTracker(E holder) {
        this.syncServerToClient.add(holder);
        return holder;
    }

    protected <E extends BufferReferenceHolder> E addClientToServerTracker(E holder) {
        this.syncClientToServer.add(holder);
        return holder;
    }

    public void updateValue(BufferPropertyContainerMessage message, LogicalSide side) {
        int property = message.getProperty();
        PacketBuffer buffer = message.getBuffer();
        if (side == LogicalSide.CLIENT) {
            this.syncServerToClient.get(property).set(buffer);
        } else if (side == LogicalSide.SERVER) {
            this.syncClientToServer.get(property).set(buffer);
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        List networkManagers = this.field_75149_d.stream().filter(listener -> listener instanceof ServerPlayerEntity).map(listener -> ((ServerPlayerEntity)listener).field_71135_a.func_147298_b()).collect(Collectors.toList());
        this.getDirtyMap(this.syncServerToClient).forEach((property, holder) -> UCoreNetwork.NETWORK.send(PacketDistributor.NMLIST.with(() -> networkManagers), (Object)new BufferPropertyContainerMessage(this.field_75152_c, (int)property, holder.get())));
    }

    public void updateTrackedServerToClient() {
        this.getDirtyMap(this.syncClientToServer).forEach((property, holder) -> UCoreNetwork.NETWORK.send(PacketDistributor.SERVER.noArg(), (Object)new BufferPropertyContainerMessage(this.field_75152_c, (int)property, holder.get())));
    }

    private Map<Integer, BufferReferenceHolder> getDirtyMap(List<BufferReferenceHolder> list) {
        return IntStream.range(0, list.size()).filter(index -> ((BufferReferenceHolder)list.get(index)).isDirty()).boxed().collect(Collectors.toMap(Function.identity(), index -> (BufferReferenceHolder)list.get((int)index)));
    }

    public boolean func_75145_c(PlayerEntity player) {
        return true;
    }

    protected void appendPlayerInventory(PlayerInventory playerInventory, int x, int y) {
        for (int height = 0; height < 4; ++height) {
            for (int width = 0; width < 9; ++width) {
                if (height == 3) {
                    this.func_75146_a(new Slot((IInventory)playerInventory, width, width * 18 + x, height * 18 + 4 + y));
                    continue;
                }
                this.func_75146_a(new Slot((IInventory)playerInventory, width + height * 9 + 9, width * 18 + x, height * 18 + y));
            }
        }
    }

    protected void appendInventory(IInventory inventory, int inventoryHeight, int inventoryWidth, int x, int y) {
        this.appendInventory(inventory, Slot::new, inventoryHeight, inventoryWidth, x, y);
    }

    protected void appendInventory(IInventory inventory, SlotInventoryFunction function, int inventoryHeight, int inventoryWidth, int x, int y) {
        for (int height = 0; height < inventoryHeight; ++height) {
            for (int width = 0; width < inventoryWidth; ++width) {
                this.func_75146_a(function.getSlot(inventory, width + height * inventoryWidth, width * 18 + x, height * 18 + y));
            }
        }
    }

    protected void appendInventory(IItemHandler handler, int inventoryHeight, int inventoryWidth, int x, int y) {
        this.appendInventory(handler, SlotItemHandler::new, inventoryHeight, inventoryWidth, x, y);
    }

    protected void appendInventory(IItemHandler handler, SlotHandlerFunction function, int inventoryHeight, int inventoryWidth, int x, int y) {
        for (int height = 0; height < inventoryHeight; ++height) {
            for (int width = 0; width < inventoryWidth; ++width) {
                this.func_75146_a(function.getSlot(handler, width + height * inventoryWidth, width * 18 + x, height * 18 + y));
            }
        }
    }

    @FunctionalInterface
    public static interface SlotHandlerFunction {
        public Slot getSlot(IItemHandler var1, int var2, int var3, int var4);
    }

    @FunctionalInterface
    public static interface SlotInventoryFunction {
        public Slot getSlot(IInventory var1, int var2, int var3, int var4);
    }
}

