/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.automation.block;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RedstoneDiodeBlock;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.TickPriority;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.arl.interf.IBlockColorProvider;
import vazkii.quark.automation.block.RedstoneRandomizerBlock;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.handler.RenderLayerHandler;
import vazkii.quark.base.module.Module;

public class RedstoneInductorBlock
extends QuarkBlock
implements IBlockColorProvider {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty LOCKED = BlockStateProperties.field_208191_r;
    public static final IntegerProperty POWER = BlockStateProperties.field_208136_ak;

    public RedstoneInductorBlock(String regname, Module module, ItemGroup creativeTab, Block.Properties properties) {
        super(regname, module, creativeTab, properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)LOCKED, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)POWER, (Comparable)Integer.valueOf(0)));
        RenderLayerHandler.setRenderType((Block)this, RenderLayerHandler.RenderTypeSkeleton.CUTOUT);
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        int power;
        int currentPower;
        if (!this.isLocked((IWorldReader)world, pos, state) && (currentPower = ((Integer)state.func_177229_b((IProperty)POWER)).intValue()) != (power = this.calculateInputStrength((World)world, pos, state))) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)POWER, (Comparable)Integer.valueOf(power)));
        }
    }

    protected void updateState(World world, BlockPos pos, BlockState state) {
        int power;
        int currentPower;
        if (!this.isLocked((IWorldReader)world, pos, state) && (currentPower = ((Integer)state.func_177229_b((IProperty)POWER)).intValue()) != (power = this.calculateInputStrength(world, pos, state)) && !world.func_205220_G_().func_205361_b(pos, (Object)this)) {
            TickPriority priority = power > 0 ? TickPriority.VERY_HIGH : TickPriority.HIGH;
            world.func_205220_G_().func_205362_a(pos, (Object)this, 1, priority);
        }
    }

    protected boolean isLocked(IWorldReader world, BlockPos pos, BlockState state) {
        return this.getPowerOnSides(world, pos, state) > 0;
    }

    protected int getPowerOnSides(IWorldReader worldIn, BlockPos pos, BlockState state) {
        Direction direction = (Direction)state.func_177229_b((IProperty)FACING);
        Direction direction1 = direction.func_176746_e();
        Direction direction2 = direction.func_176735_f();
        return Math.max(this.getPowerOnSide(worldIn, pos.func_177972_a(direction1), direction1), this.getPowerOnSide(worldIn, pos.func_177972_a(direction2), direction2));
    }

    protected int getPowerOnSide(IWorldReader worldIn, BlockPos pos, Direction side) {
        BlockState state = worldIn.func_180495_p(pos);
        return RedstoneDiodeBlock.func_185546_B((BlockState)state) ? worldIn.func_175627_a(pos, side) : 0;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, LOCKED, POWER});
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return RedstoneInductorBlock.func_220064_c((IBlockReader)world, (BlockPos)pos.func_177977_b());
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return blockState.func_185911_a(blockAccess, pos, side);
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return blockState.func_177229_b((IProperty)FACING) == side ? (Integer)blockState.func_177229_b((IProperty)POWER) : 0;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (state.func_196955_c((IWorldReader)world, pos)) {
            this.updateState(world, pos, state);
        } else {
            RedstoneRandomizerBlock.breakAndDrop((Block)this, state, world, pos);
        }
    }

    protected int calculateInputStrength(World world, BlockPos pos, BlockState state) {
        Direction face = (Direction)state.func_177229_b((IProperty)FACING);
        return Math.min(15, this.calculateInputStrength(world, pos, face) + this.calculateInputStrength(world, pos, face.func_176735_f()) + this.calculateInputStrength(world, pos, face.func_176746_e()));
    }

    protected int calculateInputStrength(World world, BlockPos pos, Direction face) {
        BlockPos checkPos = pos.func_177972_a(face);
        int strength = world.func_175651_c(checkPos, face);
        if (strength >= 15) {
            return strength;
        }
        BlockState checkState = world.func_180495_p(checkPos);
        return Math.max(strength, checkState.func_177230_c() == Blocks.field_150488_af ? (Integer)checkState.func_177229_b((IProperty)RedstoneWireBlock.field_176351_O) : 0);
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176734_d());
        return (BlockState)state.func_206870_a((IProperty)LOCKED, (Comparable)Boolean.valueOf(this.isLocked((IWorldReader)context.func_195991_k(), context.func_195995_a(), state)));
    }

    @Nonnull
    public BlockState func_196271_a(@Nonnull BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !worldIn.func_201670_d() && facing.func_176740_k() != ((Direction)stateIn.func_177229_b((IProperty)FACING)).func_176740_k() ? (BlockState)stateIn.func_206870_a((IProperty)LOCKED, (Comparable)Boolean.valueOf(this.isLocked((IWorldReader)worldIn, currentPos, stateIn))) : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (this.calculateInputStrength(world, pos, state) > 0) {
            world.func_205220_G_().func_205360_a(pos, (Object)this, 1);
        }
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        RedstoneRandomizerBlock.notifyNeighbors((Block)this, world, pos, state);
    }

    public void func_196243_a(BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (!isMoving && state.func_177230_c() != newState.func_177230_c()) {
            super.func_196243_a(state, world, pos, newState, false);
            RedstoneRandomizerBlock.notifyNeighbors((Block)this, world, pos, state);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if ((Integer)stateIn.func_177229_b((IProperty)POWER) != 0) {
            double x = (double)((float)pos.func_177958_n() + 0.5f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double y = (double)((float)pos.func_177956_o() + 0.4f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double z = (double)((float)pos.func_177952_p() + 0.5f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            float power = (float)((Integer)stateIn.func_177229_b((IProperty)POWER)).intValue() / 15.0f;
            float r = power * 0.6f + 0.4f;
            float g = Math.max(0.0f, power * power * 0.7f - 0.5f);
            float b = Math.max(0.0f, power * power * 0.6f - 0.7f);
            worldIn.func_195594_a((IParticleData)new RedstoneParticleData(r, g, b, 1.0f), x, y, z, 0.0, 0.0, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public IBlockColor getBlockColor() {
        return (state, world, pos, index) -> index == 1 ? RedstoneWireBlock.func_176337_b((int)((Integer)state.func_177229_b((IProperty)POWER))) : -1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public IItemColor getItemColor() {
        return null;
    }
}

