/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.detail;

import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import wile.rsgauges.ModRsGauges;
import wile.rsgauges.detail.OverlayEventHandler;

public class Networking {
    private static final String PROTOCOL = "1";
    private static final SimpleChannel DEFAULT_CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("rsgauges", "default_ch")).clientAcceptedVersions("1"::equals).serverAcceptedVersions("1"::equals).networkProtocolVersion(() -> "1").simpleChannel();

    public static void init() {
        int discr = -1;
        DEFAULT_CHANNEL.registerMessage(++discr, PacketTileNotifyClientToServer.class, PacketTileNotifyClientToServer::compose, PacketTileNotifyClientToServer::parse, PacketTileNotifyClientToServer.Handler::handle);
        DEFAULT_CHANNEL.registerMessage(++discr, PacketTileNotifyServerToClient.class, PacketTileNotifyServerToClient::compose, PacketTileNotifyServerToClient::parse, PacketTileNotifyServerToClient.Handler::handle);
        DEFAULT_CHANNEL.registerMessage(++discr, OverlayTextMessage.class, OverlayTextMessage::compose, OverlayTextMessage::parse, OverlayTextMessage.Handler::handle);
    }

    public static class OverlayTextMessage {
        public static final int DISPLAY_TIME_MS = 3000;
        public static final byte MESSAGE_ID = 44;
        private ITextComponent data_;

        private ITextComponent data() {
            return this.data_;
        }

        public static void sendToPlayer(PlayerEntity player, ITextComponent message) {
            if (!(player instanceof ServerPlayerEntity) || player instanceof FakePlayer) {
                return;
            }
            DEFAULT_CHANNEL.sendTo((Object)new OverlayTextMessage(message), ((ServerPlayerEntity)player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }

        public OverlayTextMessage() {
            this.data_ = new TranslationTextComponent("[unset]", new Object[0]);
        }

        public OverlayTextMessage(ITextComponent tct) {
            this.data_ = tct.func_212638_h();
        }

        public static OverlayTextMessage parse(PacketBuffer buf) {
            try {
                return new OverlayTextMessage(buf.func_179258_d());
            }
            catch (Throwable e) {
                return new OverlayTextMessage((ITextComponent)new TranslationTextComponent("[incorrect translation]", new Object[0]));
            }
        }

        public static void compose(OverlayTextMessage pkt, PacketBuffer buf) {
            try {
                buf.func_179256_a(pkt.data());
            }
            catch (Throwable e) {
                ModRsGauges.logger().error("OverlayTextMessage.toBytes() failed: " + e.toString());
            }
        }

        public static class Handler {
            public static void handle(OverlayTextMessage pkt, Supplier<NetworkEvent.Context> ctx) {
                ctx.get().enqueueWork(() -> OverlayEventHandler.show(pkt.data(), 3000));
                ctx.get().setPacketHandled(true);
            }
        }
    }

    public static class PacketTileNotifyServerToClient {
        CompoundNBT nbt = null;
        BlockPos pos = BlockPos.field_177992_a;

        public static void sendToPlayer(PlayerEntity player, TileEntity te, CompoundNBT nbt) {
            if (!(player instanceof ServerPlayerEntity) || player instanceof FakePlayer || te == null || nbt == null) {
                return;
            }
            DEFAULT_CHANNEL.sendTo((Object)new PacketTileNotifyServerToClient(te, nbt), ((ServerPlayerEntity)player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }

        public PacketTileNotifyServerToClient() {
        }

        public PacketTileNotifyServerToClient(BlockPos pos, CompoundNBT nbt) {
            this.nbt = nbt;
            this.pos = pos;
        }

        public PacketTileNotifyServerToClient(TileEntity te, CompoundNBT nbt) {
            this.nbt = nbt;
            this.pos = te.func_174877_v();
        }

        public static PacketTileNotifyServerToClient parse(PacketBuffer buf) {
            return new PacketTileNotifyServerToClient(buf.func_179259_c(), buf.func_150793_b());
        }

        public static void compose(PacketTileNotifyServerToClient pkt, PacketBuffer buf) {
            buf.func_179255_a(pkt.pos);
            buf.func_150786_a(pkt.nbt);
        }

        public static class Handler {
            public static void handle(PacketTileNotifyServerToClient pkt, Supplier<NetworkEvent.Context> ctx) {
                ctx.get().enqueueWork(() -> {
                    World world = ModRsGauges.proxy.getWorldClientSide();
                    if (world == null) {
                        return;
                    }
                    TileEntity te = world.func_175625_s(pkt.pos);
                    if (!(te instanceof IPacketTileNotifyReceiver)) {
                        return;
                    }
                    ((IPacketTileNotifyReceiver)te).onServerPacketReceived(pkt.nbt);
                });
                ctx.get().setPacketHandled(true);
            }
        }
    }

    public static class PacketTileNotifyClientToServer {
        CompoundNBT nbt = null;
        BlockPos pos = BlockPos.field_177992_a;

        public static void sendToServer(BlockPos pos, CompoundNBT nbt) {
            if (pos != null && nbt != null) {
                DEFAULT_CHANNEL.sendToServer((Object)new PacketTileNotifyClientToServer(pos, nbt));
            }
        }

        public static void sendToServer(TileEntity te, CompoundNBT nbt) {
            if (te != null && nbt != null) {
                DEFAULT_CHANNEL.sendToServer((Object)new PacketTileNotifyClientToServer(te, nbt));
            }
        }

        public PacketTileNotifyClientToServer() {
        }

        public PacketTileNotifyClientToServer(BlockPos pos, CompoundNBT nbt) {
            this.nbt = nbt;
            this.pos = pos;
        }

        public PacketTileNotifyClientToServer(TileEntity te, CompoundNBT nbt) {
            this.nbt = nbt;
            this.pos = te.func_174877_v();
        }

        public static PacketTileNotifyClientToServer parse(PacketBuffer buf) {
            return new PacketTileNotifyClientToServer(buf.func_179259_c(), buf.func_150793_b());
        }

        public static void compose(PacketTileNotifyClientToServer pkt, PacketBuffer buf) {
            buf.func_179255_a(pkt.pos);
            buf.func_150786_a(pkt.nbt);
        }

        public static class Handler {
            public static void handle(PacketTileNotifyClientToServer pkt, Supplier<NetworkEvent.Context> ctx) {
                ctx.get().enqueueWork(() -> {
                    ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                    World world = player.field_70170_p;
                    if (world == null) {
                        return;
                    }
                    TileEntity te = world.func_175625_s(pkt.pos);
                    if (!(te instanceof IPacketTileNotifyReceiver)) {
                        return;
                    }
                    ((IPacketTileNotifyReceiver)te).onClientPacketReceived((PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender(), pkt.nbt);
                });
                ctx.get().setPacketHandled(true);
            }
        }
    }

    public static interface IPacketTileNotifyReceiver {
        default public void onServerPacketReceived(CompoundNBT nbt) {
        }

        default public void onClientPacketReceived(PlayerEntity player, CompoundNBT nbt) {
        }
    }
}

