/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.api.module;

import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ModuleType<T>
extends ForgeRegistryEntry<ModuleType<?>> {
    private final Function<ResourceLocation, T> loadValue;
    private final Supplier<Collection<T>> getValues;
    private String translationKey;
    private ITextComponent name;

    public ModuleType(Function<ResourceLocation, T> loadValue, Supplier<Collection<T>> getValues) {
        this.loadValue = loadValue;
        this.getValues = getValues;
    }

    @Nonnull
    public String getTranslationKey() {
        if (this.translationKey == null) {
            this.translationKey = Util.func_200697_a((String)"component_type", (ResourceLocation)this.getRegistryName());
        }
        return this.translationKey;
    }

    @Nonnull
    public ITextComponent getDisplayName() {
        if (this.name == null) {
            this.name = new TranslationTextComponent(this.getTranslationKey(), new Object[0]);
        }
        return this.name;
    }

    public String getName() {
        return Optional.ofNullable(this.getRegistryName()).map(ResourceLocation::func_110623_a).orElseThrow(() -> new IllegalStateException("No Registry Name Found"));
    }

    public T load(String registryName) {
        return this.load(new ResourceLocation(registryName));
    }

    public T load(ResourceLocation registryName) {
        return this.loadValue.apply(registryName);
    }

    public Collection<T> getValues() {
        return this.getValues.get();
    }
}

