/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.packingtape;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigValues {
    public static final ServerConfig SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static Set<TileEntityType<?>> whiteList;
    public static Set<TileEntityType<?>> blackList;
    public static int tapeRollUses;
    public static boolean consumesPaper;

    public static void bake() {
        whiteList = ((List)ConfigValues.SERVER.whitelist.get()).stream().map(n -> (TileEntityType)ForgeRegistries.TILE_ENTITIES.getValue(new ResourceLocation(n))).collect(Collectors.toSet());
        blackList = ((List)ConfigValues.SERVER.blacklist.get()).stream().map(n -> (TileEntityType)ForgeRegistries.TILE_ENTITIES.getValue(new ResourceLocation(n))).collect(Collectors.toSet());
        blackList.addAll(ConfigValues.getDefaultVanillaDisabled());
        tapeRollUses = (Integer)ConfigValues.SERVER.tapeRollUses.get();
        consumesPaper = (Boolean)ConfigValues.SERVER.consumesPaper.get();
    }

    public static Set<TileEntityType<?>> getDefaultVanillaDisabled() {
        return Sets.newHashSet((Object[])new TileEntityType[]{TileEntityType.field_200992_w, TileEntityType.field_200990_u, TileEntityType.field_222487_E, TileEntityType.field_200978_i, TileEntityType.field_200983_n, TileEntityType.field_200991_v, TileEntityType.field_200985_p, TileEntityType.field_205166_z, TileEntityType.field_200989_t, TileEntityType.field_200988_s, TileEntityType.field_200986_q, TileEntityType.field_200980_k, TileEntityType.field_200982_m, TileEntityType.field_200994_y, TileEntityType.field_222486_D});
    }

    public static boolean isTileEntityAllowed(TileEntity te) {
        TileEntityType type = te.func_200662_C();
        if (whiteList.contains(type)) {
            return true;
        }
        if (te.func_183000_F()) {
            return false;
        }
        return !blackList.contains(type);
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair.getRight();
        SERVER = (ServerConfig)specPair.getLeft();
        whiteList = Sets.newHashSet();
        blackList = Sets.newHashSet();
        tapeRollUses = 8;
        consumesPaper = true;
    }

    public static class ServerConfig {
        public ForgeConfigSpec.ConfigValue<List<? extends String>> whitelist;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> blacklist;
        public ForgeConfigSpec.IntValue tapeRollUses;
        public ForgeConfigSpec.BooleanValue consumesPaper;

        ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.push("general");
            this.whitelist = builder.comment(new String[]{"TileEntities to allow regardless of the blacklist and vanilla restrictions.", "WARNING: This whitelist bypasses the 'only ops can copy' limitation of Minecraft, which can result in security issues, don't whitelist things unless you know what the side-effects will be.", "NOTE: This list now uses 'Block Entity Type' IDs. Eg. the spawner is 'minecraft:mob_spawner'."}).translation("text.packingtape.config.whitelist").defineList("whitelist", (List)Lists.newArrayList(), o -> o instanceof String);
            this.blacklist = builder.comment(new String[]{"TileEntities to disallow (whitelist takes precedence)", "NOTE: This list now uses 'Block Entity Type' IDs. Eg. the shulker boxes are 'minecraft:shulker_box'."}).translation("text.packingtape.config.blacklist").defineList("blacklist", (List)Lists.newArrayList(), o -> o instanceof String);
            this.tapeRollUses = builder.comment("How many times the tape roll can be used before it breaks").translation("text.packingtape.config.tape_roll_uses").defineInRange("tape_roll_uses", 8, 0, 0x7FFFFFFE);
            this.consumesPaper = builder.comment("Whether the tape roll consumes paper when used").translation("text.packingtape.config.consume_paper").define("consume_paper", true);
            builder.pop();
        }
    }
}

