/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.lex.cfd;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootParameterSet;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.ValidationTracker;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ExistingFileHelper;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.lex.cfd.CobbleForDays;

@Mod.EventBusSubscriber(modid="cobblefordays", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataCreator {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            gen.func_200390_a((IDataProvider)new Recipes(gen));
            gen.func_200390_a((IDataProvider)new Loots(gen));
        }
        if (event.includeClient()) {
            gen.func_200390_a((IDataProvider)new Language(gen));
            gen.func_200390_a((IDataProvider)new BlockStates(gen, helper));
            gen.func_200390_a((IDataProvider)new ItemModels(gen, helper));
        }
    }

    private static class BlockStates
    extends BlockStateProvider {
        public BlockStates(DataGenerator gen, ExistingFileHelper helper) {
            super(gen, "cobblefordays", helper);
        }

        protected void registerStatesAndModels() {
            this.makeTier((Block)CobbleForDays.TIER1_BLOCK.get(), this.mcLoc("block/acacia_log"));
            this.makeTier((Block)CobbleForDays.TIER2_BLOCK.get(), this.mcLoc("block/cobblestone"));
            this.makeTier((Block)CobbleForDays.TIER3_BLOCK.get(), this.mcLoc("block/iron_block"));
            this.makeTier((Block)CobbleForDays.TIER4_BLOCK.get(), this.mcLoc("block/gold_block"));
            this.makeTier((Block)CobbleForDays.TIER5_BLOCK.get(), this.mcLoc("block/diamond_block"));
        }

        private void makeTier(Block block, ResourceLocation texture) {
            ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(block.getRegistryName().func_110623_a())).parent((ModelFile)this.models().getExistingFile(this.modLoc("block/generator")))).texture("material", texture);
            this.getVariantBuilder(block).forAllStates(arg_0 -> BlockStates.lambda$makeTier$0((ModelFile)model, arg_0));
        }

        private static /* synthetic */ ConfiguredModel[] lambda$makeTier$0(ModelFile model, BlockState state) {
            return ConfiguredModel.builder().modelFile(model).build();
        }
    }

    private static class ItemModels
    extends ItemModelProvider {
        public ItemModels(DataGenerator gen, ExistingFileHelper helper) {
            super(gen, "cobblefordays", helper);
        }

        protected void registerModels() {
            this.makeTier((Block)CobbleForDays.TIER1_BLOCK.get());
            this.makeTier((Block)CobbleForDays.TIER2_BLOCK.get());
            this.makeTier((Block)CobbleForDays.TIER3_BLOCK.get());
            this.makeTier((Block)CobbleForDays.TIER4_BLOCK.get());
            this.makeTier((Block)CobbleForDays.TIER5_BLOCK.get());
        }

        private void makeTier(Block block) {
            String path = block.getRegistryName().func_110623_a();
            ((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + path)));
        }

        public String func_200397_b() {
            return "Item Models";
        }
    }

    private static class Language
    extends LanguageProvider {
        public Language(DataGenerator gen) {
            super(gen, "cobblefordays", "en_us");
        }

        protected void addTranslations() {
            this.add((Block)CobbleForDays.TIER1_BLOCK.get(), "Cobble Gen Tier1");
            this.add((Block)CobbleForDays.TIER2_BLOCK.get(), "Cobble Gen Tier2");
            this.add((Block)CobbleForDays.TIER3_BLOCK.get(), "Cobble Gen Tier3");
            this.add((Block)CobbleForDays.TIER4_BLOCK.get(), "Cobble Gen Tier4");
            this.add((Block)CobbleForDays.TIER5_BLOCK.get(), "Cobble Gen Tier5");
        }
    }

    private static class Loots
    extends LootTableProvider {
        public Loots(DataGenerator gen) {
            super(gen);
        }

        protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
            return ImmutableList.of((Object)Pair.of(() -> new Blocks(), (Object)LootParameterSets.field_216267_h));
        }

        protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationresults) {
            map.forEach((name, table) -> LootTableManager.func_227508_a_((ValidationTracker)validationresults, (ResourceLocation)name, (LootTable)table));
        }

        private class Blocks
        extends BlockLootTables {
            private Blocks() {
            }

            protected void addTables() {
                this.func_218492_c((Block)CobbleForDays.TIER1_BLOCK.get());
                this.func_218492_c((Block)CobbleForDays.TIER2_BLOCK.get());
                this.func_218492_c((Block)CobbleForDays.TIER3_BLOCK.get());
                this.func_218492_c((Block)CobbleForDays.TIER4_BLOCK.get());
                this.func_218492_c((Block)CobbleForDays.TIER5_BLOCK.get());
            }

            protected Iterable<Block> getKnownBlocks() {
                return CobbleForDays.BLOCKS.getEntries().stream().map(RegistryObject::get)::iterator;
            }
        }
    }

    private static class Recipes
    extends RecipeProvider {
        public Recipes(DataGenerator gen) {
            super(gen);
        }

        protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
            this.getTier((IItemProvider)CobbleForDays.TIER1_BLOCK.get(), (Tag<Item>)ItemTags.field_200038_h).func_200464_a(consumer);
            this.getTier((IItemProvider)CobbleForDays.TIER2_BLOCK.get(), (Tag<Item>)Tags.Items.COBBLESTONE).func_200464_a(consumer);
            this.getTier((IItemProvider)CobbleForDays.TIER3_BLOCK.get(), (Tag<Item>)Tags.Items.INGOTS_IRON).func_200464_a(consumer);
            this.getTier((IItemProvider)CobbleForDays.TIER4_BLOCK.get(), (Tag<Item>)Tags.Items.INGOTS_GOLD).func_200464_a(consumer);
            this.getTier((IItemProvider)CobbleForDays.TIER5_BLOCK.get(), (Tag<Item>)Tags.Items.GEMS_DIAMOND).func_200464_a(consumer);
        }

        private ShapedRecipeBuilder getTier(IItemProvider item, Tag<Item> resource) {
            return ShapedRecipeBuilder.func_200470_a((IItemProvider)item).func_200462_a(Character.valueOf('W'), (IItemProvider)Items.field_151131_as).func_200462_a(Character.valueOf('L'), (IItemProvider)Items.field_151129_at).func_200462_a(Character.valueOf('G'), (IItemProvider)Blocks.field_150359_w).func_200469_a(Character.valueOf('R'), resource).func_200472_a("RRR").func_200472_a("WGL").func_200472_a("RRR").func_200465_a("has_lava", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_151129_at)).func_200465_a("has_water", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_151131_as));
        }
    }
}

