/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.config;

import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;
import owmii.powah.block.Tier;
import owmii.powah.config.EnergyConfig;

public class EnderCellConfig
extends EnergyConfig {
    public final Map<Tier, Integer> channels = new HashMap<Tier, Integer>();
    public final ForgeConfigSpec.IntValue starterChannels;
    public final ForgeConfigSpec.IntValue basicChannels;
    public final ForgeConfigSpec.IntValue hardenedChannels;
    public final ForgeConfigSpec.IntValue blazingChannels;
    public final ForgeConfigSpec.IntValue nioticChannels;
    public final ForgeConfigSpec.IntValue spiritedChannels;
    public final ForgeConfigSpec.IntValue nitroChannels;

    public EnderCellConfig(ForgeConfigSpec.Builder builder) {
        this(builder, new long[]{0L, 0L, 0L, 0L, 0L, 0L, 0L}, new long[]{200L, 2500L, 8000L, 20000L, 50000L, 100000L, 400000L}, new int[]{1, 2, 4, 6, 9, 12, 16});
    }

    public EnderCellConfig(ForgeConfigSpec.Builder builder, long[] caps, long[] trs, int[] channels) {
        super(builder, caps, trs);
        builder.push("Channels");
        this.starterChannels = builder.defineInRange("starterChannels", channels[0], 1, 16);
        this.basicChannels = builder.defineInRange("basicChannels", channels[1], 1, 16);
        this.hardenedChannels = builder.defineInRange("hardenedChannels", channels[2], 1, 16);
        this.blazingChannels = builder.defineInRange("blazingChannels", channels[3], 1, 16);
        this.nioticChannels = builder.defineInRange("nioticChannels", channels[4], 1, 16);
        this.spiritedChannels = builder.defineInRange("spiritedChannels", channels[5], 1, 16);
        this.nitroChannels = builder.defineInRange("nitroChannels", channels[6], 1, 16);
        builder.pop();
    }

    @Override
    public void reload() {
        super.reload();
        this.channels.put(Tier.STARTER, (Integer)this.starterChannels.get());
        this.channels.put(Tier.BASIC, (Integer)this.basicChannels.get());
        this.channels.put(Tier.HARDENED, (Integer)this.hardenedChannels.get());
        this.channels.put(Tier.BLAZING, (Integer)this.blazingChannels.get());
        this.channels.put(Tier.NIOTIC, (Integer)this.nioticChannels.get());
        this.channels.put(Tier.SPIRITED, (Integer)this.spiritedChannels.get());
        this.channels.put(Tier.NITRO, (Integer)this.nitroChannels.get());
    }

    public int getChannels(Tier variant) {
        if (this.channels.containsKey((Object)variant)) {
            return this.channels.get((Object)variant);
        }
        return 0;
    }

    @Override
    public long getCapacity(Tier variant) {
        return 0L;
    }
}

