/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.playertransmitter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import owmii.lib.block.AbstractBlock;
import owmii.lib.block.AbstractEnergyBlock;
import owmii.lib.block.TileBase;
import owmii.lib.config.IEnergyConfig;
import owmii.lib.energy.Energy;
import owmii.lib.inventory.ContainerBase;
import owmii.lib.util.IVariant;
import owmii.lib.util.Text;
import owmii.powah.block.Tier;
import owmii.powah.block.playertransmitter.PlayerTransmitterTile;
import owmii.powah.config.Configs;
import owmii.powah.config.PlayerTransmitterConfig;
import owmii.powah.inventory.IContainers;
import owmii.powah.inventory.PlayerTransmitterContainer;

public class PlayerTransmitterBlock
extends AbstractEnergyBlock<Tier> {
    private static final Map<Direction, VoxelShape> SHAPES = new HashMap<Direction, VoxelShape>();

    public PlayerTransmitterBlock(Block.Properties properties, Tier variant) {
        super(properties, (IVariant)variant);
        this.setDefaultState();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES.get(state.func_177229_b((IProperty)FACING));
    }

    public IEnergyConfig<Tier> getEnergyConfig() {
        return Configs.PLAYER_TRANSMITTER;
    }

    public int stackSize() {
        return 1;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new PlayerTransmitterTile((Tier)this.variant);
    }

    @Nullable
    public ContainerBase getContainer(int id, PlayerInventory playerInventory, TileBase te, BlockRayTraceResult result) {
        if (te instanceof PlayerTransmitterTile) {
            return new PlayerTransmitterContainer(IContainers.PLAYER_TRANSMITTER, id, playerInventory, (PlayerTransmitterTile)te);
        }
        return null;
    }

    protected boolean checkValidEnergySide() {
        return true;
    }

    protected AbstractBlock.Facing getFacing() {
        return AbstractBlock.Facing.ALL;
    }

    public void additionalEnergyInfo(ItemStack stack, Energy.Item energy, List<ITextComponent> tooltip) {
        tooltip.add(new TranslationTextComponent("info.powah.charging.speed", new Object[]{TextFormatting.DARK_GRAY + Text.numFormat((long)this.getChargingSpeed())}).func_211708_a(TextFormatting.GRAY));
    }

    public long getChargingSpeed() {
        return ((PlayerTransmitterConfig)this.getEnergyConfig()).getChargingSpeed((Tier)this.variant);
    }

    static {
        SHAPES.put(Direction.DOWN, PlayerTransmitterBlock.func_208617_a((double)10.0, (double)0.0, (double)10.0, (double)6.0, (double)14.0, (double)6.0));
        SHAPES.put(Direction.UP, PlayerTransmitterBlock.func_208617_a((double)10.0, (double)2.0, (double)10.0, (double)6.0, (double)16.0, (double)6.0));
        SHAPES.put(Direction.SOUTH, VoxelShapes.func_197878_a((VoxelShape)PlayerTransmitterBlock.func_208617_a((double)10.0, (double)6.0, (double)12.0, (double)6.0, (double)16.0, (double)8.0), (VoxelShape)PlayerTransmitterBlock.func_208617_a((double)10.0, (double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)16.0), (IBooleanFunction)IBooleanFunction.field_223244_o_));
        SHAPES.put(Direction.NORTH, VoxelShapes.func_197878_a((VoxelShape)PlayerTransmitterBlock.func_208617_a((double)10.0, (double)6.0, (double)8.0, (double)6.0, (double)16.0, (double)4.0), (VoxelShape)PlayerTransmitterBlock.func_208617_a((double)10.0, (double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)8.0), (IBooleanFunction)IBooleanFunction.field_223244_o_));
        SHAPES.put(Direction.EAST, VoxelShapes.func_197878_a((VoxelShape)PlayerTransmitterBlock.func_208617_a((double)12.0, (double)6.0, (double)10.0, (double)8.0, (double)16.0, (double)6.0), (VoxelShape)PlayerTransmitterBlock.func_208617_a((double)8.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0, (double)6.0), (IBooleanFunction)IBooleanFunction.field_223244_o_));
        SHAPES.put(Direction.WEST, VoxelShapes.func_197878_a((VoxelShape)PlayerTransmitterBlock.func_208617_a((double)8.0, (double)6.0, (double)10.0, (double)4.0, (double)16.0, (double)6.0), (VoxelShape)PlayerTransmitterBlock.func_208617_a((double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)6.0), (IBooleanFunction)IBooleanFunction.field_223244_o_));
    }
}

