/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.logic;

import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import vswe.stevesfactory.Config;
import vswe.stevesfactory.api.logic.IProcedure;
import vswe.stevesfactory.api.logic.IProcedureType;
import vswe.stevesfactory.api.visibility.GUIVisibility;
import vswe.stevesfactory.library.gui.RenderingHelper;
import vswe.stevesfactory.logic.SimpleProcedureType;
import vswe.stevesfactory.logic.procedure.BUDTriggerProcedure;
import vswe.stevesfactory.logic.procedure.CraftingProcedure;
import vswe.stevesfactory.logic.procedure.DummyBranchProcedure;
import vswe.stevesfactory.logic.procedure.FluidTransferProcedure;
import vswe.stevesfactory.logic.procedure.FunctionHatProcedure;
import vswe.stevesfactory.logic.procedure.FunctionInvokeProcedure;
import vswe.stevesfactory.logic.procedure.IntervalTriggerProcedure;
import vswe.stevesfactory.logic.procedure.ItemExportProcedure;
import vswe.stevesfactory.logic.procedure.ItemImportProcedure;
import vswe.stevesfactory.logic.procedure.ItemTransferProcedure;
import vswe.stevesfactory.logic.procedure.RedstoneEmitterProcedure;
import vswe.stevesfactory.logic.procedure.RedstoneTriggerProcedure;
import vswe.stevesfactory.logic.procedure.SignUpdaterProcedure;

@Mod.EventBusSubscriber(modid="sfm", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ModProcedures {
    public static IProcedureType<IntervalTriggerProcedure> intervalTrigger;
    public static IProcedureType<RedstoneTriggerProcedure> redstoneTrigger;
    public static IProcedureType<BUDTriggerProcedure> budTrigger;
    public static IProcedureType<ItemTransferProcedure> itemTransfer;
    public static IProcedureType<ItemImportProcedure> itemImport;
    public static IProcedureType<ItemExportProcedure> itemExport;
    public static IProcedureType<CraftingProcedure> crafting;
    public static IProcedureType<FluidTransferProcedure> fluidTransfer;
    public static IProcedureType<RedstoneEmitterProcedure> redstoneEmitter;
    public static IProcedureType<SignUpdaterProcedure> signUpdater;
    public static IProcedureType<DummyBranchProcedure> sequentialBranch;
    public static IProcedureType<DummyBranchProcedure> mergeBranch;
    public static IProcedureType<FunctionHatProcedure> functionHat;
    public static IProcedureType<FunctionInvokeProcedure> functionInvoke;

    private ModProcedures() {
    }

    @SubscribeEvent
    public static void onProcedureRegister(RegistryEvent.Register<IProcedureType<?>> event) {
        IForgeRegistry r = event.getRegistry();
        intervalTrigger = ModProcedures.create("interval_trigger", IntervalTriggerProcedure::new, Config.COMMON.enableIntervalTrigger);
        r.register(intervalTrigger);
        redstoneTrigger = ModProcedures.create("redstone_trigger", RedstoneTriggerProcedure::new, Config.COMMON.enableRedstoneTrigger);
        r.register(redstoneTrigger);
        budTrigger = ModProcedures.create("bud_trigger", BUDTriggerProcedure::new, Config.COMMON.enableBUDTrigger);
        r.register(budTrigger);
        itemTransfer = ModProcedures.create("item_transfer", ItemTransferProcedure::new, Config.COMMON.enableItemTransfer);
        r.register(itemTransfer);
        itemImport = ModProcedures.create("item_import", ItemImportProcedure::new, Config.COMMON.enableItemImport);
        r.register(itemImport);
        itemExport = ModProcedures.create("item_export", ItemExportProcedure::new, Config.COMMON.enableItemExport);
        r.register(itemExport);
        crafting = ModProcedures.create("crafting", CraftingProcedure::new, Config.COMMON.enableCrafting);
        r.register(crafting);
        fluidTransfer = ModProcedures.create("fluid_transfer", FluidTransferProcedure::new, Config.COMMON.enableFluidTransfer);
        r.register(fluidTransfer);
        redstoneEmitter = ModProcedures.create("redstone_emitter", RedstoneEmitterProcedure::new, Config.COMMON.enableRedstoneEmitter);
        r.register(redstoneEmitter);
        signUpdater = ModProcedures.create("sign_updater", SignUpdaterProcedure::new, Config.COMMON.enableSignUpdater);
        r.register(signUpdater);
        sequentialBranch = ModProcedures.create("sequential", DummyBranchProcedure::sequential, Config.COMMON.enableSequentialBranch);
        r.register(sequentialBranch);
        mergeBranch = ModProcedures.create("merge", DummyBranchProcedure::merge, Config.COMMON.enableMergeBranch);
        r.register(mergeBranch);
        functionHat = ModProcedures.create("function_hat", FunctionHatProcedure::functionHat, Config.COMMON.enableFunctionHat);
        r.register(functionHat);
        functionInvoke = ModProcedures.create("function_invoke", FunctionInvokeProcedure::new, Config.COMMON.enableFunctionInvoke);
        r.register(functionInvoke);
    }

    private static <P extends IProcedure> IProcedureType<P> create(String id, Supplier<P> constructor, ForgeConfigSpec.BooleanValue enabledGetter) {
        SimpleProcedureType<P> p = new SimpleProcedureType<P>(constructor, RenderingHelper.linkTexture("gui/procedure_icon", id + ".png"));
        ResourceLocation rl = new ResourceLocation("sfm", id);
        p.setRegistryName(rl);
        GUIVisibility.registerEnableState(rl, () -> ((ForgeConfigSpec.BooleanValue)enabledGetter).get());
        return p;
    }
}

